/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.misc;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.data.Pair;
import org.kingdoms.events.invasion.KingdomPreInvadeEvent;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextBuilder;
import org.kingdoms.managers.Masswar;
import org.kingdoms.managers.invasions.Invasion;
import org.kingdoms.managers.invasions.InvasionFactory;
import org.kingdoms.managers.land.protection.MiscUpgradeManager;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.cooldown.Cooldown;
import org.kingdoms.utils.string.StringUtils;
import org.kingdoms.utils.time.TimeFormatter;

public class CommandInvade
extends KingdomsCommand {
    private static final Cooldown<UUID> SHIELD_CONFIRMATION = new Cooldown();

    public CommandInvade() {
        super("invade", true);
    }

    private static CommandResult newbieProtection(CommandContext context, Kingdom kingdom, boolean defender) {
        long currTime = System.currentTimeMillis();
        String langPrefix = defender ? "defender" : "attacker";
        Long kingdomProtection = KingdomsConfig.CREATION_KINGDOMS_NEWBIE_PROTECTION.getTimeMillis();
        if (kingdomProtection != null && kingdomProtection > 0L) {
            long kingdomAge = currTime - kingdom.getSince();
            context.var("kingdom-newbie-protection", TimeFormatter.of(kingdomProtection));
            context.var("kingdom-newbie-protection-left", TimeFormatter.of(Math.max(0L, kingdomProtection - kingdomAge)));
            if (kingdomAge < kingdomProtection) {
                return context.fail(context.lang("newbie-protection", langPrefix, "kingdom"), new Object[0]);
            }
        }
        Nation nation = kingdom.getNation();
        Long nationProtection = KingdomsConfig.CREATION_NATIONS_NEWBIE_PROTECTION.getTimeMillis();
        if (nationProtection != null && nationProtection > 0L && nation != null) {
            long nationAge = currTime - nation.getSince();
            context.var("nation-newbie-protection", TimeFormatter.of(nationProtection));
            context.var("nation-newbie-protection-left", TimeFormatter.of(Math.max(0L, nationProtection - nationAge)));
            if (nationAge < nationProtection) {
                return context.fail(context.lang("newbie-protection", langPrefix, "nation"), new Object[0]);
            }
        }
        return null;
    }

    public static CommandResult execute(CommandContext context, boolean ransack) {
        KingdomPreInvadeEvent invasion;
        int invading;
        boolean notAdmin;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.isInvading()) {
            KingdomsLang.COMMAND_INVADE_ALREADY_INVADING.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        if (!kp.hasPermission(StandardKingdomPermission.INVADE)) {
            StandardKingdomPermission.INVADE.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        if (!kp.hasPermission(StandardKingdomPermission.CLAIM)) {
            return context.fail(KingdomsLang.COMMAND_INVADE_NO_CLAIM_PERMISSION, new Object[0]);
        }
        boolean bl = notAdmin = !kp.isAdmin();
        if (notAdmin && KingdomsConfig.Invasions.MASSWAR_DURING_MASSWAR_ONLY.getManager().getBoolean() && !Masswar.isRunning()) {
            KingdomsLang.COMMAND_INVADE_MASSWAR_ONLY.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        if (notAdmin && PlayerUtils.invulnerableGameMode(player)) {
            KingdomsLang.COMMAND_INVADE_CREATIVE.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        Kingdom attackerKingdom = kp.getKingdom();
        if (notAdmin && !MiscUpgradeManager.canInvade(attackerKingdom)) {
            KingdomsLang.COMMAND_INVADE_MAX_MISC_UPGRADE.sendError((CommandSender)player, new Object[0]);
            return CommandResult.FAILED;
        }
        int sim = KingdomsConfig.Invasions.SIMULTANEOUS_INVASIONS.getManager().getInt();
        if (sim > 0 && (invading = attackerKingdom.getInvasions().size()) >= sim) {
            KingdomsLang.COMMAND_INVADE_SIMULTANEOUS.sendMessage((CommandSender)player, "amount", sim);
            return CommandResult.FAILED;
        }
        Land land = Land.getLand(player.getLocation());
        if (land == null || !land.isClaimed()) {
            KingdomsLang.COMMAND_INVADE_NOT_CLAIMED.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        if (land.isBeingInvaded()) {
            KingdomsLang.COMMAND_INVADE_ALREADY_BEING_INVADED.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        Kingdom defenderKingdom = land.getKingdom();
        if (defenderKingdom.getId().equals(attackerKingdom.getId())) {
            KingdomsLang.COMMAND_INVADE_OWN_LAND.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        if (notAdmin && !attackerKingdom.hasAttribute(defenderKingdom, (RelationAttribute)StandardRelationAttribute.INVADE)) {
            KingdomRelation relation = attackerKingdom.getRelationWith(defenderKingdom);
            context.var("relation", relation.getColor() + relation.getName().buildPlain(context.getSettings()));
            return context.fail(KingdomsLang.COMMAND_INVADE_CEASEFIRE, new Object[0]);
        }
        if (notAdmin && KingdomsConfig.Invasions.PACIFISM_ENABLED.getManager().getBoolean() && (!Masswar.isRunning() || !KingdomsConfig.Invasions.MASSWAR_ALLOW_INVADING_PACIFISTS.getManager().getBoolean())) {
            if (attackerKingdom.isPacifist()) {
                KingdomsLang.COMMAND_INVADE_SELF_PACIFIST.sendError((CommandSender)player, new Object[0]);
                return CommandResult.FAILED;
            }
            if (defenderKingdom.isPacifist()) {
                KingdomsLang.COMMAND_INVADE_PACIFIST.sendError((CommandSender)player, new Object[0]);
                return CommandResult.FAILED;
            }
        }
        if (attackerKingdom.isStrongerThan(defenderKingdom)) {
            return context.fail(KingdomsLang.COMMAND_INVADE_HIGHER_STRENGTH, new Object[0]);
        }
        if (!kp.isAdmin() && KingdomsConfig.Invasions.CHALLENGES_ENABLED.getManager().getBoolean()) {
            Long challenge = defenderKingdom.getChallenges().get(attackerKingdom.getId());
            Long opponentChallenge = attackerKingdom.getChallenges().get(defenderKingdom.getId());
            if (challenge == null && opponentChallenge == null) {
                Pair<Integer, Integer> defendersNeeded = CommandInvade.meetsMinOnlineDefendersCondition(defenderKingdom);
                if (defendersNeeded != null && defendersNeeded.getKey() > defendersNeeded.getValue()) {
                    KingdomsLang.COMMAND_INVADE_MIN_DEFENDERS_NEEDED_CHALLENGE.sendMessage((CommandSender)player, "defenders", defendersNeeded.getKey(), "left", defendersNeeded.getValue());
                    return CommandResult.FAILED;
                }
                context.sendError(KingdomsLang.COMMAND_INVADE_NOT_CHALLENGED, "kingdom", defenderKingdom.getName());
                return CommandResult.FAILED;
            }
            long currTime = System.currentTimeMillis();
            boolean challengeNull = challenge == null;
            long challengeTime = challengeNull ? opponentChallenge : challenge;
            if (challenge == null) {
                challenge = Long.MAX_VALUE;
            }
            if (opponentChallenge == null) {
                opponentChallenge = Long.MAX_VALUE;
            }
            if (currTime < challenge || currTime < opponentChallenge) {
                context.sendError(challengeNull ? KingdomsLang.COMMAND_INVADE_CHALLENGE_NOT_STARTED_OPPONENT : KingdomsLang.COMMAND_INVADE_CHALLENGE_NOT_STARTED, "kingdom", defenderKingdom.getName(), "remaining-time", TimeFormatter.of(challengeTime - System.currentTimeMillis()));
            }
        }
        if (notAdmin) {
            Pair<Long, Boolean> cd = Invasion.getCooldown(attackerKingdom, defenderKingdom);
            if (cd != null) {
                (cd.getValue() != false ? KingdomsLang.COMMAND_INVADE_COOLDOWN_SUCCESSFUL : KingdomsLang.COMMAND_INVADE_COOLDOWN_FAILED).sendMessage((CommandSender)player, "kingdom", defenderKingdom.getName(), "cooldown", TimeFormatter.of(cd.getKey()));
                return CommandResult.FAILED;
            }
            Pair<Integer, Integer> defendersNeeded = CommandInvade.meetsMinOnlineDefendersCondition(defenderKingdom);
            if (defendersNeeded != null && defendersNeeded.getKey() > defendersNeeded.getValue()) {
                KingdomsLang.COMMAND_INVADE_MIN_DEFENDERS_NEEDED.sendMessage((CommandSender)player, "defenders", defendersNeeded.getValue());
                return CommandResult.FAILED;
            }
            int invadersNeeded = (int)MathUtils.eval(KingdomsConfig.Invasions.ONLINE_MEMBERS_INVADER.getManager().getString(), defenderKingdom, new Object[0]);
            if (invadersNeeded > 0) {
                int left = invadersNeeded;
                for (Player online : attackerKingdom.getOnlineMembers()) {
                    if (ServiceHandler.isAuthenticated(online) && left-- == 0) break;
                }
                if (left > 0) {
                    KingdomsLang.COMMAND_INVADE_MIN_INVADERS_NEEDED.sendMessage((CommandSender)player, "invaders", invadersNeeded, "left", left);
                    return CommandResult.FAILED;
                }
            }
        }
        if (notAdmin && InvasionFactory.coversAdjoiningProtection(land)) {
            KingdomsLang.COMMAND_INVADE_ADJOINING_PROTECTIOIN.sendError((CommandSender)player, new Object[0]);
            return CommandResult.FAILED;
        }
        Nation nation = defenderKingdom.getNation();
        if (notAdmin) {
            if (CommandInvade.newbieProtection(context, defenderKingdom, true) == CommandResult.FAILED) {
                return CommandResult.FAILED;
            }
            if (CommandInvade.newbieProtection(context, attackerKingdom, true) == CommandResult.FAILED) {
                return CommandResult.FAILED;
            }
        }
        Runnable deactivateShield = null;
        if (!(!notAdmin || Masswar.isRunning() && KingdomsConfig.Invasions.MASSWAR_ALLOW_INVADING_SHIELDS.getManager().getBoolean())) {
            long shield;
            long timePassedSinceLastInvade;
            boolean forceNationShield = KingdomsConfig.Invasions.NATIONS_USE_SHIELD.getManager().getBoolean();
            long nationShieldAccessLoss = KingdomsConfig.Invasions.SHIELDS_NATION_SHIELD_ACCESS_LOSS.getManager().getTimeMillis();
            context.var("access-loss-time", TimeFormatter.of(nationShieldAccessLoss));
            boolean useKingdomShieldForDefender = nation == null || defenderKingdom.hasShield() && !forceNationShield;
            long lastInvasion = defenderKingdom.getLastInvasion();
            if (!forceNationShield && nationShieldAccessLoss > 0L && (timePassedSinceLastInvade = System.currentTimeMillis() - lastInvasion) < nationShieldAccessLoss) {
                useKingdomShieldForDefender = true;
            }
            long l = shield = useKingdomShieldForDefender ? defenderKingdom.getShieldTimeLeft() : nation.getShieldTimeLeft();
            if (shield > 0L) {
                KingdomsLang lang = useKingdomShieldForDefender ? KingdomsLang.COMMAND_INVADE_SHIELD_DEFENDER_KINGDOM : KingdomsLang.COMMAND_INVADE_SHIELD_DEFENDER_NATION;
                lang.sendMessage((CommandSender)player, "shield", TimeFormatter.of(shield));
                return CommandResult.FAILED;
            }
            if (KingdomsConfig.Invasions.SHIELDS_DISALLOW_INVASIONS.getManager().getBoolean()) {
                long shield2;
                Nation invaderNation = attackerKingdom.getNation();
                boolean useKingdomShield = invaderNation == null || attackerKingdom.hasShield() && !forceNationShield;
                long lastInvasion2 = defenderKingdom.getLastInvasion();
                long timePassedSinceLastInvade2 = System.currentTimeMillis() - lastInvasion2;
                if (!forceNationShield && nationShieldAccessLoss > 0L && timePassedSinceLastInvade2 < nationShieldAccessLoss) {
                    useKingdomShield = true;
                }
                long l2 = shield2 = useKingdomShield ? attackerKingdom.getShieldTime() : invaderNation.getShieldTime();
                if (shield2 > 0L) {
                    if (SHIELD_CONFIRMATION.isInCooldown(player.getUniqueId())) {
                        SHIELD_CONFIRMATION.stop(player.getUniqueId());
                        if (!useKingdomShield && nationShieldAccessLoss > 0L) {
                            deactivateShield = () -> context.sendError(KingdomsLang.COMMAND_INVADE_SHIELD_INVADER_NATION_SHIELD_ACCESS_LOSS, new Object[0]);
                        } else {
                            boolean finUseKingdomShield = useKingdomShield;
                            deactivateShield = () -> {
                                KingdomsLang lang = finUseKingdomShield ? KingdomsLang.COMMAND_INVADE_SHIELD_INVADER_KINGDOM_DISABLED : KingdomsLang.COMMAND_INVADE_SHIELD_INVADER_NATION_DISABLED;
                                lang.sendMessage((CommandSender)player, "shield", TimeFormatter.of(shield2), "invader", player.getName(), "kingdom", defenderKingdom.getName());
                                if (finUseKingdomShield) {
                                    attackerKingdom.deactivateShield();
                                } else {
                                    invaderNation.deactivateShield();
                                }
                            };
                        }
                    } else {
                        KingdomsLang lang = useKingdomShield ? KingdomsLang.COMMAND_INVADE_SHIELD_INVADER_KINGDOM : KingdomsLang.COMMAND_INVADE_SHIELD_INVADER_NATION;
                        lang.sendMessage((CommandSender)player, "shield", TimeFormatter.of(shield2));
                        SHIELD_CONFIRMATION.add(player.getUniqueId(), 5L, TimeUnit.SECONDS);
                        return CommandResult.FAILED;
                    }
                }
            }
        }
        if (notAdmin && nation != null && InvasionFactory.nationCapitalRadiusProtection(nation, defenderKingdom, player, land)) {
            return CommandResult.FAILED;
        }
        Pair<Set<SimpleChunkLocation>, Map<SimpleChunkLocation, Structure>> results = InvasionFactory.getAffectedLands(land);
        Set<SimpleChunkLocation> acceptedLands = results.getKey();
        Map<SimpleChunkLocation, Structure> rejectedPCLands = results.getValue();
        if (!rejectedPCLands.isEmpty()) {
            KingdomsLang.COMMAND_INVADE_POWERCELL.sendMessage((CommandSender)player);
            if (acceptedLands.isEmpty()) {
                return CommandResult.FAILED;
            }
        }
        if (notAdmin && !InvasionFactory.handleMaxClaims(player.getWorld(), context, kp, attackerKingdom, 1)) {
            return CommandResult.FAILED;
        }
        if (notAdmin) {
            Pair<Long, Double> costs = InvasionFactory.getInvasionCosts(player, ransack);
            long rpCost = costs.getKey();
            double money = costs.getValue();
            if (!attackerKingdom.hasMoney(money) || !attackerKingdom.hasResourcePoints(rpCost)) {
                KingdomsLang.COMMAND_INVADE_COSTS.sendError((CommandSender)player, "rp", StringUtils.toFancyNumber(rpCost), "money", StringUtils.toFancyNumber(money));
                return CommandResult.FAILED;
            }
            attackerKingdom.addResourcePoints(-rpCost);
            attackerKingdom.addBank(-money);
        }
        if ((invasion = InvasionFactory.standardInvasion(land, acceptedLands, player, ransack)).isCancelled()) {
            return CommandResult.FAILED;
        }
        if (deactivateShield != null) {
            deactivateShield.run();
        }
        KingdomsLang.COMMAND_INVADE_INVADING.sendMessage((CommandSender)player, "kingdom", defenderKingdom.getName());
        if (KingdomsConfig.Invasions.COUNTDOWN_SHOW_TO_DEFENDER.getManager().getBoolean()) {
            for (Player member : defenderKingdom.getOnlineMembers()) {
                KingdomsLang.COMMAND_INVADE_INVADING_DEFENDER_NOTIFY.sendMessage((CommandSender)member, "invader", player.getName());
            }
        }
        for (Player member : attackerKingdom.getOnlineMembers()) {
            KingdomsLang.COMMAND_INVADE_ANNOUNCEMENT.sendMessage((CommandSender)member, "invader", player.getName(), "kingdom", defenderKingdom.getName(), "location", land.getLocation());
        }
        return CommandResult.SUCCESS;
    }

    public static Pair<Integer, Integer> meetsMinOnlineDefendersCondition(Kingdom defenderKingdom) {
        int defendersNeeded = (int)MathUtils.eval(KingdomsConfig.Invasions.ONLINE_MEMBERS_DEFENDER.getManager().getMathExpression(), new PlaceholderContextBuilder().withContext(defenderKingdom));
        if (defendersNeeded <= 0) {
            return null;
        }
        int onlinePlayers = 0;
        for (Player online : defenderKingdom.getOnlineMembers()) {
            if (!ServiceHandler.isAuthenticated(online)) continue;
            ++onlinePlayers;
        }
        return Pair.of(defendersNeeded, onlinePlayers);
    }

    @Override
    public CommandResult executeX(CommandContext context) {
        return CommandInvade.execute(context, false);
    }
}

