/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.misc;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.upgradable.MiscUpgrade;
import org.kingdoms.constants.group.upgradable.Powerup;
import org.kingdoms.constants.group.upgradable.champion.ChampionUpgrade;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.events.general.GroupDisband;
import org.kingdoms.events.lands.ClaimLandEvent;
import org.kingdoms.libs.caffeine.cache.Cache;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.LanguageEntry;
import org.kingdoms.locale.messenger.LanguageEntryMessenger;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.ConditionProcessor;
import org.kingdoms.utils.cache.CacheHandler;
import org.kingdoms.utils.compilers.ConditionalCompiler;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.config.NodeInterpreter;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/kingdoms/commands/general/misc/CommandMerge;", "Lorg/kingdoms/commands/KingdomsCommand;", "()V", "executeX", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "tabComplete", "", "", "Lorg/kingdoms/commands/CommandTabContext;", "Companion", "core"})
public final class CommandMerge
extends KingdomsCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Cache<UUID, UUID> sentRequests = CacheHandler.newBuilder().expireAfterWrite(Duration.ofSeconds(30L)).build();
    private static final Cache<UUID, UUID> receivedRequests = CacheHandler.newBuilder().expireAfterWrite(Duration.ofSeconds(30L)).build();

    public CommandMerge() {
        super("merge", true);
    }

    @Override
    @NotNull
    public CommandResult executeX(@NotNull CommandContext context) {
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        KingdomPlayer kp = context.getKingdomPlayer();
        Rank rank = kp.getRank();
        Boolean bl = rank != null ? Boolean.valueOf(rank.isKing()) : null;
        Intrinsics.checkNotNull((Object)bl);
        if (!bl.booleanValue()) {
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_MERGE_ONLY_KING, new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"context.fail(KingdomsLang.COMMAND_MERGE_ONLY_KING)");
            return commandResult;
        }
        Kingdom ownKingdom = context.getKingdom();
        Kingdom kingdom = context.getKingdom(0);
        if (kingdom == null) {
            return CommandResult.FAILED;
        }
        Kingdom targetKingdom = kingdom;
        if (Intrinsics.areEqual((Object)ownKingdom.getDataKey(), (Object)targetKingdom.getDataKey())) {
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_MERGE_OWN, new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"context.fail(KingdomsLang.COMMAND_MERGE_OWN)");
            return commandResult;
        }
        ConfigSection senderConditions = KingdomsConfig.MERGING_CONDITIONS_SENDER.getManager().getSection().getSection();
        for (String string : senderConditions.getKeys()) {
            if (!ConditionProcessor.process(ConditionalCompiler.compile(string).evaluate(), new MessageBuilder().withContext(ownKingdom).other(targetKingdom))) continue;
            context.getSettings().raw("error", string);
            LanguageEntry languageEntry = senderConditions.get(NodeInterpreter.MESSAGE_ENTRY, string);
            Intrinsics.checkNotNullExpressionValue((Object)languageEntry, (String)"senderConditions.get(Nod\u2026reter.MESSAGE_ENTRY, key)");
            Messenger msg = new LanguageEntryMessenger(languageEntry);
            if (msg.getProvider(kp.getLanguage()) == null) {
                msg = KingdomsLang.COMMAND_MERGE_FAILED_UNKNOWN;
            }
            CommandResult commandResult = context.fail(msg, new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"context.fail(msg)");
            return commandResult;
        }
        ConfigSection receiverConditions = KingdomsConfig.MERGING_CONDITIONS_RECEIVER.getManager().getSection().getSection();
        for (String key : receiverConditions.getKeys()) {
            if (!ConditionProcessor.process(ConditionalCompiler.compile(key).evaluate(), new MessageBuilder().withContext(targetKingdom).other(ownKingdom))) continue;
            context.getSettings().raw("error", key);
            LanguageEntry languageEntry = receiverConditions.get(NodeInterpreter.MESSAGE_ENTRY, key);
            Intrinsics.checkNotNullExpressionValue((Object)languageEntry, (String)"receiverConditions.get(N\u2026reter.MESSAGE_ENTRY, key)");
            Messenger msg = new LanguageEntryMessenger(languageEntry);
            if (msg.getProvider(kp.getLanguage()) == null) {
                msg = KingdomsLang.COMMAND_MERGE_FAILED_UNKNOWN;
            }
            CommandResult commandResult = context.fail(msg, new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"context.fail(msg)");
            return commandResult;
        }
        UUID uUID = (UUID)sentRequests.getIfPresent((Object)ownKingdom.getDataKey());
        if (uUID != null) {
            Kingdom sentKingdom = Kingdom.getKingdom(uUID);
            context.getSettings().withContext(sentKingdom);
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_MERGE_ALREADY_SENT, new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"context.fail(KingdomsLan\u2026MMAND_MERGE_ALREADY_SENT)");
            return commandResult;
        }
        if (sentRequests.getIfPresent((Object)targetKingdom.getDataKey()) != null) {
            Player x;
            sentRequests.invalidate((Object)targetKingdom.getDataKey());
            receivedRequests.invalidate((Object)ownKingdom.getDataKey());
            Intrinsics.checkNotNullExpressionValue((Object)ownKingdom, (String)"ownKingdom");
            Companion.merge(targetKingdom, ownKingdom);
            context.getSettings().raw("kingdom", targetKingdom.getName());
            List<Player> list2 = ownKingdom.getOnlineMembers();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"ownKingdom.onlineMembers");
            $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                x = (Player)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)x, (String)"x");
                context.sendMessage((CommandSender)x, KingdomsLang.COMMAND_MERGE_MERGED_RECEIVER, new Object[0]);
            }
            context.getSettings().raw("kingdom", ownKingdom.getName());
            List<Player> list3 = targetKingdom.getOnlineMembers();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"targetKingdom.onlineMembers");
            $this$forEach$iv = list3;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                x = (Player)element$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)x, (String)"x");
                context.sendMessage((CommandSender)x, KingdomsLang.COMMAND_MERGE_MERGED_SENDER, new Object[0]);
            }
            return CommandResult.SUCCESS;
        }
        sentRequests.put((Object)ownKingdom.getDataKey(), (Object)targetKingdom.getDataKey());
        receivedRequests.put((Object)targetKingdom.getDataKey(), (Object)ownKingdom.getDataKey());
        context.getSettings().withContext(targetKingdom);
        context.sendMessage(KingdomsLang.COMMAND_MERGE_REQUEST_SENT, new Object[0]);
        context.getSettings().withContext(ownKingdom);
        List<Player> list4 = targetKingdom.getOnlineMembers();
        Intrinsics.checkNotNullExpressionValue(list4, (String)"targetKingdom.onlineMembers");
        $this$forEach$iv = list4;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player x = (Player)element$iv;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)x, (String)"x");
            context.sendMessage((CommandSender)x, KingdomsLang.COMMAND_MERGE_REQUEST_RECEIVED, new Object[0]);
        }
        return CommandResult.SUCCESS;
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandTabContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List<String> list2 = context.getKingdoms(0);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"context.getKingdoms(0)");
        return list2;
    }

    @JvmStatic
    public static final void merge(@NotNull Kingdom from, @NotNull Kingdom to) {
        Companion.merge(from, to);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0007RN\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0007\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/kingdoms/commands/general/misc/CommandMerge$Companion;", "", "()V", "receivedRequests", "Lorg/kingdoms/libs/caffeine/cache/Cache;", "Ljava/util/UUID;", "org.kingdoms.libs.kotlin.jvm.PlatformType", "sentRequests", "merge", "", "from", "Lorg/kingdoms/constants/group/Kingdom;", "to", "core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void merge(@NotNull Kingdom from, @NotNull Kingdom to) {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            Map<Enum, Integer> map;
            Integer n;
            MiscUpgrade miscUpgrade;
            UUID[] x;
            Object element$iv;
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            to.addResourcePoints(from.getResourcePoints());
            to.addBank(from.getBank());
            Map<MiscUpgrade, Integer> map2 = from.getMiscUpgrades();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"from.miscUpgrades");
            Map<Enum, Integer> $this$forEach$iv2 = map2;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Enum, Integer>> iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                x = element$iv = iterator.next();
                boolean bl = false;
                Integer n2 = to.getMiscUpgrades().get(x.getKey());
                int n3 = n2 != null ? n2 : 0;
                Integer n4 = x.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)n4, (String)"x.value");
                if (n3 >= ((Number)n4).intValue()) continue;
                Intrinsics.checkNotNullExpressionValue(to.getMiscUpgrades(), (String)"to.miscUpgrades");
                miscUpgrade = x.getKey();
                n = x.getValue();
                map.put(miscUpgrade, n);
            }
            Map<ChampionUpgrade, Integer> map3 = from.getChampionUpgrades();
            Intrinsics.checkNotNullExpressionValue(map3, (String)"from.championUpgrades");
            $this$forEach$iv2 = map3;
            $i$f$forEach = false;
            iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                x = element$iv = iterator.next();
                boolean bl = false;
                Integer n5 = to.getChampionUpgrades().get(x.getKey());
                int n6 = n5 != null ? n5 : 0;
                Integer n7 = x.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)n7, (String)"x.value");
                if (n6 >= ((Number)n7).intValue()) continue;
                Intrinsics.checkNotNullExpressionValue(to.getChampionUpgrades(), (String)"to.championUpgrades");
                miscUpgrade = x.getKey();
                n = x.getValue();
                map.put(miscUpgrade, n);
            }
            Map<Powerup, Integer> map4 = from.getPowerups();
            Intrinsics.checkNotNullExpressionValue(map4, (String)"from.powerups");
            $this$forEach$iv2 = map4;
            $i$f$forEach = false;
            iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                x = element$iv = iterator.next();
                boolean bl = false;
                Integer n8 = to.getPowerups().get(x.getKey());
                int n9 = n8 != null ? n8 : 0;
                Integer n10 = x.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)n10, (String)"x.value");
                if (n9 >= ((Number)n10).intValue()) continue;
                Intrinsics.checkNotNullExpressionValue(to.getPowerups(), (String)"to.powerups");
                miscUpgrade = x.getKey();
                n = x.getValue();
                map.put(miscUpgrade, n);
            }
            Set<UUID> set = from.getMembers();
            Intrinsics.checkNotNullExpressionValue(set, (String)"from.members");
            Collection $this$toTypedArray$iv = set;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            UUID[] uUIDArray = thisCollection$iv.toArray(new UUID[0]);
            Intrinsics.checkNotNull((Object)uUIDArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            UUID[] members = uUIDArray;
            Set locs = new HashSet(from.getLandLocations());
            from.disband(GroupDisband.Reason.CUSTOM);
            to.claim(locs, from.getKing(), ClaimLandEvent.Reason.CUSTOM, false);
            Object $this$map$iv = members;
            boolean $i$f$map = false;
            x = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((UUID[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n11 = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n11; ++i) {
                void x2;
                void item$iv$iv;
                void var13_22 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(KingdomPlayer.getKingdomPlayer((UUID)x2));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv) {
                KingdomPlayer x3 = (KingdomPlayer)element$iv2;
                boolean bl = false;
                x3.joinKingdom(to);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

