/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.builders.MessageObjectLinker;
import org.kingdoms.locale.compiler.builders.MessageObjectWithContext;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.internal.Fn;

public class CommandShow
extends KingdomsCommand {
    private static final int RELATION_LIMIT = 30;

    public CommandShow() {
        super("show", true);
    }

    private static void show(CommandSender sender, Kingdom kingdom, @NonNull OfflinePlayer placeholder, boolean admin) {
        SupportedLanguage locale = LanguageManager.localeOf(sender);
        OfflinePlayer king = Bukkit.getOfflinePlayer((UUID)kingdom.getKingId());
        KingdomsLang kingStatus = king.isOnline() ? KingdomsLang.COMMAND_SHOW_ONLINE_PREFIX : KingdomsLang.COMMAND_SHOW_OFFLINE_PREFIX;
        MessageObjectWithContext kingBuilder = new MessageObjectWithContext(kingStatus.getMessageObject(locale), new MessageBuilder().withContext(king));
        MessageObjectLinker membersBuilder = new MessageObjectLinker();
        List<KingdomPlayer> members = kingdom.getKingdomPlayers();
        members.sort(KingdomPlayer::compareTo);
        for (OfflinePlayer player : (OfflinePlayer[])members.stream().map(KingdomPlayer::getOfflinePlayer).toArray(OfflinePlayer[]::new)) {
            boolean isOnline;
            Player online = player.getPlayer();
            boolean bl = isOnline = online != null;
            if (isOnline && ServiceHandler.isVanished(online) && !KingdomsPluginPermission.COMMAND_SHOW_SEE_VANISHED.hasPermission(sender, true)) {
                isOnline = false;
            }
            KingdomsLang memberStatus = isOnline ? KingdomsLang.COMMAND_SHOW_ONLINE_PREFIX : KingdomsLang.COMMAND_SHOW_OFFLINE_PREFIX;
            membersBuilder.add(memberStatus.getMessageObject(locale), new MessageBuilder().withContext(player));
            membersBuilder.add(" ");
        }
        MessageObjectLinker allies = new MessageObjectLinker();
        MessageObjectLinker truces = new MessageObjectLinker();
        MessageObjectLinker enemies = new MessageObjectLinker();
        int ally = 0;
        int truce = 0;
        int enemy = 0;
        ArrayList<UUID> remove = new ArrayList<UUID>();
        for (Map.Entry<UUID, KingdomRelation> relation : kingdom.getRelations().entrySet()) {
            Kingdom otherKingdom = Kingdom.getKingdom(relation.getKey());
            if (otherKingdom == null) {
                remove.add(relation.getKey());
                KLogger.error("Unknown kingdom while mapping relations of kingdom " + kingdom.getName() + ": " + relation.getKey());
                continue;
            }
            KingdomRelation rel = relation.getValue();
            MessageBuilder settings = new MessageBuilder().withContext(otherKingdom).other(kingdom);
            MessageObject msg = KingdomsLang.COMMAND_SHOW_RELATION.getMessageObject(locale);
            switch (rel) {
                case ALLY: {
                    if (ally == 30) {
                        allies.add("...");
                    } else if (ally < 30) {
                        allies.add(msg, settings).add(" ");
                    }
                    ++ally;
                    break;
                }
                case TRUCE: {
                    if (truce == 30) {
                        truces.add("...");
                    } else if (truce < 30) {
                        truces.add(msg, settings).add(" ");
                    }
                    ++truce;
                    break;
                }
                case ENEMY: {
                    if (enemy == 30) {
                        enemies.add("...");
                    } else if (enemy < 30) {
                        enemies.add(msg, settings).add(" ");
                    }
                    ++enemy;
                }
            }
        }
        for (UUID id : remove) {
            kingdom.getRelations().remove(id);
        }
        MessageBuilder settings = new MessageBuilder().raws("king_status", kingBuilder, "members", membersBuilder, "truces", truces, "allies", allies, "enemies", enemies);
        settings.withContext(placeholder);
        if (sender instanceof Player) {
            settings.other((Player)sender);
        }
        KingdomsLang lang = admin ? KingdomsLang.COMMAND_SHOW_MESSAGE_ADMIN : KingdomsLang.COMMAND_SHOW_MESSAGE;
        lang.sendMessage(sender, settings);
        if (ally != 0) {
            KingdomsLang.COMMAND_SHOW_ALLIES.sendMessage(sender, new MessageBuilder().raws("allies", allies));
        }
        if (truce != 0) {
            KingdomsLang.COMMAND_SHOW_TRUCES.sendMessage(sender, new MessageBuilder().raws("truces", truces));
        }
        if (enemy != 0) {
            KingdomsLang.COMMAND_SHOW_ENEMIES.sendMessage(sender, new MessageBuilder().raws("enemies", enemies));
        }
    }

    @Override
    public void execute(CommandContext context) {
        OfflinePlayer placeholder;
        Kingdom kingdom;
        if (!context.isPlayer() && context.requireArgs(1)) {
            return;
        }
        boolean admin = context.hasPermission(KingdomsPluginPermission.COMMAND_SHOW_ADMIN, true);
        if (context.argsLengthEquals(0)) {
            if (context.assertHasKingdom()) {
                return;
            }
            Player player = context.senderAsPlayer();
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            kingdom = kp.getKingdom();
            placeholder = player;
            admin = true;
        } else {
            kingdom = (Kingdom)context.generalSelector(false);
            if (kingdom == null) {
                return;
            }
            placeholder = kingdom.getKing().getOfflinePlayer();
        }
        if (!admin) {
            admin = kingdom.isMember((OfflinePlayer)context.senderAsPlayer());
        }
        if (!admin && !context.hasPermission(KingdomsPluginPermission.COMMAND_SHOW_OTHERS)) {
            context.sendError(KingdomsLang.COMMAND_SHOW_OTHERS_PERMISSION, new Object[0]);
            return;
        }
        CommandShow.show(context.getSender(), kingdom, placeholder, admin);
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        return context.tabCompleteGeneralSelector(false, true, Fn.alwaysTrue());
    }
}

