/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.misc.chat;

import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;

public class CommandBroadcast
extends KingdomsCommand {
    public CommandBroadcast() {
        super("broadcast", true);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(1)) {
            return;
        }
        if (context.assertHasKingdom()) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasPermission(StandardKingdomPermission.BROADCAST)) {
            StandardKingdomPermission.BROADCAST.sendDeniedMessage(player);
            return;
        }
        String message = context.joinArgs();
        MessageBuilder settings = new MessageBuilder().parse("message", message).withContext(player);
        @NonNull List<Player> members = kp.getKingdom().getOnlineMembers();
        Bukkit.getOnlinePlayers().stream().filter(x -> KingdomPlayer.getKingdomPlayer((OfflinePlayer)x).isSpy()).forEach(members::add);
        for (Player member : members) {
            KingdomsLang.COMMAND_BROADCAST_FORMAT.sendMessage((CommandSender)member, settings);
        }
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (args.length == 1) {
            return Collections.singletonList("<message>");
        }
        return CommandBroadcast.emptyTab();
    }
}

