/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.misc.mails;

import java.util.Map;
import java.util.UUID;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.misc.mails.CommandMailOpen;
import org.kingdoms.commands.general.misc.mails.CommandMailReply;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.mails.Mail;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.mails.MailUserAgent;
import org.kingdoms.utils.internal.FastUUID;

public class CommandMail
extends KingdomsParentCommand {
    public CommandMail() {
        super("mail", true);
        new CommandMailReply(this);
        new CommandMailOpen(this);
    }

    protected static Mail handleCommons(CommandContext context) {
        UUID uuid;
        if (context.assertPlayer()) {
            return null;
        }
        if (!context.argsLengthEquals(1)) {
            context.wrongUsage();
            context.sendError(KingdomsLang.COMMAND_NOT_INTENDED_FOR_DIRECT_USE, new Object[0]);
            return null;
        }
        if (context.assertHasKingdom()) {
            return null;
        }
        KingdomPlayer kp = context.getKingdomPlayer();
        if (!kp.hasPermission(StandardKingdomPermission.MANAGE_MAILS)) {
            StandardKingdomPermission.MANAGE_MAILS.sendDeniedMessage(context.senderAsPlayer());
            return null;
        }
        String id = context.arg(0);
        context.var("id", id);
        try {
            uuid = FastUUID.fromString(id);
        }
        catch (IllegalArgumentException | StringIndexOutOfBoundsException ex) {
            context.sendError(KingdomsLang.COMMAND_MAIL_INVALID_ID, new Object[0]);
            context.sendError(KingdomsLang.COMMAND_NOT_INTENDED_FOR_DIRECT_USE, new Object[0]);
            return null;
        }
        Mail mail = Mail.getMail(uuid);
        if (mail == null) {
            context.sendError(KingdomsLang.COMMAND_MAIL_NOT_FOUND, new Object[0]);
            context.sendError(KingdomsLang.COMMAND_NOT_INTENDED_FOR_DIRECT_USE, new Object[0]);
            return null;
        }
        context.getSettings().addAll((Map)MailUserAgent.getEditsForMail(mail).getPlaceholders());
        Kingdom kingdom = kp.getKingdom();
        if (!mail.getRecipients().containsKey(kingdom.getId())) {
            context.sendError(KingdomsLang.COMMAND_MAIL_NOT_YOURS, new Object[0]);
            context.sendError(KingdomsLang.COMMAND_NOT_INTENDED_FOR_DIRECT_USE, new Object[0]);
            return null;
        }
        return mail;
    }
}

