/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.ranking;

import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.general.KingdomKingChangeEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandKing
extends KingdomsCommand {
    public CommandKing() {
        super("king", true);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(1)) {
            return;
        }
        if (context.assertHasKingdom()) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.getRank().isKing()) {
            KingdomsLang.COMMAND_KING_ONLY_KING.sendError((CommandSender)player, new Object[0]);
            return;
        }
        OfflinePlayer king = context.getOfflinePlayer(0);
        if (king == null) {
            return;
        }
        KingdomPlayer kingKp = KingdomPlayer.getKingdomPlayer(king);
        if (!kingKp.hasKingdom() || !kingKp.getKingdomId().equals(kp.getKingdomId())) {
            KingdomsLang.COMMAND_KING_NOT_IN_KINGDOM.sendError((CommandSender)player, "king", king.getName());
            return;
        }
        if (king.getUniqueId().equals(player.getUniqueId())) {
            KingdomsLang.COMMAND_KING_SELF.sendError((CommandSender)player, new Object[0]);
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (kingdom.setKing(kingKp, KingdomKingChangeEvent.Reason.KINGS_DECISION).isCancelled()) {
            return;
        }
        Object[] edits = new Object[]{"player", player.getName(), "rank", kingKp.getRank().getName(), "king", king.getName()};
        if (KingdomsConfig.ANNOUNCEMENTS_KING.getBoolean()) {
            KingdomsLang.COMMAND_KING_SET.sendEveryoneMessage(edits);
        } else {
            for (Player member : kingdom.getOnlineMembers()) {
                KingdomsLang.COMMAND_KING_SET.sendMessage((CommandSender)member, edits);
            }
        }
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            Kingdom kingdom = kp.getKingdom();
            if (kingdom == null) {
                return CommandKing.tabComplete(KingdomsLang.NO_KINGDOM_DEFAULT.parse(player, new Object[0]));
            }
            if (args.length == 1) {
                return TabCompleteManager.getKingdomPlayers(kingdom, args[0]);
            }
        }
        return CommandKing.emptyTab();
    }
}

