/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.relation;

import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.KingdomRelationshipRequest;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.RelationUtil;
import org.kingdoms.utils.time.TimeFormatter;
import org.kingdoms.utils.time.TimeUtils;

public class CommandRelations
extends KingdomsCommand {
    public CommandRelations() {
        super("relations", true);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        if (context.assertHasKingdom()) {
            return;
        }
        Player player = context.senderAsPlayer();
        Kingdom kingdom = context.getKingdom();
        Map<UUID, KingdomRelationshipRequest> requests = kingdom.getRelationshipRequests();
        if (requests.isEmpty()) {
            KingdomsLang.COMMAND_RELATIONS_NO_REQUESTS.sendError((CommandSender)player, new Object[0]);
            return;
        }
        CommandRelations.openRelationsGUI(player, kingdom);
    }

    public static InteractiveGUI openRelationsGUI(Player player, Kingdom kingdom) {
        InteractiveGUI gui = GUIAccessor.prepare(player, KingdomsGUI.KINGDOM$RELATION$REQUESTS);
        if (gui == null) {
            return null;
        }
        gui.push("back", () -> ((Player)player).closeInventory(), new Object[0]);
        ReusableOptionHandler inviteOpt = gui.getReusableOption("request");
        for (Map.Entry<UUID, KingdomRelationshipRequest> requestEntry : kingdom.getRelationshipRequests().entrySet()) {
            KingdomRelationshipRequest request = requestEntry.getValue();
            OfflinePlayer sender = Bukkit.getOfflinePlayer((UUID)request.getSender());
            boolean expired = !request.canAccept();
            UUID kingdomId = requestEntry.getKey();
            Kingdom requestedKingdom = Kingdom.getKingdom(requestEntry.getKey());
            boolean invalid = requestedKingdom == null;
            KingdomRelation rel = request.getRelation();
            ReusableOptionHandler opt = inviteOpt.setEdits("expired", expired, "invalid", invalid, "sender", sender.getName(), "timestamp", TimeUtils.getDateAndTime(request.getTimestamp()));
            opt.getSettings().raw("time-passed", TimeFormatter.of(System.currentTimeMillis() - request.getTimestamp())).raw("time-left-to-accpet", TimeFormatter.of(request.getTimeLeftToAccept())).raw("relation-name", rel.getName()).raw("relation-color", rel.getColor()).withContext(requestedKingdom);
            ((ReusableOptionHandler)opt.on(ClickType.LEFT, context -> {
                if (!expired && !invalid) {
                    RelationUtil.acceptRequest(player, kingdom, requestedKingdom, request.getRelation(), RelationUtil.getAcceptMsgOf(request.getRelation()));
                }
                kingdom.getRelationshipRequests().remove(kingdomId);
                CommandRelations.openRelationsGUI(player, kingdom);
            })).on(ClickType.RIGHT, ctx -> {
                if (!invalid) {
                    ctx.sendError(KingdomsLang.COMMAND_REJECTRELATION_REJECTED, new Object[0]);
                    for (Player member : requestedKingdom.getOnlineMembers()) {
                        KingdomsLang.COMMAND_REJECTRELATION_NOTIFICATION.sendError((CommandSender)member, new MessageBuilder().withContext(player).parse("relation", rel.getColor() + rel.getName().buildPlain(ctx.getSettings())));
                    }
                }
                kingdom.getRelationshipRequests().remove(kingdomId);
                CommandRelations.openRelationsGUI(player, kingdom);
            }).pushHead(sender);
            if (inviteOpt.hasNext()) continue;
            break;
        }
        gui.push("decline-all", () -> {
            kingdom.getRelationshipRequests().clear();
            CommandRelations.openRelationsGUI(player, kingdom);
        }, new Object[0]);
        gui.open();
        return gui;
    }
}

