/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.teleports;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.teleportation.TeleportRequest;
import org.kingdoms.managers.teleportation.TpManager;
import org.kingdoms.utils.time.TimeUtils;

public class CommandTpa
extends KingdomsCommand {
    protected static final Map<UUID, TeleportRequest> SENT_REQUESTS = new HashMap<UUID, TeleportRequest>();
    protected static final Map<UUID, Set<UUID>> RECEIVED_REQUESTS = new HashMap<UUID, Set<UUID>>();

    public CommandTpa() {
        super("tpa", true);
    }

    static void sendRequest(final CommandContext context, final Player teleporter, final Player target, long expireTicks) {
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                SENT_REQUESTS.remove(teleporter.getUniqueId());
                Set<UUID> requests = RECEIVED_REQUESTS.get(target.getUniqueId());
                if (requests != null) {
                    requests.remove(teleporter.getUniqueId());
                    if (requests.isEmpty()) {
                        RECEIVED_REQUESTS.remove(target.getUniqueId());
                    }
                }
                KingdomsLang.COMMAND_TPA_EXPIRED_TELEPORTER.sendError((CommandSender)teleporter, context.getSettings());
                KingdomsLang.COMMAND_TPA_EXPIRED_TARGET.sendError((CommandSender)target, context.getSettings());
            }
        }.runTaskLaterAsynchronously((Plugin)plugin, expireTicks);
        TeleportRequest request = new TeleportRequest(teleporter, target, task);
        SENT_REQUESTS.put(teleporter.getUniqueId(), request);
        RECEIVED_REQUESTS.compute(target.getUniqueId(), (k, v) -> {
            if (v == null) {
                v = new HashSet<UUID>(2);
            }
            v.add(teleporter.getUniqueId());
            return v;
        });
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        if (context.assertHasKingdom()) {
            return;
        }
        if (context.requireArgs(1)) {
            return;
        }
        Player teleporter = context.senderAsPlayer();
        if (TpManager.alreadyTping(teleporter)) {
            return;
        }
        Player target = context.getPlayer(0);
        if (target == null) {
            return;
        }
        context.var("target", target.getName());
        context.var("teleporter", teleporter.getName());
        if (teleporter.getUniqueId().equals(target.getUniqueId())) {
            context.sendMessage(KingdomsLang.COMMAND_TPA_YOURSELF, new Object[0]);
            teleporter.teleport((Entity)teleporter);
            return;
        }
        KingdomPlayer targetKp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)target);
        Kingdom targetKingdom = targetKp.getKingdom();
        if (targetKingdom == null) {
            context.sendError(KingdomsLang.NOT_FOUND_PLAYER_NO_KINGDOM, new Object[0]);
            return;
        }
        Kingdom kingdom = context.getKingdom();
        if (!CommandTpa.canRequest(kingdom, targetKingdom)) {
            context.sendError(KingdomsLang.COMMAND_TPA_NOT_FRIENDLY, new Object[0]);
            return;
        }
        TeleportRequest previousRequest = SENT_REQUESTS.get(teleporter.getUniqueId());
        if (previousRequest != null) {
            context.var("previous-request-player", previousRequest.getTarget().getName());
            context.var("previous-request-time", TimeUtils.getTime(previousRequest.getSentTime()));
            context.sendError(KingdomsLang.COMMAND_TPA_PENDING_REQUEST, new Object[0]);
            return;
        }
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)teleporter)) {
            context.sendError(KingdomsLang.COMMAND_TPA_DISABLED_WORLD_TELEPORTER, new Object[0]);
            return;
        }
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)target)) {
            context.sendError(KingdomsLang.COMMAND_TPA_DISABLED_WORLD_TARGET, new Object[0]);
            return;
        }
        KingdomPlayer kp = context.getKingdomPlayer();
        if (kp.hasPermission(StandardKingdomPermission.INSTANT_TELEPORT) && kingdom.getId().equals(targetKingdom.getId())) {
            teleporter.teleport((Entity)target);
            context.sendMessage(KingdomsLang.COMMAND_TPA_INSTANT_TELEPORTER, new Object[0]);
            context.sendMessage((CommandSender)target, KingdomsLang.COMMAND_TPA_TARGET_NOTIFICATION, new Object[0]);
        } else {
            CommandTpa.sendRequest(context, teleporter, target, TimeUtils.millisToTicks(KingdomsConfig.TPA_DEFAULT_TIMER.getManager().getTimeMillis()));
            context.sendMessage(KingdomsLang.COMMAND_TPA_REQUESTED_TELEPORTER, new Object[0]);
            context.sendMessage((CommandSender)target, KingdomsLang.COMMAND_TPA_REQUESTED_TARGET, new Object[0]);
        }
    }

    protected static boolean canRequest(Kingdom kingdom, Kingdom targetKingdom) {
        if (KingdomsConfig.TPA_ALLOW_FROM_OTHER_KINGDOMS.getManager().getBoolean()) {
            return kingdom.hasAttribute(targetKingdom, (RelationAttribute)StandardRelationAttribute.CEASEFIRE) && kingdom.hasAttribute(targetKingdom, (RelationAttribute)StandardRelationAttribute.TURRET_CEASEFIRE);
        }
        return kingdom.getId().equals(targetKingdom.getId());
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isPlayer() && context.isAtArg(0)) {
            Player teleporter = context.senderAsPlayer();
            return context.getPlayers(0, player -> {
                if (teleporter.getUniqueId().equals(player.getUniqueId())) {
                    return false;
                }
                KingdomPlayer targetKp = KingdomPlayer.getKingdomPlayer(player);
                Kingdom targetKingdom = targetKp.getKingdom();
                if (targetKingdom == null) {
                    return false;
                }
                Kingdom kingdom = context.getKingdom();
                return CommandTpa.canRequest(kingdom, targetKingdom);
            });
        }
        return CommandTpa.emptyTab();
    }
}

