/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.visualizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.PluginManager;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.land.indicator.LandVisualizer;

public class CommandVisualizeMarkers
extends KingdomsCommand {
    public CommandVisualizeMarkers(KingdomsParentCommand parent) {
        super("markers", parent);
        CommandVisualizeMarkers.registerMarkerPermissions();
    }

    private static Map<String, String> getTypes() {
        HashMap<String, String> types = new HashMap<String, String>();
        types.put(KingdomsConfig.Claims.INDICATOR_DEFAULT_NAME.getManager().getString(), "");
        types.put(KingdomsConfig.Claims.INDICATOR_VISUALIZER_NAME.getManager().getString(), "BLOCKS");
        YamlConfigAccessor section = KingdomsConfig.Claims.INDICATOR_PARTICLES.getManager().getSection();
        if (section != null) {
            for (String key : section.getKeys()) {
                String name = section.getString(key, "name");
                if (name == null) continue;
                types.put(name, key);
            }
        }
        return types;
    }

    private static void registerMarkerPermissions() {
        for (String type : CommandVisualizeMarkers.getTypes().values()) {
            String perm = type.toLowerCase(Locale.ENGLISH);
            if (perm.isEmpty()) {
                perm = "default";
            }
            String name = "kingdoms.markers." + perm;
            PluginManager manager = Bukkit.getPluginManager();
            if (manager.getPermission(name) != null) continue;
            Permission permission = new Permission(name, "Kingdoms land visualizer marker type.", PermissionDefault.TRUE);
            manager.addPermission(permission);
        }
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(1)) {
            return;
        }
        Player player = context.senderAsPlayer();
        String type = context.arg(0);
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        String defaultMethod = KingdomsConfig.Claims.INDICATOR_DEFAULT_NAME.getManager().getString();
        Map<String, String> types = CommandVisualizeMarkers.getTypes();
        String markers = kp.getMarkersType() == null ? defaultMethod : kp.getMarkersType();
        String realType = null;
        for (Map.Entry<String, String> tp : types.entrySet()) {
            if (!tp.getKey().equalsIgnoreCase(type)) continue;
            realType = tp.getValue();
            break;
        }
        if (realType == null) {
            KingdomsLang.COMMAND_VISUALIZE_MARKERS_INVALID.sendError((CommandSender)player, "markers", type);
            return;
        }
        if (markers.equalsIgnoreCase(realType)) {
            KingdomsLang.COMMAND_VISUALIZE_MARKERS_ALREADY_USING.sendError((CommandSender)player, "markers", markers);
            return;
        }
        if (realType.isEmpty()) {
            kp.setMarkersType(null);
        } else {
            kp.setMarkersType(realType);
        }
        KingdomsLang.COMMAND_VISUALIZE_MARKERS_CHANGED.sendMessage((CommandSender)player, "markers", type);
        SimpleChunkLocation chunk = SimpleChunkLocation.of(player.getLocation());
        Land land = chunk.getLand();
        new LandVisualizer().forPlayer(player, kp).forLand(land, chunk.toChunk()).display(true);
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (args.length == 1) {
            return new ArrayList<String>(CommandVisualizeMarkers.getTypes().keySet());
        }
        return new ArrayList<String>();
    }
}

