/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation;

import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.general.GroupDisband;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.utils.cooldown.Cooldown;

public class CommandNationDisband
extends KingdomsCommand {
    private static final Cooldown<Integer> COOLDOWN = new Cooldown();

    public CommandNationDisband(KingdomsParentCommand parent) {
        super("disband", parent);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        if (context.assertHasKingdom()) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        Nation nation = kingdom.getNation();
        if (nation == null) {
            KingdomsLang.NO_NATION.sendError((CommandSender)player, new Object[0]);
            return;
        }
        if (!kingdom.getId().equals(nation.getCapitalId()) || !kp.getId().equals(kingdom.getKingId())) {
            KingdomsLang.COMMAND_NATION_DISBAND_KING_ONLY.sendError((CommandSender)player, new Object[0]);
            return;
        }
        if (KingdomsConfig.DISBAND_CONFIRM.getBoolean()) {
            if (KingdomsConfig.DISBAND_USE_GUI.getBoolean()) {
                InteractiveGUI gui = GUIAccessor.prepare(player, "confirm/disband");
                if (gui == null) {
                    return;
                }
                gui.push("confirm", () -> {
                    if (!nation.triggerDisbandEvent(GroupDisband.Reason.SELF).isCancelled()) {
                        KingdomsLang.COMMAND_NATION_DISBAND_SUCCESS.sendMessage((CommandSender)player);
                        if (KingdomsConfig.DISBAND_ANNOUNCE.getBoolean()) {
                            for (Player players : Bukkit.getOnlinePlayers()) {
                                KingdomsLang.COMMAND_NATION_DISBAND_ANNOUNCE.sendMessage((CommandSender)players, (OfflinePlayer)player, new Object[0]);
                            }
                        }
                        nation.disband(null);
                    }
                    player.closeInventory();
                }, new Object[0]).push("cancel", () -> ((Player)player).closeInventory(), new Object[0]);
                gui.open();
                return;
            }
            if (!COOLDOWN.add(player.getEntityId(), KingdomsConfig.DISBAND_CONFIRMATION_EXPIRATION.getInt(), TimeUnit.SECONDS)) {
                KingdomsLang.COMMAND_NATION_DISBAND_CONFIRMATION.sendMessage((CommandSender)player);
                return;
            }
        }
        if (nation.triggerDisbandEvent(GroupDisband.Reason.SELF).isCancelled()) {
            return;
        }
        KingdomsLang.COMMAND_NATION_DISBAND_SUCCESS.sendMessage((CommandSender)player);
        if (KingdomsConfig.DISBAND_ANNOUNCE.getBoolean()) {
            for (Player players : Bukkit.getOnlinePlayers()) {
                KingdomsLang.COMMAND_NATION_DISBAND_ANNOUNCE.sendMessage((CommandSender)players, (OfflinePlayer)player, new Object[0]);
            }
        }
        COOLDOWN.stop(player.getEntityId());
        nation.disband(null);
    }
}

