/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.members.LeaveReason;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandNationKick
extends KingdomsCommand {
    public CommandNationKick(KingdomsParentCommand parent) {
        super("kick", parent);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(1)) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendError((CommandSender)player, new Object[0]);
            return;
        }
        if (!kingdom.hasNation()) {
            KingdomsLang.NO_NATION.sendError((CommandSender)player, new Object[0]);
            return;
        }
        if (!kp.hasNationPermission(StandardKingdomPermission.KICK)) {
            StandardKingdomPermission.KICK.sendDeniedMessage(player);
            return;
        }
        Kingdom kick = context.getKingdom(0);
        if (kick.getId().equals(kingdom.getId())) {
            KingdomsLang.COMMAND_NATION_KICK_SELF.sendError((CommandSender)player, new Object[0]);
            return;
        }
        Nation nation = kick.getNation();
        if (nation == null || !kingdom.isInSameNationAs(kick)) {
            KingdomsLang.COMMAND_NATION_KICK_NOT_IN_KINGDOM.sendError((CommandSender)player, "kingdom", kick.getName());
            return;
        }
        Object[] edits = new Object[]{"nation", nation.getName(), "kingdom", kingdom.getName(), "kicker", player.getName()};
        for (Player member : kick.getOnlineMembers()) {
            KingdomsLang.COMMAND_NATION_KICK_PERSON.sendMessage((CommandSender)member, edits);
        }
        edits = new Object[]{"kicker", player.getName(), "kingdom", kick.getName()};
        kick.leaveNation(LeaveReason.KICKED);
        for (Player member : nation.getOnlineMembers()) {
            KingdomsLang.COMMAND_NATION_KICK_ANNOUNCE.sendMessage((CommandSender)member, edits);
        }
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (args.length == 1 && sender instanceof Player) {
            Player player = (Player)sender;
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            Kingdom kingdom = kp.getKingdom();
            if (kingdom == null) {
                return Collections.singletonList(KingdomsLang.NO_KINGDOM_DEFAULT.parse(player, new Object[0]));
            }
            Nation nation = kingdom.getNation();
            if (nation == null) {
                return Collections.singletonList(KingdomsLang.NO_NATION.parse(player, new Object[0]));
            }
            return TabCompleteManager.getKingdomMembers(nation, args[0], k -> !k.getName().equals(kingdom.getName()));
        }
        return new ArrayList<String>();
    }
}

