/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.text.CommandTag;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.string.StringUtils;

public class CommandNationTag
extends KingdomsCommand {
    public CommandNationTag(KingdomsParentCommand parent) {
        super("tag", parent);
    }

    @Override
    public CommandResult executeX(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = context.getKingdomPlayer();
        Nation nation = kp.getKingdom().getNation();
        if (nation == null) {
            context.sendError(KingdomsLang.NO_NATION, new Object[0]);
            return CommandResult.FAILED;
        }
        if (!kp.hasNationPermission(StandardKingdomPermission.LORE)) {
            StandardKingdomPermission.LORE.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        String name = StringUtils.buildArguments(context.args, KingdomsConfig.TAGS_ALLOW_SPACES.getBoolean() ? " " : "");
        if (!kp.isAdmin()) {
            if (!CommandTag.checkTag(name, player)) {
                return CommandResult.FAILED;
            }
            double cost = KingdomsConfig.ECONOMY_COSTS_TAG_KINGDOM.getDouble();
            if (!nation.hasMoney(cost)) {
                KingdomsLang.COMMAND_TAG_COST.sendMessage((CommandSender)player, "cost", cost);
                return CommandResult.FAILED;
            }
            nation.addBank(-cost);
        }
        String previousTag = nation.getTag();
        if (nation.renameTag(name, kp).isCancelled()) {
            return CommandResult.FAILED;
        }
        MessageBuilder settings = new MessageBuilder().parse("tag", previousTag == null ? KingdomsLang.NONE : previousTag).withContext(player);
        KingdomsLang msg = previousTag == null ? KingdomsLang.COMMAND_NATION_TAG_SET : KingdomsLang.COMMAND_NATION_TAG_CHANGED;
        for (Player member : nation.getOnlineMembers()) {
            msg.sendMessage((CommandSender)member, settings);
        }
        return CommandResult.SUCCESS;
    }
}

