/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation.nexus;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.nexus.CommandNexus;
import org.kingdoms.commands.nation.nexus.CommandNationNexusOpen;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.general.KingdomDisbandEvent;
import org.kingdoms.events.lands.LandChangeEvent;
import org.kingdoms.events.lands.NexusMoveEvent;
import org.kingdoms.events.members.KingdomLeaveEvent;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.XParticle;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.LocationUtils;

public class CommandNationNexus
extends KingdomsParentCommand
implements Listener {
    private static final Set<UUID> SESSIONS = new HashSet<UUID>();

    public CommandNationNexus(KingdomsParentCommand parent) {
        super("nexus", parent);
        new CommandNationNexusOpen(this);
    }

    public static boolean isSettingNexus(Player player) {
        return SESSIONS.contains(player.getUniqueId());
    }

    private static void actionBar(final Player player) {
        if (!KingdomsConfig.NEXUS_ACTIONBAR_ENABLED.getBoolean()) {
            return;
        }
        if (KingdomsConfig.NEXUS_ACTIONBAR_KEEP.getBoolean()) {
            new BukkitRunnable(){

                public void run() {
                    if (!SESSIONS.contains(player.getUniqueId())) {
                        this.cancel();
                        return;
                    }
                    KingdomsLang.COMMAND_NATION_NEXUS_ACTIVATED.sendMessage((CommandSender)player);
                }
            }.runTaskTimer((Plugin)plugin, 0L, 40L);
        } else {
            KingdomsLang.COMMAND_NATION_NEXUS_ACTIVATED.sendMessage((CommandSender)player);
        }
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        Player player = context.senderAsPlayer();
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)player, KingdomsLang.DISABLED_WORLD)) {
            return;
        }
        if (CommandNexus.isSettingNexus(player)) {
            KingdomsLang.COMMAND_NATION_NEXUS_SETTING_KINGDOM.sendMessage((CommandSender)player);
            return;
        }
        if (SESSIONS.remove(player.getUniqueId())) {
            KingdomsLang.COMMAND_NATION_NEXUS_DISABLED.sendMessage((CommandSender)player);
            if (KingdomsConfig.NEXUS_ACTIONBAR_ENABLED.getBoolean()) {
                KingdomsLang.COMMAND_NATION_NEXUS_DEACTIVATED.sendMessage((CommandSender)player);
            }
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasKingdom()) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendMessage((CommandSender)player);
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (!kingdom.hasNation()) {
            KingdomsLang.NO_NATION.sendMessage((CommandSender)player);
            return;
        }
        if (KingdomsConfig.NEXUS_DISABLE_PLACE_MODE_OUT_OF_LAND.getBoolean() && !kp.getKingdom().isClaimed(SimpleChunkLocation.of(player.getLocation()))) {
            KingdomsLang.COMMAND_NATION_NEXUS_OUTSIDE_OF_LAND.sendMessage((CommandSender)player);
            return;
        }
        if (!kp.hasNationPermission(StandardKingdomPermission.STRUCTURES)) {
            StandardKingdomPermission.STRUCTURES.sendDeniedMessage(player);
            return;
        }
        SESSIONS.add(kp.getId());
        CommandNationNexus.actionBar(player);
        CommandNexus.preview(player, kingdom, true, () -> SESSIONS.contains(player.getUniqueId()));
        KingdomsLang.COMMAND_NATION_NEXUS_HELP.sendMessage((CommandSender)player);
    }

    @EventHandler
    public void onNexusPlace(PlayerInteractEvent event) {
        Block target;
        boolean replacing;
        Block clicked = event.getClickedBlock();
        if (clicked == null) {
            return;
        }
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        Player player = event.getPlayer();
        if (!SESSIONS.contains(player.getUniqueId())) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(player.getUniqueId());
        Kingdom kingdom = kp.getKingdom();
        event.setCancelled(true);
        boolean rightClick = event.getAction() == Action.RIGHT_CLICK_BLOCK;
        boolean replaceLeft = KingdomsConfig.NEXUS_REPLACE_LEFT_CLICK.getBoolean();
        boolean replaceRight = KingdomsConfig.NEXUS_REPLACE_RIGHT_CLICK.getBoolean();
        boolean bl = replacing = rightClick ? replaceRight : replaceLeft;
        if (SimpleLocation.of(clicked).equals(kingdom.getNexus())) {
            KingdomsLang.COMMAND_NATION_NEXUS_ALREADY_THERE.sendError((CommandSender)player, new Object[0]);
            return;
        }
        if (LocationUtils.exceedsBuildLimit(event)) {
            KingdomsConfig.errorSound(player);
            return;
        }
        if (replacing) {
            XMaterial base = XMaterial.matchXMaterial(clicked.getType());
            if (base.isOneOf(KingdomsConfig.NEXUS_REPLACE_BLOCKS_LIST.getStringList())) {
                if (KingdomsConfig.NEXUS_REPLACE_BLOCKS_BLACKLIST.getBoolean()) {
                    KingdomsLang.COMMAND_NATION_NEXUS_CANNOT_REPLACE.sendError((CommandSender)player, new Object[0]);
                    return;
                }
            } else if (!KingdomsConfig.NEXUS_REPLACE_BLOCKS_BLACKLIST.getBoolean()) {
                KingdomsLang.COMMAND_NATION_NEXUS_CANNOT_REPLACE.sendMessage((CommandSender)player);
                return;
            }
        }
        if ((target = CommandNexus.predicateNexusBlock(player, clicked, event.getBlockFace(), replacing, true)) == null) {
            MessageHandler.sendPlayerMessage(player, "&4Failed to predicate nation nexus block direction with facing " + event.getBlockFace());
            return;
        }
        Location nexus = target.getLocation();
        if (!kingdom.isClaimed(SimpleChunkLocation.of(nexus))) {
            KingdomsLang.COMMAND_NATION_NEXUS_NOT_CLAIMED.sendMessage((CommandSender)player);
            return;
        }
        Land land = Land.getLand(nexus);
        if (land != null && land.getStructure(struct -> {
            StructureType type = (StructureType)((StructureStyle)struct.getStyle()).getType();
            return type.isNexus() && !type.isNationalNexus();
        }) != null) {
            KingdomsLang.COMMAND_NATION_NEXUS_ANOTHER_STRUCTURE.sendMessage((CommandSender)player);
            return;
        }
        Nation nation = kingdom.getNation();
        NexusMoveEvent nexusStructure = nation.placeOrMoveNexus(nexus, kp);
        if (nexusStructure.isCancelled()) {
            return;
        }
        KingdomsLang.COMMAND_NATION_NEXUS_SUCCESS.sendMessage((CommandSender)player, "x", nexus.getBlockX(), "y", nexus.getBlockY(), "z", nexus.getBlockZ());
        SESSIONS.remove(player.getUniqueId());
        XParticle.helix((Plugin)Kingdoms.get(), 5, 2.0, 0.1, 1.0, 5, 3, true, false, ParticleDisplay.simple(nexus, Particle.FLAME));
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        SESSIONS.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onDamage(EntityDamageByEntityEvent event) {
        if (event.getEntity() instanceof Player && KingdomsConfig.NEXUS_DISABLE_PLACE_MODE_ON_DAMAGE.getBoolean() && SESSIONS.remove(event.getEntity().getUniqueId())) {
            KingdomsLang.COMMAND_NATION_NEXUS_DISABLED_ON_DAMAGE.sendMessage((CommandSender)event.getEntity());
        }
    }

    @EventHandler
    public void onMemberLeave(KingdomLeaveEvent event) {
        SESSIONS.remove(event.getPlayer().getId());
    }

    @EventHandler(ignoreCancelled=true)
    public void onKingdomDisband(KingdomDisbandEvent event) {
        for (UUID members : event.getKingdom().getMembers()) {
            SESSIONS.remove(members);
        }
    }

    @EventHandler
    public void onChunkChange(LandChangeEvent event) {
        if (!KingdomsConfig.NEXUS_DISABLE_PLACE_MODE_OUT_OF_LAND.getBoolean()) {
            return;
        }
        Player player = event.getPlayer();
        KingdomPlayer kp = event.getKingdomPlayer();
        if (!kp.hasKingdom()) {
            return;
        }
        if (!kp.getKingdom().isClaimed(event.getToChunk()) && SESSIONS.remove(player.getUniqueId())) {
            KingdomsLang.COMMAND_NATION_NEXUS_DISABLED_ON_LAND_CHANGE.sendMessage((CommandSender)player);
            if (KingdomsConfig.NEXUS_ACTIONBAR_ENABLED.getBoolean()) {
                KingdomsLang.COMMAND_NATION_NEXUS_DEACTIVATED.sendMessage((CommandSender)player);
            }
        }
    }
}

