/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.config;

import com.google.common.base.Enums;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Entity;
import org.kingdoms.config.ConfigAccessor;
import org.kingdoms.config.implementation.KeyedYamlConfigAccessor;
import org.kingdoms.libs.snakeyaml.nodes.Node;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextProvider;
import org.kingdoms.utils.compilers.MathCompiler;
import org.kingdoms.utils.config.NodeInterpreter;
import org.kingdoms.utils.time.TimeUtils;

public interface KeyedConfigAccessor {
    public KeyedConfigAccessor withProperty(String var1);

    public KeyedConfigAccessor applyProperties();

    public KeyedYamlConfigAccessor withOption(String var1, String var2);

    default public KeyedConfigAccessor forWorld(String world) {
        return this.withProperty(world).isSet() ? this : this.clearExtras().withProperty("default");
    }

    public KeyedYamlConfigAccessor clearExtras();

    default public KeyedConfigAccessor forWorld(Entity entity) {
        return this.forWorld(entity.getWorld().getName());
    }

    public String getDynamicOption();

    public boolean isSet();

    public String getString();

    public Node getNode();

    public MathCompiler.Expression getMathExpression();

    public <T> T get(NodeInterpreter<T> var1);

    public List<String> getStringList();

    public Set<String> getSectionKeys();

    public ConfigAccessor getSection();

    public boolean getBoolean();

    public List<Integer> getIntegerList();

    public int getInt();

    public double getDouble();

    public long getLong();

    default public Long getTimeMillis() {
        return this.getTime(PlaceholderContextProvider.EMPTY);
    }

    default public Long getTime(PlaceholderContextProvider ctx) {
        return NodeInterpreter.getTime(this.getNode(), ctx);
    }

    @Deprecated
    default public Long getTimeMillis(TimeUnit timeUnit) {
        String time = this.getString();
        return time == null ? null : TimeUtils.parseTime(time, timeUnit);
    }

    default public <T extends Enum<T>> T getEnum(Class<T> enumClazz) {
        return (T)((Enum)Enums.getIfPresent(enumClazz, (String)this.getString()).orNull());
    }
}

