/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.config.migration;

import org.kingdoms.config.migration.ConfigMigration;
import org.kingdoms.config.migration.ConfigMigrationSession;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.snakeyaml.nodes.Node;
import org.kingdoms.utils.config.adapters.YamlWithDefaults;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/kingdoms/config/migration/DefaultValue;", "Lorg/kingdoms/config/migration/ConfigMigration;", "config", "Lorg/kingdoms/utils/config/adapters/YamlWithDefaults;", "entries", "", "", "(Lorg/kingdoms/utils/config/adapters/YamlWithDefaults;[[Ljava/lang/String;)V", "[[Ljava/lang/String;", "priority", "", "getPriority", "()I", "apply", "", "session", "Lorg/kingdoms/config/migration/ConfigMigrationSession;", "core"})
public final class DefaultValue
extends ConfigMigration {
    @NotNull
    private final YamlWithDefaults config;
    @NotNull
    private final String[][] entries;
    private final int priority;

    public DefaultValue(@NotNull YamlWithDefaults config, @NotNull String[][] entries) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)entries, (String)"entries");
        this.config = config;
        this.entries = entries;
        this.priority = 2;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void apply(@NotNull ConfigMigrationSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (session.getDeletedConfigs().contains(this.config)) {
            return;
        }
        String[][] stringArray = this.entries;
        int n = ((Object[])stringArray).length;
        for (int i = 0; i < n; ++i) {
            String[] entry = stringArray[i];
            Node newValue = this.config.getDefaults().findNode(entry);
            this.config.getConfig().set(entry, (Object)newValue);
        }
        session.getConfigsNeedingReload().add(this.config);
    }
}

