/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.kingdoms.abstraction.ImmutableLocation;
import org.kingdoms.abstraction.NationOperator;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.BookChapter;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.KingdomRelationshipRequest;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.RankMap;
import org.kingdoms.data.KingdomsDataCenter;
import org.kingdoms.data.Pair;
import org.kingdoms.data.managers.NationManager;
import org.kingdoms.events.general.GroupDisband;
import org.kingdoms.events.general.GroupRenameEvent;
import org.kingdoms.events.general.nation.NationCreateEvent;
import org.kingdoms.events.general.nation.NationDisbandEvent;
import org.kingdoms.events.general.nation.NationSetSpawnEvent;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.events.lands.NexusMoveEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.Validate;

public class Nation
extends Group
implements NationOperator {
    public Nation(@NonNull Kingdom capital, @NonNull String name) {
        super(capital.id, name);
        capital.setNation(this.id);
        capital.getKing().setNationalRankInternal(this.getRanks().getHighestRank().getNode());
        this.members.add(capital.id);
        NationCreateEvent event = new NationCreateEvent(this);
        Bukkit.getPluginManager().callEvent((Event)event);
        KingdomsDataCenter.get().getNationManager().load(this);
    }

    public Nation(UUID id, Map<UUID, KingdomRelationshipRequest> relationshipRequests, RankMap ranks, Map<UUID, KingdomRelation> relations, Set<UUID> kingdoms, UUID capital, String name, String tax, SimpleLocation nexus, Location home, String flag, Color color, long resourcePoints, double bank, long since, boolean permanent, boolean requiresInvite, long shieldTime, long shieldSince, @NonNull Map<KingdomRelation, Set<RelationAttribute>> attributes) {
        super(id, capital, name, null, tax, ranks, resourcePoints, since, bank, false, permanent, requiresInvite, shieldSince, shieldTime, nexus, home, flag, color, kingdoms, new HashMap<String, BookChapter>(), relations, relationshipRequests, attributes, new HashSet<UUID>(), new LinkedList<AuditLog>());
    }

    public static @Nullable Nation getNation(@NonNull String name) {
        Validate.notEmpty(name, "Nation name cannot be null or empty");
        return KingdomsDataCenter.get().getNationManager().getData(name);
    }

    public static @Nullable Nation getNation(@NonNull UUID id) {
        Objects.requireNonNull(id, "Nation ID cannot be null or empty");
        return (Nation)KingdomsDataCenter.get().getNationManager().getData(id);
    }

    private static <T> List<T> groupPlayers(Collection<Kingdom> kingdoms, Function<Kingdom, List<T>> function) {
        int size = 0;
        int i = 0;
        List[] elements = new List[kingdoms.size()];
        for (Kingdom kingdom : kingdoms) {
            List<T> result = function.apply(kingdom);
            size += result.size();
            elements[i++] = result;
        }
        ArrayList players = new ArrayList(size);
        for (List playerGroup : elements) {
            players.addAll(playerGroup);
        }
        return players;
    }

    @Override
    public NationDisbandEvent triggerDisbandEvent(GroupDisband.Reason reason) {
        NationDisbandEvent event = new NationDisbandEvent(this, reason);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event;
    }

    public Map<String, Set<SimpleChunkLocation>> getLands(boolean includeNationZones) {
        List<Kingdom> kingdoms = this.getKingdoms();
        int radius = includeNationZones ? KingdomsConfig.Invasions.NATIONS_NATION_ZONE_RADIUS.getManager().getInt() : 0;
        HashMap<String, Set<SimpleChunkLocation>> worldChunks = new HashMap<String, Set<SimpleChunkLocation>>(3);
        for (Kingdom kingdom : kingdoms) {
            Set<SimpleChunkLocation> chunks = kingdom.getLandLocations();
            for (SimpleChunkLocation chunk : chunks) {
                HashSet<SimpleChunkLocation> container = (HashSet<SimpleChunkLocation>)worldChunks.get(chunk.getWorld());
                if (container == null) {
                    container = new HashSet<SimpleChunkLocation>(chunks.size() * kingdoms.size());
                    worldChunks.put(chunk.getWorld(), container);
                }
                if (includeNationZones) {
                    container.addAll(Arrays.asList(chunk.getChunksAround(radius, true)));
                    continue;
                }
                container.add(chunk);
            }
        }
        return worldChunks;
    }

    public @NonNull Kingdom getCapital() {
        return Kingdom.getKingdom(this.owner);
    }

    public void setCapital(@NonNull Kingdom capital) {
        Kingdom previous = Kingdom.getKingdom(this.owner);
        if (previous != null) {
            previous.getKing().setNationalRankInternal(null);
        }
        this.owner = Objects.requireNonNull(capital, (String)"Nation capital cannot be null").id;
        capital.getKing().setNationalRankInternal(this.getRanks().getHighestRank().getNode());
    }

    public @NonNull UUID getCapitalId() {
        return this.owner;
    }

    public @NonNull List<Kingdom> getKingdoms() {
        ArrayList<Kingdom> kingdoms = new ArrayList<Kingdom>(this.members.size());
        ArrayList<UUID> remove = new ArrayList<UUID>();
        for (UUID id : this.members) {
            Kingdom kingdom = Kingdom.getKingdom(id);
            if (kingdom == null) {
                MessageHandler.sendConsolePluginMessage("&4Detected unknown kingdom with UUID &e" + this.id + " &4in nation &e" + this.name + " &8(&e" + this.id + "&8) &4Removing the data...");
                remove.add(id);
                continue;
            }
            kingdoms.add(kingdom);
        }
        if (!remove.isEmpty()) {
            this.members.removeAll(remove);
        }
        return kingdoms;
    }

    public boolean setHome(KingdomPlayer kp, Location spawn) {
        NationSetSpawnEvent event = new NationSetSpawnEvent(this, kp, spawn);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        this.home = ImmutableLocation.of(event.getNewHome());
        return true;
    }

    @Override
    public double calculateTax() {
        return MathUtils.eval(KingdomsConfig.TAX_NATIONS_SCALING.getString(), this, new Object[0]);
    }

    @Override
    public int getMaxMembers() {
        return (int)MathUtils.eval(KingdomsConfig.MAX_MEMBERS_NATIONS.getString(), this, new Object[0]);
    }

    @Override
    public @NonNull GroupRenameEvent rename(@NonNull String name, @Nullable KingdomPlayer renamer) {
        Validate.notEmpty(name, "Cannot rename kingdom to null or empty name");
        KingdomsDataCenter.get().getNationManager().rename(this, name);
        GroupRenameEvent event = new GroupRenameEvent(this, name, renamer);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        this.setName(name);
        return event;
    }

    @Override
    public @NonNull List<Player> getOnlineMembers() {
        return Nation.groupPlayers(this.getKingdoms(), Kingdom::getOnlineMembers);
    }

    @Override
    public @NonNull List<OfflinePlayer> getPlayerMembers() {
        return Nation.groupPlayers(this.getKingdoms(), Kingdom::getPlayerMembers);
    }

    @Override
    public @NonNull List<KingdomPlayer> getKingdomPlayers() {
        return Nation.groupPlayers(this.getKingdoms(), Kingdom::getKingdomPlayers);
    }

    @Override
    public @NonNull NationDisbandEvent disband(GroupDisband.Reason reason) {
        NationDisbandEvent event = null;
        if (reason != null && (event = this.triggerDisbandEvent(reason)).isCancelled()) {
            return event;
        }
        for (Kingdom kingdom : this.getKingdoms()) {
            kingdom.setNation(null);
        }
        if (this.nexus != null) {
            Land land = Land.getLand(this.nexus);
            if (land != null) {
                Structure structure = land.getStructure(struct -> ((StructureType)((StructureStyle)struct.getStyle()).getType()).isNationalNexus());
                if (structure != null && ((StructureType)((StructureStyle)structure.getStyle()).getType()).isNationalNexus()) {
                    structure.remove(KingdomItemRemoveContext.DEFAULT);
                }
            } else {
                MessageHandler.sendConsolePluginMessage("&4Unknown land data for nation nexus &e" + this.nexus + " &4in nation &e" + this.name + " (" + this.id + ") skipping...");
            }
        }
        for (Map.Entry entry : this.relations.entrySet()) {
            Nation rel = Nation.getNation((UUID)entry.getKey());
            if (rel == null) continue;
            rel.revokeRelationsWith(this);
        }
        NationManager manager = KingdomsDataCenter.get().getNationManager();
        manager.remove(this);
        manager.delete(this.id);
        return event;
    }

    public boolean isMember(@NonNull Kingdom kingdom) {
        return this.isMember(kingdom.getId());
    }

    public boolean isMember(OfflinePlayer player) {
        for (Kingdom kingdom : this.getKingdoms()) {
            if (!kingdom.isMember(player)) continue;
            return true;
        }
        return false;
    }

    public boolean isMember(KingdomPlayer player) {
        for (Kingdom kingdom : this.getKingdoms()) {
            if (!kingdom.isMember(player)) continue;
            return true;
        }
        return false;
    }

    @Override
    public @NonNull String getTaxOrDefault() {
        return this.tax == null ? KingdomsConfig.TAX_NATIONS_MEMBERS_DEFAULT_EQUATION.getString() : this.tax;
    }

    public double getTax(Kingdom kingdom) {
        double amount;
        if (!ServiceHandler.bankServiceAvailable()) {
            return 0.0;
        }
        double money = kingdom.getBank();
        try {
            amount = MathUtils.eval(this.getTaxOrDefault(), kingdom, "money", money, "money", money);
        }
        catch (Exception ex) {
            this.tax = KingdomsConfig.TAX_NATIONS_MEMBERS_DEFAULT_EQUATION.getString();
            try {
                amount = MathUtils.eval(this.tax, kingdom, "money", money, "money", money);
            }
            catch (Exception exFatal) {
                MessageHandler.sendConsolePluginMessage("&cCould not use the default tax equation to pay for &e" + kingdom.getName() + " (" + kingdom.getId() + ")  &cin nation &e" + this.name + " (" + this.id + "):");
                ex.printStackTrace();
                exFatal.printStackTrace();
                return 0.0;
            }
        }
        return amount;
    }

    public @NonNull Pair<Boolean, Double> payTaxes(@NonNull Kingdom kingdom) {
        double limit;
        double money;
        double amount = this.getTax(kingdom);
        if (amount == 0.0) {
            return Pair.of(true, 0.0);
        }
        boolean useRpNationMember = KingdomsConfig.TAX_NATIONS_MEMBERS_USE_RESOURCE_POINTS.getBoolean();
        double d = money = useRpNationMember ? (double)kingdom.getResourcePoints() : kingdom.getBank();
        if (money - amount < 0.0) {
            if (useRpNationMember) {
                this.resourcePoints = (long)((double)this.resourcePoints + money);
            } else {
                this.bank += money;
            }
            if (useRpNationMember) {
                kingdom.addResourcePoints((long)(-money));
            } else {
                kingdom.addBank(-money);
            }
            return Pair.of(false, money);
        }
        double currentAmount = useRpNationMember ? (double)this.resourcePoints : this.bank;
        if (currentAmount + amount > (limit = KingdomsConfig.ECONOMY_BANK_LIMIT_NATIONS.getDouble())) {
            amount = limit - currentAmount;
        }
        if (useRpNationMember) {
            this.resourcePoints = (long)((double)this.resourcePoints + amount);
            kingdom.addResourcePoints((long)(-amount));
        } else {
            this.bank += amount;
            kingdom.addBank(-amount);
        }
        return Pair.of(true, amount);
    }

    public @NonNull KingdomRelation getRelationWith(@Nullable Nation nation) {
        if (nation == null) {
            return KingdomRelation.NEUTRAL;
        }
        if (this.id.equals(nation.id)) {
            return KingdomRelation.SELF;
        }
        KingdomRelation relation = (KingdomRelation)((Object)this.relations.get(nation.id));
        return relation == null ? KingdomRelation.NEUTRAL : relation;
    }

    @Override
    public NexusMoveEvent placeOrMoveNexus(@NonNull Location toLocation, @Nullable KingdomPlayer kp) {
        return this.abstractPlaceOrMoveNexus("national-nexus", toLocation, kp);
    }

    @Override
    public double getMight() {
        return MathUtils.eval(KingdomsConfig.TOP_NATIONS_MIGHT.getString(), this, new Object[0]);
    }

    public boolean hasAttribute(@Nullable Nation nation, StandardRelationAttribute attribute) {
        Objects.requireNonNull(nation, "Cannot check attributes of a null nation");
        KingdomRelation relation = this.getRelationWith(nation);
        Validate.isTrue(relation != KingdomRelation.NATION, "Relation between two nations cannot be: NATION");
        return ((Set)nation.attributes.get((Object)relation)).contains(attribute);
    }

    public KingdomRelationshipRequest acceptRelationshipRequest(Nation nation) {
        Objects.requireNonNull(nation, "Cannot accept relationship request from null nation");
        KingdomRelationshipRequest request = (KingdomRelationshipRequest)this.relationshipRequests.remove(nation.id);
        if (request == null) {
            return null;
        }
        KingdomRelation relation = request.getRelation();
        this.relations.put(nation.id, relation);
        nation.relations.put(this.id, relation);
        return request;
    }

    public KingdomRelationshipRequest sendRelationshipRequest(@Nullable KingdomPlayer sender, @NonNull Nation nation, @NonNull KingdomRelation relation, long acceptTime) {
        Objects.requireNonNull(nation, "Cannot send relationship request to null nation");
        Objects.requireNonNull(relation, "Cannot have null relations");
        if (this.getRelationWith(nation) == relation) {
            return null;
        }
        if (relation == KingdomRelation.NEUTRAL) {
            this.relations.remove(nation.id);
            if (this.hasAttribute(nation, StandardRelationAttribute.AUTO_REVOKE)) {
                nation.relations.remove(this.id);
            }
        } else {
            KingdomRelationshipRequest request = new KingdomRelationshipRequest(relation, sender == null ? null : sender.getId(), acceptTime);
            nation.relationshipRequests.put(this.id, request);
            return request;
        }
        return null;
    }

    public KingdomRelationshipRequest sendRelationshipRequest(@Nullable KingdomPlayer sender, @NonNull Nation nation, @NonNull KingdomRelation relation) {
        return this.sendRelationshipRequest(sender, nation, relation, KingdomsConfig.Relations.REQUEST_EXPIRATION.getManager().getTimeMillis());
    }

    @Override
    public void updateRankNode(@NonNull String node, @NonNull String newNode) {
        this.ranks.updateNode(node, newNode);
        for (KingdomPlayer kp : this.getKingdomPlayers()) {
            if (!node.equals(kp.getNationRankNode())) continue;
            kp.setNationalRankInternal(newNode);
        }
    }

    public KingdomRelation revokeRelationsWith(@NonNull Nation nation) {
        Objects.requireNonNull(nation, "Cannot revoke relations with a null nation");
        nation.relations.remove(this.id);
        return (KingdomRelation)((Object)this.relations.remove(nation.id));
    }

    @Override
    public Nation getNation() {
        return this;
    }
}

