/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model;

import java.util.UUID;
import org.kingdoms.constants.player.KingdomPlayer;

public abstract class KingdomRequest {
    private final UUID sender;
    private final long acceptTime;
    private final long timestamp;

    public KingdomRequest(UUID sender, long acceptTime, long timestamp) {
        this.sender = sender;
        this.acceptTime = acceptTime;
        this.timestamp = timestamp;
    }

    public KingdomRequest(UUID sender, long acceptTime) {
        this(sender, acceptTime, System.currentTimeMillis());
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getAcceptTime() {
        return this.acceptTime;
    }

    public long getTimeLeftToAccept() {
        long passed = System.currentTimeMillis() - this.timestamp;
        return Math.max(0L, this.acceptTime - passed);
    }

    public boolean canAccept() {
        return this.acceptTime > 0L;
    }

    public UUID getSender() {
        return this.sender;
    }

    public KingdomPlayer getKingdomPlayer() {
        return KingdomPlayer.getKingdomPlayer(this.sender);
    }

    public int hashCode() {
        int prime = 31;
        int result = 14;
        result = prime * result + this.sender.hashCode();
        result = prime * result + Long.hashCode(this.acceptTime);
        result = prime * result + Long.hashCode(this.timestamp);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KingdomRequest)) {
            return false;
        }
        KingdomRequest request = (KingdomRequest)obj;
        return this.acceptTime == request.acceptTime && this.timestamp == request.timestamp && this.sender.equals(request.sender);
    }
}

