/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.lands;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.data.database.dataprovider.DataSetter;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.LocationUtils;

public abstract class LogKingdomLand
extends AuditLog {
    private UUID player;
    private Set<SimpleChunkLocation> lands;

    public LogKingdomLand() {
    }

    public LogKingdomLand(UUID player, Set<SimpleChunkLocation> lands) {
        this.player = player;
        this.lands = lands;
    }

    @Override
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        this.player = json.get("player").asUUID();
        this.lands = json.get("lands").asCollection(new HashSet(), (c, e) -> c.add(e.asSimpleChunkLocation()));
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.setUUID("player", this.player);
        json.get("lands").setCollection(this.lands, DataSetter::setSimpleChunkLocation);
    }

    @Override
    public void addEdits(MessageBuilder builder) {
        super.addEdits(builder);
        if (this.player != null) {
            builder.withContext(this.getPlayer());
        } else {
            builder.raw("player", KingdomsLang.UNKNOWN);
        }
        builder.parse("lands", "{$s}" + this.lands.stream().map(x -> KingdomsLang.LOCATIONS_CHUNK.parse(LocationUtils.getChunkEdits(x))).collect(Collectors.joining("\n{$s}")));
    }

    public OfflinePlayer getPlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.player);
    }
}

