/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.relationships;

import com.google.common.base.Enums;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.kingdoms.config.ConfigAccessor;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.compiler.builders.LanguageEntryWithContext;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.PvPManager;
import org.kingdoms.utils.compilers.MathCompiler;
import org.kingdoms.utils.internal.MapUtil;
import org.kingdoms.utils.internal.enumeration.OrderedSet;
import org.kingdoms.utils.internal.enumeration.QuickEnumMap;
import org.kingdoms.utils.string.StringUtils;

public enum KingdomRelation {
    SELF(null),
    NEUTRAL(null),
    TRUCE(StandardKingdomPermission.TRUCE),
    ENEMY(StandardKingdomPermission.ENEMY),
    NATION(StandardKingdomPermission.NATION),
    ALLY(StandardKingdomPermission.ALLIANCE);

    public static final KingdomRelation[] VALUES;
    private static final Map<KingdomRelation, Set<RelationAttribute>> DEFAULTS;
    private final StandardKingdomPermission permission;
    private boolean customizable = true;
    private PvPManager.PvPType pvpType;

    private KingdomRelation(StandardKingdomPermission permission) {
        this.permission = permission;
    }

    public static void init() {
        for (KingdomRelation relation : KingdomRelation.values()) {
            if (relation == SELF) continue;
            String relName = relation.name().toLowerCase(Locale.ENGLISH);
            ConfigAccessor section = KingdomsConfig.RELATIONS.accessor().gotoSection("relations", relName);
            Objects.requireNonNull(section, () -> "Section is null for relationship: " + relName);
            if (section.isSet("customizable") && !section.getBoolean("customizable")) {
                relation.customizable = false;
            }
            if (PvPManager.isPvPType(PvPManager.PvPType.RELATIONAL)) {
                String pvp = section.getString("pvp");
                if (pvp == null) {
                    pvp = "";
                }
                relation.pvpType = (PvPManager.PvPType)((Object)Enums.getIfPresent(PvPManager.PvPType.class, (String)pvp.toUpperCase(Locale.ENGLISH)).or((Object)PvPManager.PvPType.NORMAL));
            } else {
                relation.pvpType = PvPManager.getPvpType();
            }
            if (relation.pvpType == PvPManager.PvPType.RELATIONAL) {
                KLogger.error("PvP mode of individual relationships cannot be 'relational': " + relName);
            }
            OrderedSet<RelationAttribute> attributes = new OrderedSet<RelationAttribute>(5);
            for (RelationAttribute attribute : Kingdoms.get().getRelationAttributeRegistry().getRegistry().values()) {
                if (!section.getBoolean(attribute.getNamespace().getConfigOptionName())) continue;
                attributes.add(attribute);
            }
            DEFAULTS.put(relation, attributes);
        }
        KingdomRelation.SELF.customizable = false;
    }

    public boolean isCustomizable() {
        return this.customizable;
    }

    public PvPManager.PvPType getPvPType() {
        return this.pvpType;
    }

    public static Map<KingdomRelation, Set<RelationAttribute>> deserialize(String name, JsonObject json, JsonDeserializationContext context) {
        JsonElement element = json.get("attributes");
        if (element == null) {
            return KingdomRelation.copyDefaults();
        }
        json = element.getAsJsonObject();
        QuickEnumMap attributes = new QuickEnumMap((Enum[])VALUES);
        for (KingdomRelation rel : VALUES) {
            JsonElement data = json.get(rel.name());
            if (data == null || !rel.customizable) {
                Set<RelationAttribute> defaults = DEFAULTS.get((Object)rel);
                if (defaults == null) continue;
                attributes.put(rel, MapUtil.clone(defaults, new OrderedSet(defaults.size())));
                continue;
            }
            JsonArray array = data.getAsJsonArray();
            OrderedSet<RelationAttribute> attrs = new OrderedSet<RelationAttribute>(array.size());
            for (JsonElement attrElement : array) {
                @NonNull Namespace ns = Namespace.fromString(attrElement.getAsString());
                RelationAttribute attr = (RelationAttribute)Kingdoms.get().getRelationAttributeRegistry().getRegistered(ns);
                if (attr == null) {
                    KLogger.error("Unknown relationship attribute named '" + attrElement.getAsString() + "' (" + ns + ") for group '" + name + "' removing it.");
                }
                attrs.add(attr);
            }
            attributes.put(rel, attrs);
        }
        return attributes;
    }

    public static Map<KingdomRelation, Set<RelationAttribute>> copyDefaults() {
        EnumMap<KingdomRelation, Set<RelationAttribute>> relations = new EnumMap<KingdomRelation, Set<RelationAttribute>>(KingdomRelation.class);
        for (Map.Entry<KingdomRelation, Set<RelationAttribute>> relation : DEFAULTS.entrySet()) {
            if (relation.getKey() == SELF) continue;
            Set<RelationAttribute> defaults = relation.getValue();
            relations.put(relation.getKey(), MapUtil.clone(defaults, new OrderedSet(defaults.size())));
        }
        return relations;
    }

    public String getConfigName() {
        return StringUtils.configOption(this.name());
    }

    public String getColor() {
        return KingdomsConfig.Relations.COLOR.getManager().withOption("relation", this.getConfigName()).getString();
    }

    public MathCompiler.Expression getLimit() {
        return KingdomsConfig.Relations.LIMIT.getManager().withOption("relation", this.getConfigName()).getMathExpression();
    }

    public @Nullable StandardKingdomPermission getPermission() {
        return this.permission;
    }

    public MathCompiler.Expression getCost() {
        return KingdomsConfig.Relations.COST.getManager().withOption("relation", this.getConfigName()).getMathExpression();
    }

    public LanguageEntryWithContext getName() {
        return new LanguageEntryWithContext("relations", this.getConfigName(), "name");
    }

    static {
        VALUES = KingdomRelation.values();
        DEFAULTS = new EnumMap<KingdomRelation, Set<RelationAttribute>>(KingdomRelation.class);
    }
}

