/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.upgradable.champion;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.KeyedYamlConfigAccessor;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.upgradable.champion.ChampionUpgrade;
import org.kingdoms.constants.group.upgradable.champion.abilities.ChampionAbilityDamageCap;
import org.kingdoms.constants.group.upgradable.champion.abilities.ChampionAbilityDrag;
import org.kingdoms.constants.group.upgradable.champion.abilities.ChampionAbilityDuel;
import org.kingdoms.constants.group.upgradable.champion.abilities.ChampionAbilityFangs;
import org.kingdoms.constants.group.upgradable.champion.abilities.ChampionAbilityFocus;
import org.kingdoms.constants.group.upgradable.champion.abilities.ChampionAbilityPlow;
import org.kingdoms.constants.group.upgradable.champion.abilities.ChampionAbilityReinforcements;
import org.kingdoms.constants.group.upgradable.champion.abilities.ChampionAbilityResistance;
import org.kingdoms.constants.group.upgradable.champion.abilities.ChampionAbilityThor;
import org.kingdoms.constants.group.upgradable.champion.abilities.ChampionAbilityThrow;
import org.kingdoms.events.general.ChampionAbilityEvent;
import org.kingdoms.events.invasion.KingdomInvadeAttackEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextProvider;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.invasions.Invasion;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.compilers.MathCompiler;
import org.kingdoms.utils.cooldown.BiCooldown;
import org.kingdoms.utils.string.StringUtils;

public abstract class ChampionAbility {
    public static final String TELEPORT_META = "ALLOW_INVASION_TELEPORTATION";
    private static final Map<ChampionUpgrade, ChampionAbility> ABILITIES = new EnumMap<ChampionUpgrade, ChampionAbility>(ChampionUpgrade.class);
    private static final BiCooldown<UUID, ChampionUpgrade> ABILITY_COOLDOWN = new BiCooldown(() -> new EnumMap(ChampionUpgrade.class));
    private final boolean triggerInstantly;
    private final @NonNull ChampionUpgrade name;

    public ChampionAbility(@NonNull ChampionUpgrade name, boolean triggerInstantly) {
        this.name = Objects.requireNonNull(name);
        this.triggerInstantly = triggerInstantly;
        if (KingdomsConfig.ChampionUpgrades.ENABLED.getManager().withOption("upgrade", StringUtils.configOption(name)).getBoolean()) {
            if (this instanceof Listener) {
                Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)Kingdoms.get());
            }
            ABILITIES.put(name, this);
        }
    }

    public ChampionAbility(ChampionUpgrade name) {
        this(name, false);
    }

    public static void init() {
        ABILITIES.clear();
        new ChampionAbilityDrag();
        new ChampionAbilityDuel();
        new ChampionAbilityFocus();
        new ChampionAbilityDamageCap();
        new ChampionAbilityReinforcements();
        new ChampionAbilityPlow();
        new ChampionAbilityResistance();
        new ChampionAbilityThor();
        new ChampionAbilityThrow();
        new ChampionAbilityFangs();
    }

    public static Map<ChampionUpgrade, ChampionAbility> getAbilities() {
        return ABILITIES;
    }

    public static ChampionAbility getAbility(ChampionUpgrade name) {
        return ABILITIES.get(name);
    }

    public double getScaling(@NonNull String extra, MessageBuilder builder) {
        Objects.requireNonNull(extra, "Cannot get champion upgrade scaling from a null extra");
        Objects.requireNonNull(builder, "Cannot get champion upgrade scaling from a null kingdom");
        MathCompiler.Expression scaling = Objects.requireNonNull(this.name.getOption(extra).getMathExpression(), () -> "Cannot find scaling equation for " + this.name.name() + " champion upgrade (" + extra + ')');
        return MathUtils.eval(scaling, (PlaceholderContextProvider)builder);
    }

    public boolean canUse(@NonNull KingdomInvadeAttackEvent event) {
        return this.canUse(event.getInvasion().getDefender());
    }

    public boolean canUse(@NonNull Kingdom kingdom) {
        return kingdom.getUpgradeLevel(this.name) > 0;
    }

    public int getLevel(@NonNull Invasion invasion) {
        return invasion.getDefender().getUpgradeLevel(this.name);
    }

    public double getScaling(@NonNull Invasion invasion) {
        return this.getScaling("scaling", invasion);
    }

    public double getScaling(String extra, Invasion invasion) {
        return this.getScaling(extra, this.addEdits(invasion, invasion.getInvasionEdits()));
    }

    public boolean isInCooldown(@NonNull Invasion invasion) {
        return ABILITY_COOLDOWN.isInCooldown(invasion.getChampion().getUniqueId(), this.name);
    }

    public void cooldown(@NonNull Invasion invasion, long cd) {
        ABILITY_COOLDOWN.add(invasion.getChampion().getUniqueId(), this.name, cd, TimeUnit.MILLISECONDS);
    }

    public KeyedYamlConfigAccessor getOption(String name) {
        return this.name.getOption(name);
    }

    public boolean trigger(Invasion invasion) {
        throw new UnsupportedOperationException("Champion ability cannot be triggered instantly");
    }

    public @NonNull ChampionUpgrade getName() {
        return this.name;
    }

    public boolean callEvent(@NonNull Invasion invasion) {
        ChampionAbilityEvent event = new ChampionAbilityEvent(this, invasion);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event.isCancelled();
    }

    public boolean canTriggerInstantly() {
        return this.triggerInstantly;
    }

    public @NonNull Object[] getEdits(Kingdom kingdom) {
        return new Object[0];
    }

    public MessageBuilder addEdits(Invasion invasion, MessageBuilder builder) {
        return builder.raw("lvl", this.getLevel(invasion));
    }

    public MessageBuilder getEdits(Invasion invasion) {
        return this.addEdits(invasion, invasion.getInvasionEdits());
    }
}

