/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.upgradable.champion.abilities;

import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.EvokerFangs;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.group.upgradable.champion.ChampionAbility;
import org.kingdoms.constants.group.upgradable.champion.ChampionUpgrade;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.managers.invasions.Invasion;

public class ChampionAbilityFangs
extends ChampionAbility
implements Listener {
    public ChampionAbilityFangs() {
        super(ChampionUpgrade.FANGS, true);
    }

    @Override
    public boolean trigger(Invasion invasion) {
        if (this.callEvent(invasion)) {
            return false;
        }
        this.cooldown(invasion, this.getOption("cooldown").getTime(this.getEdits(invasion)));
        Creature champion = invasion.getChampion();
        ParticleDisplay display = ParticleDisplay.of(Particle.DRAGON_BREATH).withCount(20).offset(1.0);
        double radius = this.getScaling("radius", invasion);
        for (Entity entity : champion.getNearbyEntities(radius, radius, radius)) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            if (invasion.getDefender().hasAttribute(kp.getKingdom(), (RelationAttribute)StandardRelationAttribute.CEASEFIRE)) continue;
            Location loc = entity.getLocation();
            EvokerFangs fangs = (EvokerFangs)champion.getWorld().spawnEntity(loc, EntityType.EVOKER_FANGS);
            fangs.setOwner((LivingEntity)champion);
            display.spawn(loc);
        }
        return true;
    }

    @EventHandler(ignoreCancelled=true)
    public void onDamage(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof EvokerFangs)) {
            return;
        }
        EvokerFangs fangs = (EvokerFangs)event.getDamager();
        if (fangs.getOwner() == null) {
            return;
        }
        Invasion invasion = Invasion.getInvasion(fangs.getOwner());
        if (invasion == null) {
            return;
        }
        double damage = this.getScaling(invasion);
        event.setDamage(damage);
    }
}

