/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.abstraction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.kingdoms.abstraction.LandOperator;
import org.kingdoms.config.ConfigAccessor;
import org.kingdoms.config.KeyedConfigAccessor;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomItemStyle;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.metadata.KingdomMetadata;
import org.kingdoms.constants.metadata.KingdomMetadataHandler;
import org.kingdoms.constants.metadata.KingdomsObject;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.data.database.dataprovider.DataSetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.data.handlers.DataHandlerMetadata;
import org.kingdoms.events.items.KingdomItemBreakEvent;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.gui.objects.GUIOptionParser;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.checkerframework.common.value.qual.IntRange;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextBuilder;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextProvider;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.managers.land.KingdomItemGUIProtection;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.RomanNumber;
import org.kingdoms.utils.compilers.MathCompiler;
import org.kingdoms.utils.internal.nonnull.NonNullList;
import org.kingdoms.utils.internal.nonnull.NonNullMap;
import org.kingdoms.utils.nbt.ItemNBT;
import org.kingdoms.utils.nbt.NBTTagCompound;
import org.kingdoms.utils.nbt.NBTType;
import org.kingdoms.utils.nbt.NBTWrappers;
import org.kingdoms.utils.nms.EntityFactory;
import org.kingdoms.utils.nms.HologramFactory;
import org.kingdoms.utils.string.StringUtils;

public abstract class KingdomItem<T extends KingdomItemStyle<?, ?, ?>>
extends KingdomsObject<SimpleLocation>
implements LandOperator {
    protected final @NonNull T style;
    protected final transient @NonNull SimpleLocation location;
    private final transient @NonNull String meta;
    protected @IntRange(from=1L) int level = 1;
    @Deprecated
    private @Nullable Set<UUID> holograms = new HashSet<UUID>();
    private final List<ArmorStand> hologramsV2 = new NonNullList(new CopyOnWriteArrayList());

    public KingdomItem(@NonNull String meta, @NonNull T type, @NonNull SimpleLocation location) {
        super(new NonNullMap<KingdomMetadataHandler, KingdomMetadata>());
        this.meta = Objects.requireNonNull(meta, "Kingdom item meta type cannot be null");
        this.style = (KingdomItemStyle)Objects.requireNonNull(type, "Kingdom item type cannot be null");
        this.location = Objects.requireNonNull(location, "Kingdom item location cannot be null");
    }

    @Override
    public final @NonNull SimpleLocation getDataKey() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final @NonNull String getCompressedData() {
        return String.valueOf(this.hashCode());
    }

    protected String round(double num) {
        return StringUtils.toFancyNumber(num);
    }

    public int hashCode() {
        int prime = 31;
        int result = 15;
        result = prime * result + this.location.hashCode();
        result = prime * result + this.style.hashCode();
        result = prime * result + (this.holograms == null ? 0 : this.holograms.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KingdomItem)) {
            return false;
        }
        KingdomItem kingdomItem = (KingdomItem)obj;
        return this.location.equals(kingdomItem.location);
    }

    public @NonNull T getStyle() {
        return this.style;
    }

    public @NonNull Block getBlock() {
        return this.location.toBukkitLocation().getBlock();
    }

    public final KingdomItemBreakEvent<?> remove() {
        return this.remove(KingdomItemRemoveContext.DEFAULT);
    }

    public KingdomItemBreakEvent<?> remove(KingdomItemRemoveContext context) {
        KingdomItemBreakEvent<KingdomItem> event = new KingdomItemBreakEvent<KingdomItem>(context.getCause(), context.getPlayer(), this, context.getDropsItem());
        if (context.getModifier() != null) {
            context.getModifier().accept(event);
        }
        Bukkit.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            event.setCancelled(true);
            return event;
        }
        Location location = this.location.toBukkitLocation();
        Block block = location.getBlock();
        block.setType(Material.AIR);
        if (event.dropsItem()) {
            this.dropItem(location, this.getLand().getKingdom());
        }
        this.removeHolograms();
        this.removeData();
        this.playSound("break");
        this.displayParticle("break");
        List gui = KingdomItemGUIProtection.OPENED_GUI.remove(this.location);
        if (gui != null) {
            gui.forEach(HumanEntity::closeInventory);
        }
        return event;
    }

    public void dropItem(Location location, Kingdom kingdom) {
        if (!((KingdomItemStyle)this.style).hasItem()) {
            return;
        }
        ItemStack itemStack = this.getItem(kingdom);
        Item item = location.getWorld().dropItemNaturally(location, itemStack);
        ((KingdomItemStyle)this.style).droppedItemName(item);
    }

    protected abstract void removeData();

    public void serialize(SerializationContext<SectionableDataSetter> context) {
        SectionableDataSetter provider = context.getDataProvider();
        provider.setString("type", ((KingdomItemStyle)this.style).getName());
        provider.setInt("level", this.level);
        if (this.holograms != null && !this.holograms.isEmpty()) {
            provider.get("holograms").setCollection(this.holograms, DataSetter::setUUID);
        }
        DataHandlerMetadata.serializeMetadata(provider, this);
    }

    public void removeHolograms() {
        EntityFactory.removeEntity(this.location.getBukkitWorld().getPlayers(), this.hologramsV2.stream().map(Entity::getEntityId).collect(Collectors.toList()));
        this.hologramsV2.clear();
        this.removeOldHolograms();
    }

    void removeOldHolograms() {
        if (this.holograms == null || this.holograms.isEmpty()) {
            return;
        }
        Location location = this.location.toBukkitLocation();
        double range = ((KingdomItemStyle)this.style).getHologramHeight(Math.max(1, this.level - 1)) + 1.0;
        Kingdoms.taskScheduler().sync().execute(() -> {
            for (Entity entity : location.getWorld().getNearbyEntities(location, range, range, range)) {
                if (entity.getType() != EntityType.ARMOR_STAND || !this.holograms.contains(entity.getUniqueId())) continue;
                entity.remove();
            }
            this.holograms.clear();
        });
    }

    public void playSound(String sound) {
        this.playSound(this.location.toBukkitLocation(), sound);
    }

    public void playSound(Location location, String sound) {
        ConfigAccessor section = ((KingdomItemStyle)this.style).getOption("sounds").getSection();
        if (section == null) {
            return;
        }
        int entry = KingdomsConfig.getClosestLevelSection(section, this.level);
        ConfigAccessor sounds = section.gotoSection(String.valueOf(entry));
        if (sounds != null) {
            XSound.play(location, sounds.getString(sound));
        }
    }

    public void displayParticle(String particle) {
        this.displayParticle(this.location.toBukkitLocation(), particle);
    }

    public void displayParticle(Location location, String particle) {
        ConfigAccessor finalSection;
        Objects.requireNonNull(location, "Cannot display particle at null location");
        ConfigAccessor section = ((KingdomItemStyle)this.style).getOption("particles").getSection();
        if (section == null) {
            return;
        }
        int entry = KingdomsConfig.getClosestLevelSection(section, this.level);
        ConfigAccessor particles = section.gotoSection(String.valueOf(entry));
        if (particles != null && (finalSection = particles.gotoSection(particle)) != null) {
            ParticleDisplay.fromConfig(finalSection.toBukkitConfigurationSection()).spawn(location.add(0.5, 0.0, 0.5));
        }
    }

    public Pair<ItemStack, NBTTagCompound> getTags() {
        ConfigAccessor section = Objects.requireNonNull(((KingdomItemStyle)this.style).getOption("item").getSection(), "Calling getTags() before checking hasItem()");
        int entry = KingdomsConfig.getClosestLevelSection(section, this.level);
        ConfigAccessor itemSection = section.gotoSection(String.valueOf(entry)).noDefault();
        ItemStack item = XItemStack.deserialize(itemSection.toBukkitConfigurationSection(), Function.identity(), ex -> {
            XItemStack.UnAcceptableMaterialCondition cond;
            if (ex instanceof XItemStack.UnAcceptableMaterialCondition && (cond = (XItemStack.UnAcceptableMaterialCondition)ex).getReason() == XItemStack.UnAcceptableMaterialCondition.Reason.UNSUPPORTED) {
                cond.setSolution(GUIOptionParser.unsupportedMaterial(cond.getMaterial()));
            }
        });
        if (XItemStack.isDefaultItem(item)) {
            MessageHandler.sendConsolePluginMessage("&4Error while parsing kingdom item for: &e" + ((KingdomItemStyle)this.style).name + " &4with properties&8:");
            itemSection.toBukkitConfigurationSection().getValues(true).forEach((k, v) -> MessageHandler.sendConsolePluginMessage("&6" + k + "&8: &e" + (v instanceof ConfigurationSection ? "" : v)));
            return null;
        }
        NBTWrappers.NBTTagCompound tag = ItemNBT.getTag(item);
        NBTWrappers.NBTTagCompound kingdoms = new NBTWrappers.NBTTagCompound();
        kingdoms.setString(this.meta, ((KingdomItemStyle)this.style).getName());
        kingdoms.setInt("Level", this.level);
        tag.setCompound("Kingdoms", kingdoms);
        return Pair.of(item, tag);
    }

    public ItemStack getItem(@Nullable Kingdom kingdom) {
        Pair<ItemStack, NBTTagCompound> pair = this.getTags();
        if (pair == null) {
            return null;
        }
        ItemStack item = ItemNBT.setTag(pair.getKey(), (NBTWrappers.NBTTagCompound)pair.getValue());
        ItemMeta meta = Objects.requireNonNull(item.getItemMeta(), () -> "Item has no metadata: " + item);
        MessageBuilder translatorSettings = this.getEdits(kingdom).withContext(kingdom);
        if (meta.hasDisplayName()) {
            meta.setDisplayName(MessageCompiler.compile(meta.getDisplayName()).buildPlain(translatorSettings));
        }
        if (meta.hasLore()) {
            meta.setLore(MessageCompiler.link(meta.getLore(), translatorSettings));
        }
        item.setItemMeta(meta);
        return item;
    }

    public MessageBuilder getEdits(Kingdom kingdom) {
        int maxLvl = this.getMaxLevel(kingdom);
        return new MessageBuilder().raw("level", this.level).raw("max_level", maxLvl).raw("max-level-roman", maxLvl <= 0 ? Integer.valueOf(maxLvl) : RomanNumber.toRoman(maxLvl)).raw("upgrade_cost", this.getUpgradeCost(kingdom)).raw("level_roman", RomanNumber.toRoman(this.level)).raw("next_level", RomanNumber.toRoman(this.level + 1)).raw("next_level_roman", RomanNumber.toRoman(this.level + 1));
    }

    public final MessageBuilder getEdits() {
        return this.getEdits(this.getLand().getKingdom());
    }

    public void setDataFromNBT(NBTTagCompound tag) {
        this.level = Math.max(1, tag.get("Level", NBTType.INTEGER));
    }

    @Override
    public Land getLand() {
        return this.location.toSimpleChunkLocation().getLand();
    }

    public @NonNull SimpleLocation getLocation() {
        return this.location;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void upgrade(int newLevel) {
        this.level = newLevel;
        Block block = Objects.requireNonNull(this.getBlock(), () -> "Block of kingdom item '" + ((KingdomItemStyle)this.style).getName() + "' is null for level: " + this.level);
        Material mat = Objects.requireNonNull(((KingdomItemStyle)this.style).getBlockMaterial(this.level).parseMaterial(), () -> "Material of kingdom item '" + ((KingdomItemStyle)this.style).getName() + "' is null for level: " + this.level);
        if (block.getType() != mat && !block.getType().name().contains("SKULL") && !mat.name().contains("SKULL")) {
            block.setType(mat);
        }
        ((KingdomItemStyle)this.style).setSkin(block, this.level);
        Kingdoms.taskScheduler().async().execute(() -> {
            XSound.BLOCK_ANVIL_USE.play(block.getLocation());
            ParticleDisplay.simple(block.getLocation(), Particle.SPELL_WITCH).withCount(100).offset(0.5).spawn();
            this.updateHolograms(this.getLand().getKingdom());
        });
    }

    public int getMaxLevel(@Nullable Kingdom kingdom) {
        return ((KingdomItemStyle)this.style).getMaxLevel(this.getPlaceholderContext(kingdom, this.level));
    }

    PlaceholderContextProvider getPlaceholderContext(Kingdom kingdom, int lvl) {
        return new PlaceholderContextBuilder().withContext(kingdom).raw("lvl", lvl);
    }

    public int getUpgradeCost(@Nullable Kingdom kingdom) {
        return (int)((KingdomItemStyle)this.style).getUpgradeCost(this.getPlaceholderContext(kingdom, this.level));
    }

    public double eval(@NonNull String str, @Nullable Kingdom kingdom, int lvl) {
        return this.eval(((KingdomItemStyle)this.style).getOption(str), kingdom, lvl);
    }

    public double eval(@NonNull KeyedConfigAccessor option, @Nullable Kingdom kingdom, int lvl) {
        try {
            MathCompiler.Expression eqn = Objects.requireNonNull(option.getMathExpression());
            return MathUtils.eval(eqn, this.getPlaceholderContext(kingdom, lvl));
        }
        catch (Exception ex) {
            KLogger.error("Cannot evaluate '" + option.getDynamicOption() + "' option for kingdom item style '" + ((KingdomItemStyle)this.style).getName() + "' (" + this.getClass().getSimpleName() + "):");
            KLogger.error(option.getNode().getStartMark());
            throw ex;
        }
    }

    public KeyedConfigAccessor ofSection(String sectionName) {
        return this.ofSection(sectionName, this.level);
    }

    public KeyedConfigAccessor ofSection(String sectionName, int withLevel) {
        KeyedConfigAccessor section = ((KingdomItemStyle)this.style).getOption(sectionName);
        ConfigAccessor masterSection = section.getSection();
        if (masterSection == null) {
            throw new IllegalStateException("Cannot find option '" + sectionName + "' for kingdom item: " + ((KingdomItemStyle)this.style).getName());
        }
        int closestOption = KingdomsConfig.getClosestLevelSection(masterSection, withLevel);
        KeyedConfigAccessor levelSection = section.withProperty(String.valueOf(closestOption)).applyProperties();
        if (levelSection == null) {
            throw new IllegalStateException("Cannot find option level section " + closestOption + " for option '" + sectionName + "' for kingdom item: " + ((KingdomItemStyle)this.style).getName());
        }
        return levelSection;
    }

    public void setHolograms(@Nonnull Set<UUID> holograms) {
        this.holograms = holograms;
    }

    public List<ArmorStand> getHolograms() {
        return this.hologramsV2;
    }

    public void spawnHolograms(@Nonnull Kingdom kingdom) {
        Collection players = this.location.getBukkitWorld().getPlayers();
        if (((KingdomItemStyle)this.style).hideHolograms()) {
            players = players.stream().filter(x -> {
                KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)x);
                Kingdom playerKingdom = kp.getKingdom();
                return KingdomsPluginPermission.SEE_OTHERS_HOLOGRAMS.hasPermission((CommandSender)x, false) || kp.isAdmin() || StandardRelationAttribute.SHOW_HOLOGRAMS.hasAttribute(playerKingdom, kingdom);
            }).collect(Collectors.toList());
        }
        this.spawnHolograms(kingdom, players);
    }

    public List<ArmorStand> spawnHolograms(@Nonnull Kingdom kingdom, Collection<? extends Player> players) {
        ArrayList<ArmorStand> holograms = new ArrayList<ArmorStand>();
        if (players.isEmpty()) {
            return holograms;
        }
        List<String> lines = ((KingdomItemStyle)this.style).getHolograms(this.level);
        if (lines == null || lines.isEmpty()) {
            return holograms;
        }
        this.removeOldHolograms();
        Location loc = this.location.toBukkitLocation();
        double height = ((KingdomItemStyle)this.style).getHologramHeight(this.level);
        loc.add(0.5, height, 0.5);
        for (String line : lines) {
            if (line.startsWith("SPACE:")) {
                double compact;
                line = StringUtils.deleteWhitespace(line.substring(6));
                try {
                    compact = Double.parseDouble(line);
                }
                catch (NumberFormatException ex) {
                    KLogger.error("Expected a decimal value for hologram 'SPACE:' but got '" + line + "' for kingdom item '" + ((KingdomItemStyle)this.style).getName() + '\'');
                    compact = 1.0;
                }
                if (compact == 0.0) continue;
                loc.add(0.0, -compact, 0.0);
                continue;
            }
            line = MessageCompiler.compile(line).buildPlain(this.getEdits(kingdom).withContext(kingdom));
            ArmorStand hologram = HologramFactory.spawn(loc, players, line);
            this.hologramsV2.add(hologram);
            holograms.add(hologram);
        }
        return holograms;
    }

    public void updateHolograms(@NonNull Kingdom kingdom) {
        this.removeHolograms();
        this.spawnHolograms(kingdom);
    }
}

