/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.structures;

import com.google.common.base.Strings;
import org.kingdoms.config.ConfigAccessor;
import org.kingdoms.config.KeyedConfigAccessor;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.KeyedYamlConfigAccessor;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.abstraction.KingdomItemStyle;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.config.ConfigPath;
import org.kingdoms.utils.config.adapters.YamlResource;

public class StructureStyle
extends KingdomItemStyle<Structure, StructureStyle, StructureType> {
    private final YamlResource config;

    public StructureStyle(String name, YamlResource config) {
        super(name, StructureRegistry.getType(config.getConfig().getString("type")));
        this.config = config;
    }

    public YamlResource getConfig() {
        return this.config;
    }

    public double eval(String option, Kingdom kingdom, int lvl) {
        KeyedConfigAccessor section = this.getOption(option);
        ConfigAccessor realSection = section.getSection();
        if (realSection == null) {
            String str = section.getString();
            if (!Strings.isNullOrEmpty((String)str)) {
                return MathUtils.eval(str, kingdom, "level", lvl);
            }
            throw new IllegalArgumentException("Unknown eval value for option " + option + " kingdom item style " + this.name);
        }
        int closestSec = KingdomsConfig.getClosestLevelSection(realSection, lvl);
        section = section.withProperty(String.valueOf(closestSec));
        return MathUtils.eval(section.getString(), kingdom, "level", lvl);
    }

    @Override
    public boolean hasItem() {
        return !((StructureType)this.getType()).isNexus() && super.hasItem();
    }

    @Override
    public KeyedConfigAccessor getOption(String ... option) {
        return new KeyedYamlConfigAccessor(this.config, new ConfigPath(option)).noDefault();
    }
}

