/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.structures;

import java.util.HashSet;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.abstraction.KingdomItemType;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.abstraction.gui.KingdomItemGUIContext;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.type.nexus.StructureNationNexus;
import org.kingdoms.constants.land.structures.type.nexus.StructureNexus;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.events.items.KingdomItemUpgradeEvent;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.utils.nbt.ItemNBT;
import org.kingdoms.utils.nbt.NBTType;
import org.kingdoms.utils.string.StringUtils;

public abstract class StructureType
extends KingdomItemType<Structure, StructureStyle, StructureType> {
    public static final String METADATA = "Structure";

    public StructureType(String name) {
        super(name);
    }

    public static StructureType getType(ItemStack item) {
        String tag = ItemNBT.getTag(item).get(METADATA, NBTType.STRING);
        return tag == null ? null : StructureRegistry.getType(tag);
    }

    public boolean isNationalNexus() {
        return this instanceof StructureNationNexus;
    }

    public boolean isNexus() {
        return this instanceof StructureNexus;
    }

    @Override
    public Structure build(KingdomItemBuilder<Structure, StructureStyle, StructureType> builder) {
        return new Structure(builder.getStyle(), builder.getLocation());
    }

    protected void pushUpgrade(InteractiveGUI gui, KingdomItemGUIContext<Structure> context, Kingdom kingdom) {
        Player player = gui.getOwner();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Structure structure = (Structure)context.getEvent().getKingdomItem();
        int maxLevel = structure.getMaxLevel(kingdom);
        int upgradeCost = structure.getUpgradeCost(kingdom);
        gui.push("upgrade", () -> {
            if (structure.getLevel() >= maxLevel) {
                KingdomsLang.STRUCTURES_UPGRADE_MAX_LEVEL.sendMessage((CommandSender)player);
                return;
            }
            KingdomItemUpgradeEvent event = new KingdomItemUpgradeEvent(structure, structure.getLevel(), structure.getLevel() + 1, upgradeCost, kp);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            long upgradeFinalCost = event.getResourcePointsCost();
            if (!kp.isAdmin()) {
                if (kingdom.getResourcePoints() < upgradeFinalCost) {
                    KingdomsLang.STRUCTURES_UPGRADE_NOT_ENOUGH_RESOURCE_POINTS.sendError((CommandSender)player, "cost", StringUtils.toFancyNumber(upgradeFinalCost));
                    return;
                }
                kingdom.addResourcePoints(-upgradeFinalCost);
            }
            structure.upgrade(event.getNewLevel());
            KingdomsLang.STRUCTURES_UPGRADE_UPGRADED.sendMessage((CommandSender)player, "level", structure.getLevel());
            this.open(context);
            context.closeForOthers();
        }, new Object[0]);
    }

    @Override
    public void deserialize(Structure item, DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(item, context);
        SectionableDataGetter provider = context.getDataProvider();
        item.setName(provider.getString("name"));
        item.setLevel(provider.getInt("level"));
        item.setHolograms(provider.get("holograms").asCollection(new HashSet(), (c, e) -> c.add(e.asUUID())));
    }
}

