/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.structures.objects;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Hopper;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.config.ConfigAccessor;
import org.kingdoms.config.KeyedConfigAccessor;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.FuelContainer;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.events.items.KingdomItemBreakEvent;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.events.items.structures.ExtractorCollectEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextBuilder;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.managers.ItemMatcher;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.PaperUtils;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.Fn;
import org.kingdoms.utils.nbt.NBTTagCompound;
import org.kingdoms.utils.nbt.NBTType;
import org.kingdoms.utils.nbt.NBTWrappers;
import org.kingdoms.utils.time.TimeFormatter;

public class Extractor
extends Structure
implements FuelContainer {
    private long lastCollected = System.currentTimeMillis();
    private transient long lastCalculated = System.currentTimeMillis();
    private long collected;
    private double fuel;
    private UUID lastCollector;
    private static final int[][] HOPPER_LOCATIONS = new int[][]{{0, 1, 0}, {1, 0, 0}, {0, 0, 1}, {-1, 0, 0}, {0, 0, -1}};

    public Extractor(StructureStyle type, SimpleLocation location) {
        super(type, location);
    }

    public long getLastCollected() {
        return this.lastCollected;
    }

    public void setLastCollected(long lastCollected) {
        this.lastCollected = lastCollected;
    }

    public UUID getLastCollector() {
        return this.lastCollector;
    }

    public void setLastCollector(UUID lastCollector) {
        this.lastCollector = lastCollector;
    }

    public void setCollected(long collected) {
        this.collected = collected;
    }

    @Override
    public double getFuel() {
        this.getCollectedResourcePoints();
        return this.fuel;
    }

    @Override
    public void setFuel(double fuel) {
        if (this.fuel <= 0.0) {
            this.lastCalculated = System.currentTimeMillis();
        }
        this.fuel = fuel;
    }

    @Override
    public double getMaxFuel() {
        return this.getMaxFuel(this.getLand().getKingdom(), this.level);
    }

    @Override
    public KingdomItemBreakEvent<?> remove(KingdomItemRemoveContext context) {
        this.collect(context.getPlayer());
        return super.remove(context);
    }

    public long getCollectedResourcePoints() {
        long capacity = (long)MathUtils.eval(((StructureStyle)this.style).getOption("capacity").getMathExpression(), new PlaceholderContextBuilder().withContext(this.getLand().getKingdom()));
        long currTime = System.currentTimeMillis();
        if (this.collected >= capacity) {
            this.lastCalculated = currTime;
            return this.collected;
        }
        long diff = currTime - this.lastCalculated;
        KeyedConfigAccessor section = this.ofSection("generator", this.level);
        long every = section.withProperty("every").getTimeMillis(TimeUnit.SECONDS);
        if (diff < every) {
            return this.collected;
        }
        long mod = diff / every;
        long amt = section.clearExtras().withProperty("amount").getLong();
        long total = amt * mod;
        if (total > capacity) {
            total = capacity;
        }
        if (((StructureStyle)this.getStyle()).getOption("fuel", "enabled").getBoolean()) {
            double everyNeededFuel = section.clearExtras().withProperty("fuel").getDouble();
            if (((StructureStyle)this.getStyle()).getOption("fuel", "allow-hoppers").getBoolean() && this.fuel <= everyNeededFuel) {
                this.fillFuelFromAttachedHopper();
            }
            if (this.fuel > 0.0) {
                if (this.fuel >= everyNeededFuel) {
                    double totalNeededFuel = everyNeededFuel * (double)mod;
                    double left = this.fuel - totalNeededFuel;
                    if (left < 0.0) {
                        long leftMod = (long)Math.ceil(Math.abs(left) / everyNeededFuel);
                        total = amt * (mod -= leftMod);
                        this.fuel = 0.0;
                    } else {
                        this.fuel = left;
                    }
                } else {
                    total = 0L;
                }
            } else {
                total = 0L;
            }
        }
        this.lastCalculated = currTime - diff % every;
        return this.collected += total;
    }

    public CompletableFuture<List<Hopper>> getAttachedHoppers() {
        HashSet<SimpleChunkLocation> chunks = new HashSet<SimpleChunkLocation>(3);
        ArrayList<SimpleLocation> blockLocations = new ArrayList<SimpleLocation>(4);
        for (int[] hopperLocation : HOPPER_LOCATIONS) {
            SimpleLocation hopperLoc = this.location.getRelative(hopperLocation[0], hopperLocation[1], hopperLocation[2]);
            chunks.add(hopperLoc.toSimpleChunkLocation());
            blockLocations.add(hopperLoc);
        }
        return PaperUtils.prepareChunks(chunks).thenApply(loaded -> {
            ArrayList<Hopper> hoppers = new ArrayList<Hopper>(4);
            for (SimpleLocation hopperLoc : blockLocations) {
                Block block = hopperLoc.getBlock();
                BlockState data = block.getState();
                if (!(data instanceof Hopper)) continue;
                hoppers.add((Hopper)data);
            }
            return hoppers;
        });
    }

    public void fillFuelFromAttachedHopper() {
        this.getAttachedHoppers().thenAccept(hoppers -> {
            for (Hopper hopper : hoppers) {
                ItemStack[] content = hopper.getInventory().getContents();
                ConfigAccessor settings = ((StructureStyle)this.style).getOption("fuel").getSection();
                boolean changed = false;
                for (int i = 0; i < content.length; ++i) {
                    ConfigSection variant;
                    ItemStack item = content[i];
                    if (item == null) continue;
                    ItemMatcher matched = null;
                    Iterator<ConfigSection> iterator = settings.gotoSection("variants").getSection().getSections().values().iterator();
                    while (iterator.hasNext() && !(matched = new ItemMatcher(variant = iterator.next())).matches(item)) {
                        matched = null;
                    }
                    if (matched == null) continue;
                    double fillPerItem = matched.getSection().getDouble("fill-amount-per-item");
                    double capacity = this.getMaxFuel();
                    if (capacity - this.fuel < fillPerItem) continue;
                    double amount = item.getAmount();
                    double added = fillPerItem * amount;
                    double oldAmount = this.fuel;
                    this.setFuel(Math.min(capacity, this.fuel + added));
                    double needed = capacity - oldAmount;
                    int keep = (int)Math.floor((added - needed) / fillPerItem);
                    if (keep > 0) {
                        item.setAmount(keep);
                    } else {
                        content[i] = null;
                    }
                    changed = true;
                    if (oldAmount >= capacity) break;
                }
                if (!changed) continue;
                hopper.getInventory().setContents(content);
            }
        });
    }

    @Override
    public MessageBuilder getEdits(Kingdom kingdom) {
        KeyedConfigAccessor currSection = this.ofSection("generator", this.level);
        KeyedConfigAccessor nextSection = this.ofSection("generator", this.level + 1);
        return super.getEdits(kingdom).raw("extractor_collected_resource_points", this.getCollectedResourcePoints()).raw("extractor-last-collector", Fn.supply(() -> Bukkit.getOfflinePlayer((UUID)this.lastCollector).getName())).raw("extractor-last-collected-time-passed", TimeFormatter.of(System.currentTimeMillis() - this.lastCollected)).raw("resource-points", currSection.withProperty("amount").getInt()).raw("next-resource-points", nextSection.withProperty("amount").getInt()).raw("every", currSection.clearExtras().withProperty("every").getString()).raw("next-every", nextSection.clearExtras().withProperty("every").getString()).raw("fuel", this.fuel).raw("max_fuel", this.getMaxFuel(kingdom, this.level)).raw("next_max_fuel", this.getMaxFuel(kingdom, this.level + 1)).raw("extractor_needed_fuel", currSection.clearExtras().withProperty("fuel").getString()).raw("next_extractor_needed_fuel", nextSection.clearExtras().withProperty("fuel").getString());
    }

    public double getMaxFuel(Kingdom kingdom, int level) {
        return this.eval(((StructureStyle)this.style).getOption("fuel", "capacity"), kingdom, level);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 15;
        result = prime * result + super.hashCode();
        result = prime * result + this.lastCollector.hashCode();
        result = prime * result + Long.hashCode(this.lastCollected);
        result = prime * result + Long.hashCode(this.collected);
        result = prime * result + Double.hashCode(this.fuel);
        return result;
    }

    public long collect(@Nullable KingdomPlayer kp) {
        return this.collect(kp == null ? null : kp.getId());
    }

    public long collect(@Nullable UUID id) {
        ExtractorCollectEvent event = new ExtractorCollectEvent(this, id == null ? null : KingdomPlayer.getKingdomPlayer(id));
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return 0L;
        }
        long amount = this.getCollectedResourcePoints();
        Kingdom kingdom = this.getLand().getKingdom();
        if (kingdom != null) {
            kingdom.addResourcePoints(amount);
        }
        if (id != null) {
            this.lastCollector = id;
        }
        this.collected = 0L;
        return amount;
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.setLong("collected", this.getCollectedResourcePoints());
        json.setUUID("lastCollector", this.lastCollector);
        json.setLong("lastCollected", this.lastCollected);
        json.setDouble("fuel", this.fuel);
    }

    @Override
    public Pair<ItemStack, NBTTagCompound> getTags() {
        Pair<ItemStack, NBTTagCompound> pair = super.getTags();
        if (pair == null) {
            return null;
        }
        NBTWrappers.NBTTagCompound tag = (NBTWrappers.NBTTagCompound)pair.getValue();
        tag = tag.getCompound("Kingdoms");
        tag.set("Fuel", NBTType.DOUBLE, this.getFuel());
        return pair;
    }

    @Override
    public void setDataFromNBT(NBTTagCompound tag) {
        super.setDataFromNBT(tag);
        Double fuel = tag.get("Fuel", NBTType.DOUBLE);
        this.fuel = fuel == null ? 0.0 : fuel;
    }
}

