/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.structures.objects;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;
import org.kingdoms.abstraction.PlayerOperator;
import org.kingdoms.config.ConfigAccessor;
import org.kingdoms.config.KeyedConfigAccessor;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.events.items.KingdomItemBreakEvent;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.xseries.ReflectionUtils;
import org.kingdoms.libs.xseries.SkullUtils;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.messages.ActionBar;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.ChairManager;
import org.kingdoms.managers.ChairSession;
import org.kingdoms.managers.land.protection.LandExplosionManager;
import org.kingdoms.managers.structures.SiegeCannonAmmo;
import org.kingdoms.utils.Chair;
import org.kingdoms.utils.nbt.NBTTagCompound;
import org.kingdoms.utils.nbt.NBTType;
import org.kingdoms.utils.nbt.NBTWrappers;
import org.kingdoms.utils.time.TimeFormatter;

public class SiegeCannon
extends Structure
implements PlayerOperator {
    public static final String SIEGE_CANNON = "SIEGE_CANNON";
    public static final String SIEGE_PROJECTILE = "SIEGE_PROJECTILE";
    protected transient long lastShot;
    private transient SiegeCannonAmmo loaded;
    private transient Player handler;
    private transient ArmorStand[] decorators;
    private transient BukkitTask visualsAnimation;
    private transient int shootingAnimation;
    public static final Namespace NS = Namespace.kingdoms("SIEGE_CANNON");

    public SiegeCannon(StructureStyle type, SimpleLocation location) {
        super(type, location);
    }

    public static Pair<SiegeCannon, SiegeCannonAmmo> getSiegeCannonFromProjectile(Entity entity) {
        Objects.requireNonNull(entity, "Cannot get siege cannon from null entity");
        if (entity.getType() != EntityType.FIREBALL) {
            return null;
        }
        List meta = entity.getMetadata(SIEGE_CANNON);
        if (meta.isEmpty()) {
            return null;
        }
        SiegeCannon cannon = (SiegeCannon)((MetadataValue)meta.get(0)).value();
        SiegeCannonAmmo ammo = (SiegeCannonAmmo)((MetadataValue)entity.getMetadata(SIEGE_PROJECTILE).get(0)).value();
        return Pair.of(cannon, ammo);
    }

    private static void smoothMove(Location location, Vector direction, ArmorStand entity, double distance) {
        Location directionalLoc = location.clone().add(0.0, 1.0, 0.0);
        Location inFront = directionalLoc.add(direction.clone().multiply(distance));
        entity.teleport(inFront);
        entity.setHeadPose(new EulerAngle(-direction.getY(), 0.0, 0.0));
    }

    public ArmorStand[] getDecorators() {
        return this.decorators;
    }

    public void shoot() {
        Location location = this.decorators[3].getEyeLocation().add(0.0, 1.5, 0.0);
        Vector direction = location.getDirection();
        Fireball fireball = (Fireball)location.getWorld().spawn(location, Fireball.class);
        fireball.setDirection(direction);
        fireball.setMetadata(SIEGE_CANNON, (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.get(), (Object)this));
        fireball.setMetadata(SIEGE_PROJECTILE, (MetadataValue)new FixedMetadataValue((Plugin)Kingdoms.get(), (Object)this.loaded));
        fireball.setYield(1.0f);
        this.loaded = null;
        this.lastShot = System.currentTimeMillis();
        this.shootingAnimation = 40;
        this.playSound("shoot");
        this.displayParticle(location, "shoot");
        this.cooldownIndicator();
    }

    @Override
    public MessageBuilder getEdits(Kingdom kingdom) {
        return super.getEdits(kingdom).raw("knockback", this.eval("knockback", kingdom, this.level) + (this.loaded == null ? 0.0 : this.loaded.getKnockback())).raw("next-knockback", this.eval("knockback", kingdom, this.level + 1) + (this.loaded == null ? 0.0 : this.loaded.getKnockback())).raw("damage", this.eval("damage", kingdom, this.level) + (this.loaded == null ? 0.0 : this.loaded.getDamage())).raw("next-damage", this.eval("damage", kingdom, this.level + 1) + (this.loaded == null ? 0.0 : this.loaded.getDamage())).raw("cooldown", this.ofSection("cooldown", this.level).getString()).raw("next-cooldown", this.ofSection("cooldown", this.level + 1).getString()).raw("explosion-radius", ((StructureStyle)this.style).eval("explosion-radius", kingdom, this.level) + (this.loaded == null ? 0.0 : this.loaded.getExplosionRadius())).raw("next-explosion-radius", ((StructureStyle)this.style).eval("explosion-radius", kingdom, this.level + 1) + (this.loaded == null ? 0.0 : this.loaded.getExplosionRadius())).raw("shield-damage", TimeFormatter.of(this.ofSection("shield-damage", this.level).getTimeMillis() + (this.loaded == null ? 0L : this.loaded.getShieldDamage()))).raw("next-shield-damage", TimeFormatter.of(this.ofSection("shield-damage", this.level + 1).getTimeMillis() + (this.loaded == null ? 0L : this.loaded.getShieldDamage())));
    }

    public int getExplosionRadius(SiegeCannonAmmo loaded) {
        return (int)(((StructureStyle)this.style).eval("explosion-radius", this.getLand().getKingdom(), this.level) + (loaded == null ? 0.0 : loaded.getExplosionRadius()));
    }

    public double getDamage(SiegeCannonAmmo loaded) {
        return (int)(this.eval("damage", this.getLand().getKingdom(), this.level) + (loaded == null ? 0.0 : loaded.getDamage()));
    }

    public double getKnockBack(SiegeCannonAmmo loaded) {
        return (int)(this.eval("knockback", this.getLand().getKingdom(), this.level) + (loaded == null ? 0.0 : loaded.getKnockback()));
    }

    public long getShieldDamage(SiegeCannonAmmo loaded) {
        return this.ofSection("shield-damage", this.level).getTimeMillis() + (loaded == null ? 0L : loaded.getShieldDamage());
    }

    public long getArmorDamage(SiegeCannonAmmo loaded) {
        return this.ofSection("armor-damage", this.level).getTimeMillis();
    }

    private void cooldownIndicator() {
        if (this.lastShot <= 0L) {
            return;
        }
        final long cooldown = this.getCooldown();
        if (cooldown <= 0L) {
            return;
        }
        final long sinceShot = System.currentTimeMillis() - this.lastShot;
        if (sinceShot >= cooldown) {
            return;
        }
        new BukkitRunnable(){
            int leftSeconds;
            {
                this.leftSeconds = (int)((cooldown - sinceShot) / 1000L);
            }

            public void run() {
                Player player = SiegeCannon.this.getHandler();
                if (player != null) {
                    MessageObject actionbarObj = MessageCompiler.compile(((StructureStyle)SiegeCannon.this.style).getOption("actionbar", "cooldown").getString());
                    String actionbar = actionbarObj.buildPlain(new MessageBuilder().withContext(player).raw("cooldown", this.leftSeconds));
                    ActionBar.sendActionBar((Plugin)Kingdoms.get(), player, actionbar);
                }
                if (--this.leftSeconds <= 0) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)Kingdoms.get(), 0L, 20L);
    }

    public long getLastShot() {
        return this.lastShot;
    }

    public long getCooldown() {
        return this.ofSection("cooldown").getTimeMillis();
    }

    public boolean isInCooldown() {
        if (this.lastShot == 0L) {
            return false;
        }
        long now = System.currentTimeMillis();
        long passed = now - this.lastShot;
        return passed < this.getCooldown();
    }

    @Override
    public void setDataFromNBT(NBTTagCompound tag) {
        super.setDataFromNBT(tag);
        Long lastShot = tag.get("LastShot", NBTType.LONG);
        this.lastShot = lastShot == null ? 0L : lastShot;
    }

    public void standup() {
        if (this.visualsAnimation != null) {
            this.visualsAnimation.cancel();
            this.visualsAnimation = null;
        }
        if (this.decorators != null) {
            for (ArmorStand armorStand : this.decorators) {
                armorStand.remove();
            }
            this.decorators = null;
        }
        if (this.handler != null) {
            ChairManager.standUp((Entity)this.handler);
        }
        this.playSound("standup");
        this.handler = null;
    }

    public void sit(Player player) {
        this.handler = Objects.requireNonNull(player, "Null player cannot sit on siege cannon");
        Entity chair = Chair.sitOnChair(player, this.location.toBukkitLocation().add(0.0, 0.5, 0.0));
        ChairManager.sit((Entity)player, new ChairSession<Object>(chair, this::standup, this));
        this.playSound("sit");
        this.visuals(player);
        this.cooldownIndicator();
    }

    @Override
    public KingdomItemBreakEvent<?> remove(KingdomItemRemoveContext context) {
        this.standup();
        return super.remove(context);
    }

    public List<String> getTubeTextures() {
        ConfigAccessor section = ((StructureStyle)this.style).getOption("tube-textures").getSection();
        int closestSection = KingdomsConfig.getClosestLevelSection(section, this.level);
        return section.getStringList(String.valueOf(closestSection));
    }

    private void visuals(final Player player) {
        Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> {
            MessageObject actionbarObj = MessageCompiler.compile(((StructureStyle)this.style).getOption("actionbar", "sit").getString());
            String actionbar = actionbarObj.buildPlain(this.getEdits().withContext(player));
            ActionBar.sendActionBar((Plugin)Kingdoms.get(), player, actionbar);
        }, 3L);
        final ArmorStand handle = (ArmorStand)player.getWorld().spawnEntity(this.location.toBukkitLocation().add(0.5, 0.0, 0.5), EntityType.ARMOR_STAND);
        handle.setVisible(false);
        handle.setGravity(false);
        handle.setCollidable(false);
        handle.setArms(true);
        handle.setInvulnerable(false);
        ItemStack stick = XMaterial.STICK.parseItem();
        handle.getEquipment().setItemInMainHand(stick);
        handle.getEquipment().setItemInOffHand(stick);
        EulerAngle handPos = new EulerAngle(-Math.toRadians(95.0), 0.0, 0.0);
        handle.setRightArmPose(handPos);
        handle.setLeftArmPose(handPos);
        List<String> textures = this.getTubeTextures();
        final ArmorStand first = this.spawnBlockArmor(player.getWorld(), textures.get(0), 0.0, 1.0, 1.0);
        final ArmorStand second = this.spawnBlockArmor(player.getWorld(), textures.get(1), 0.0, 1.0, 1.6);
        final ArmorStand third = this.spawnBlockArmor(player.getWorld(), textures.get(2), 0.0, 1.0, 2.1);
        this.decorators = new ArmorStand[]{handle, first, second, third};
        this.visualsAnimation = new BukkitRunnable(){

            public void run() {
                Location loc = player.getLocation();
                Vector direction = loc.getDirection();
                if (SiegeCannon.this.shootingAnimation > 0) {
                    double amount = (double)SiegeCannon.this.shootingAnimation / 35.0;
                    SiegeCannon.smoothMove(loc, direction, first, 1.0 - amount);
                    SiegeCannon.smoothMove(loc, direction, second, 1.6 - amount);
                    SiegeCannon.smoothMove(loc, direction, third, 2.1 - amount);
                    SiegeCannon.this.shootingAnimation--;
                    return;
                }
                SiegeCannon.smoothMove(loc, direction, first, 1.0);
                SiegeCannon.smoothMove(loc, direction, second, 1.6);
                SiegeCannon.smoothMove(loc, direction, third, 2.1);
                if (ReflectionUtils.supports(13)) {
                    handle.setRotation(loc.getYaw(), loc.getPitch());
                } else {
                    handle.teleport(player.getLocation());
                }
            }
        }.runTaskTimer((Plugin)Kingdoms.get(), 5L, 1L);
    }

    public boolean canDamage(LandExplosionManager.BlockType cat, String category, Supplier<String> type) {
        KeyedConfigAccessor option = ((StructureStyle)this.style).getOption("allow-damaging");
        int sectionLvl = KingdomsConfig.getClosestLevelSection(option.getSection(), this.level, category);
        if ((option = option.withProperty(String.valueOf(sectionLvl)).withProperty(category)).getBoolean()) {
            return true;
        }
        List<String> list2 = option.getStringList();
        if (cat == LandExplosionManager.BlockType.OTHER && !list2.isEmpty() && list2.get(0).equals("*")) {
            return false;
        }
        return list2.contains(type.get()) == (cat != LandExplosionManager.BlockType.OTHER);
    }

    private ArmorStand spawnBlockArmor(World world, String skull, double offsetx, double offsety, double offsetz) {
        ArmorStand handle = (ArmorStand)world.spawnEntity(this.location.toBukkitLocation().add(0.5 + offsetx, offsety - 0.5, 0.5 + offsetz), EntityType.ARMOR_STAND);
        handle.setMarker(true);
        handle.setGravity(false);
        handle.setVisible(false);
        handle.setCollidable(false);
        handle.setInvulnerable(true);
        ItemStack head = XMaterial.PLAYER_HEAD.parseItem();
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        head.setItemMeta((ItemMeta)SkullUtils.applySkin((ItemMeta)meta, skull));
        handle.getEquipment().setHelmet(head);
        return handle;
    }

    @Override
    public Pair<ItemStack, NBTTagCompound> getTags() {
        Pair<ItemStack, NBTTagCompound> pair = super.getTags();
        if (pair == null) {
            return null;
        }
        NBTWrappers.NBTTagCompound tag = (NBTWrappers.NBTTagCompound)pair.getValue();
        tag = tag.getCompound("Kingdoms");
        if (this.lastShot != 0L) {
            tag.set("LastShot", NBTType.LONG, this.lastShot);
        }
        return pair;
    }

    public Player getHandler() {
        return this.handler;
    }

    public void load(SiegeCannonAmmo ammo) {
        this.loaded = ammo;
    }

    public boolean isLoaded() {
        return this.loaded != null;
    }

    public SiegeCannonAmmo getLoaded() {
        return this.loaded;
    }

    @Override
    @Nullable
    public KingdomPlayer getPlayer() {
        return KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.handler);
    }
}

