/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.turrets;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.kingdoms.config.managers.ConfigManager;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.TurretType;
import org.kingdoms.constants.land.turrets.types.TurretArrow;
import org.kingdoms.constants.land.turrets.types.TurretHealing;
import org.kingdoms.constants.land.turrets.types.TurretInferno;
import org.kingdoms.constants.land.turrets.types.TurretPressureMine;
import org.kingdoms.constants.land.turrets.types.TurretSoldier;
import org.kingdoms.libs.snakeyaml.validation.NodeValidator;
import org.kingdoms.libs.snakeyaml.validation.Validator;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.config.CustomConfigValidators;
import org.kingdoms.utils.config.adapters.YamlContainer;
import org.kingdoms.utils.config.adapters.YamlResource;

public class TurretRegistry {
    private static final Map<String, TurretType> TYPES = new HashMap<String, TurretType>();
    private static final Map<String, TurretStyle> STYLES = new HashMap<String, TurretStyle>();
    protected static final NodeValidator SCHEMA;
    public static final Path TURRETS_PATH;

    public static void register(String simpleName, String typeName, BiConsumer<String, YamlResource> registrar) {
        Path folder = Kingdoms.getFolder().resolve(typeName);
        if (!Files.exists(folder, new LinkOption[0])) {
            URI uri = null;
            try {
                uri = Kingdoms.class.getResource('/' + typeName).toURI();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            try (FileSystem zipfs = FileSystems.newFileSystem(uri, new HashMap());){
                for (Path path : zipfs.getRootDirectories()) {
                    Stream<Path> stream = Files.list(path.resolve('/' + typeName));
                    try {
                        stream.forEach(item -> {
                            String name = item.getFileName().toString();
                            name = name.substring(0, name.length() - 4);
                            MessageHandler.sendConsolePluginMessage("Registering Default " + simpleName + "&8: &6" + name);
                            String pathLocation = item.toString().substring(1);
                            YamlResource adapter = new YamlResource(new File(Kingdoms.get().getDataFolder(), pathLocation), pathLocation).load();
                            registrar.accept(name, adapter);
                        });
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try (Stream<Path> stream = Files.list(folder);){
                stream.forEach(item -> {
                    String name = item.getFileName().toString();
                    name = name.substring(0, name.length() - 4);
                    MessageHandler.sendConsolePluginMessage("Registering " + simpleName + "&8: &6" + name);
                    String pathLocation = item.toString();
                    YamlResource adapter = new YamlResource(item.toFile(), pathLocation).load();
                    registrar.accept(name, adapter);
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static TurretType registerType(TurretType type) {
        return TYPES.put(type.getName(), type);
    }

    public static TurretStyle registerStyle(TurretStyle style) {
        style.loadSettings();
        return STYLES.put(style.getName(), style);
    }

    public static void init() {
        STYLES.clear();
        TurretRegistry.register("Turret", "Turrets", (name, adapter) -> {
            TurretRegistry.validate(name, adapter);
            TurretRegistry.registerStyle(new TurretStyle((String)name, (YamlResource)adapter));
        });
    }

    public static void validate(String name, YamlContainer adapter) {
        ConfigManager.warnAboutValidation("Turrets/" + name, Validator.validate(adapter.getConfig().getNode(), SCHEMA, CustomConfigValidators.getValidators()));
    }

    public static TurretStyle getStyle(String turret) {
        return STYLES.get(turret);
    }

    public static Map<String, TurretType> getTypes() {
        return TYPES;
    }

    public static Map<String, TurretStyle> getStyles() {
        return STYLES;
    }

    public static TurretType getType(String name) {
        return TYPES.get(name);
    }

    static {
        TurretRegistry.registerType(new TurretArrow());
        TurretRegistry.registerType(new TurretHealing());
        TurretRegistry.registerType(new TurretInferno());
        TurretRegistry.registerType(new TurretSoldier());
        TurretRegistry.registerType(new TurretPressureMine());
        SCHEMA = YamlContainer.parseValidator("Turret Schema", "schemas/Turrets/turret.yml");
        TURRETS_PATH = Kingdoms.getPath("Turrets");
    }
}

