/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.turrets;

import com.google.common.base.Strings;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.abstraction.KingdomItemType;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.abstraction.gui.KingdomItemGUIContext;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.objects.RangedTurret;
import org.kingdoms.constants.land.turrets.types.TurretTypeRanged;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.items.KingdomItemInteractEvent;
import org.kingdoms.events.items.KingdomItemUpgradeEvent;
import org.kingdoms.events.items.turrets.TurretActivateEvent;
import org.kingdoms.events.items.turrets.TurretAmmoFillEvent;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.managers.ChairManager;
import org.kingdoms.managers.ChairSession;
import org.kingdoms.utils.Chair;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.config.ConfigSection;

public abstract class TurretType
extends KingdomItemType<Turret, TurretStyle, TurretType> {
    public static final String METADATA = "Turret";
    private final boolean enemies;
    private final boolean friends;

    public TurretType(String name, boolean enemies, boolean friends) {
        super(name);
        this.enemies = enemies;
        this.friends = friends;
    }

    protected static boolean call(TurretActivateEvent event) {
        Bukkit.getPluginManager().callEvent((Event)event);
        event.getTurret().setLastActivation(event);
        return event.isCancelled();
    }

    public boolean isRanged() {
        return this instanceof TurretTypeRanged;
    }

    @Override
    public InteractiveGUI open(KingdomItemGUIContext<Turret> context) {
        KingdomItemInteractEvent<Turret> event = context.getEvent();
        Kingdom kingdom = event.getPlayer().getKingdom();
        KingdomPlayer kp = event.getPlayer();
        Player player = kp.getPlayer();
        boolean admin = KingdomsPluginPermission.TURRETS_INTERACT.hasPermission((CommandSender)player, true);
        Turret turret = (Turret)event.getKingdomItem();
        int upgradeCost = turret.getUpgradeCost(kingdom);
        InteractiveGUI gui = GUIAccessor.prepare(player, "turrets/" + ((TurretStyle)turret.getStyle()).getName(), true, turret.getEdits(kingdom));
        if (gui == null) {
            return null;
        }
        int maxLevel = turret.getMaxLevel(kingdom);
        gui.push("upgrade", () -> {
            if (turret.getLevel() >= maxLevel) {
                KingdomsLang.TURRET_UPGRADE_MAX_LEVEL.sendMessage((CommandSender)player);
                return;
            }
            if (!admin && !kingdom.hasResourcePoints(upgradeCost)) {
                KingdomsLang.TURRET_UPGRADE_NOT_ENOUGH_RESOURCE_POINTS.sendMessage((CommandSender)player);
                return;
            }
            KingdomItemUpgradeEvent upgradeEvent = new KingdomItemUpgradeEvent(turret, turret.getLevel(), turret.getLevel() + 1, upgradeCost, kp);
            Bukkit.getPluginManager().callEvent((Event)upgradeEvent);
            if (upgradeEvent.isCancelled()) {
                return;
            }
            if (!admin) {
                kingdom.addResourcePoints(-upgradeCost);
            }
            turret.upgrade(upgradeEvent.getNewLevel());
            KingdomsLang.TURRET_UPGRADE_UPGRADED.sendMessage((CommandSender)player, "level", turret.getLevel());
            this.open(context);
            context.closeForOthers();
        }, new Object[0]);
        if (turret instanceof RangedTurret) {
            RangedTurret ammoTurret = (RangedTurret)turret;
            int maxAmmo = ammoTurret.getMaxAmmo(kingdom);
            gui.option("manual").on(ClickType.LEFT, () -> {
                ammoTurret.setManual(!ammoTurret.isManual());
                this.open(context);
                context.closeForOthers();
            }).on(ClickType.RIGHT, () -> {
                if (!ammoTurret.isManual()) {
                    KingdomsLang.TURRETS_NOT_MANUAL.sendError((CommandSender)player, new Object[0]);
                    return;
                }
                ammoTurret.setOperator(player);
                Entity chair = Chair.sitOnChair(player, ammoTurret.getLocation().toBukkitLocation().add(0.0, 0.5, 0.0));
                ChairManager.sit((Entity)player, new ChairSession<Object>(chair, () -> ammoTurret.setOperator(null), ammoTurret));
                KingdomsLang.TURRETS_MANUAL_OPERATING.sendMessage((CommandSender)player);
            }).done();
            ConfigSection options = gui.getOptionsSection().getSection("ammo");
            int cost = options.getInt("cost");
            String fillCostStr = options.getString("fill-cost");
            if (Strings.isNullOrEmpty((String)fillCostStr)) {
                fillCostStr = "neededAmmo / 8";
            }
            int fillCost = (int)MathUtils.eval(fillCostStr, kingdom, "neededAmmo", maxAmmo - ammoTurret.getAmmo());
            int buyAmmoAmount = options.getInt("ammo");
            Runnable normalPurchase = () -> {
                if (!admin && kingdom.getResourcePoints() < (long)cost) {
                    KingdomsLang.TURRET_AMMO_NOT_ENOUGH_RESOURCE_POINTS.sendMessage((CommandSender)player);
                    return;
                }
                if (ammoTurret.getAmmo() + buyAmmoAmount > maxAmmo) {
                    KingdomsLang.TURRET_AMMO_MAX_AMMO.sendError((CommandSender)player, new Object[0]);
                    return;
                }
                TurretAmmoFillEvent ammoEvent = new TurretAmmoFillEvent(turret, buyAmmoAmount, cost, TurretAmmoFillEvent.FillType.NORMAL_PURCHASE, kp);
                Bukkit.getPluginManager().callEvent((Event)ammoEvent);
                if (ammoEvent.isCancelled()) {
                    return;
                }
                if (!admin) {
                    kingdom.addResourcePoints(-cost);
                }
                ammoTurret.addAmmo(ammoEvent.getAmount());
                this.open(context);
                KingdomsLang.TURRET_AMMO_PURCHASED.sendMessage((CommandSender)player);
                context.closeForOthers();
            };
            Runnable bulkPurchase = () -> {
                int updatedFillCost = (int)MathUtils.eval(options.getString("fill-cost"), kingdom, "neededAmmo", maxAmmo - ammoTurret.getAmmo());
                int left = maxAmmo - ammoTurret.getAmmo();
                if (!admin && kingdom.getResourcePoints() < (long)updatedFillCost) {
                    KingdomsLang.TURRET_AMMO_NOT_ENOUGH_RESOURCE_POINTS.sendMessage((CommandSender)player);
                    return;
                }
                TurretAmmoFillEvent ammoEvent = new TurretAmmoFillEvent(turret, left, updatedFillCost, TurretAmmoFillEvent.FillType.BULK_PURCHASE, kp);
                Bukkit.getPluginManager().callEvent((Event)ammoEvent);
                if (ammoEvent.isCancelled()) {
                    return;
                }
                if (!admin) {
                    kingdom.addResourcePoints(-updatedFillCost);
                }
                ammoTurret.addAmmo(ammoEvent.getAmount());
                this.open(context);
                KingdomsLang.TURRET_AMMO_PURCHASED.sendMessage((CommandSender)player);
                context.closeForOthers();
            };
            gui.option("ammo").setEdits("ammo-buy-amount", buyAmmoAmount, "cost", cost, "fill-cost", fillCost).on(ClickType.LEFT, normalPurchase).on(ClickType.SHIFT_LEFT, fillCost <= 0 ? normalPurchase : bulkPurchase).done();
        }
        context.finalizeGUI(gui);
        return gui;
    }

    public abstract boolean activate(TurretActivateEvent var1);

    public boolean isFriends() {
        return this.friends;
    }

    public boolean isEnemies() {
        return this.enemies;
    }

    @Override
    public Turret build(KingdomItemBuilder<Turret, TurretStyle, TurretType> builder) {
        return new Turret(builder.getStyle(), builder.getLocation());
    }
}

