/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.turrets.types;

import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.types.TurretTypeRanged;
import org.kingdoms.events.items.turrets.TurretActivateEvent;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.XParticle;

public class TurretHealing
extends TurretTypeRanged {
    public TurretHealing() {
        super("healing", false, true);
    }

    @Override
    public boolean activate(TurretActivateEvent event) {
        LivingEntity target = event.getTarget();
        if (target instanceof Player) {
            if (TurretHealing.call(event)) {
                return false;
            }
            Player player = (Player)target;
            double maxHp = player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
            if (player.getHealth() >= maxHp) {
                return false;
            }
            Turret turret = event.getTurret();
            double amount = turret.getDamage(event.getKingdom());
            EntityRegainHealthEvent regainEvent = new EntityRegainHealthEvent((Entity)target, amount, EntityRegainHealthEvent.RegainReason.CUSTOM);
            Bukkit.getPluginManager().callEvent((Event)regainEvent);
            if (regainEvent.isCancelled()) {
                return false;
            }
            amount = Math.min(player.getHealth() + regainEvent.getAmount(), maxHp);
            player.setHealth(amount);
            ParticleDisplay display = turret.getParticle();
            XParticle.line(event.getOrigin().clone().add(0.5, 0.0, 0.5), target.getEyeLocation().add(0.0, -0.25, 0.0), 0.2, display);
            target.addPotionEffects(turret.getEffects());
            return true;
        }
        return false;
    }
}

