/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.mails;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.mails.Mail;
import org.kingdoms.constants.mails.MailRecipientType;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;

public final class CachedMail {
    private final UUID id;
    private final @NonNull Group fromGroup;
    private final OfflinePlayer sender;
    private final @NonNull List<String> message;
    private final long sent;
    private final @NonNull String subject;
    private final @NonNull Map<Group, MailRecipientType> recipients;
    private final @Nullable Mail inReplyTo;

    public CachedMail(UUID id, @NonNull Group fromGroup, OfflinePlayer sender, @NonNull List<String> message, long sent, @NonNull String subject, @NonNull Map<Group, MailRecipientType> recipients, @Nullable Mail inReplyTo) {
        this.id = id;
        this.fromGroup = fromGroup;
        this.sender = sender;
        this.message = message;
        this.sent = sent;
        this.subject = subject;
        this.recipients = recipients;
        this.inReplyTo = inReplyTo;
    }

    public UUID getId() {
        return this.id;
    }

    public Group getFromGroup() {
        return this.fromGroup;
    }

    public OfflinePlayer getSender() {
        return this.sender;
    }

    public List<String> getMessage() {
        return Collections.unmodifiableList(this.message);
    }

    public long getSent() {
        return this.sent;
    }

    public String getSubject() {
        return this.subject;
    }

    public Map<Group, MailRecipientType> getRecipients() {
        return Collections.unmodifiableMap(this.recipients);
    }

    public Mail getInReplyTo() {
        return this.inReplyTo;
    }

    public @NonNull List<Group> getRecipientsOfType(MailRecipientType type) {
        ArrayList<Group> ids = new ArrayList<Group>(5);
        for (Map.Entry<Group, MailRecipientType> recipient : this.recipients.entrySet()) {
            if (recipient.getValue() != type) continue;
            ids.add(recipient.getKey());
        }
        return ids;
    }
}

