/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.metadata;

import java.awt.Color;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.constants.metadata.KingdomMetadata;
import org.kingdoms.constants.metadata.KingdomMetadataHandler;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.utils.internal.nonnull.NonNullMap;

public abstract class KingdomsObject<K> {
    protected @NonNull Map<KingdomMetadataHandler, KingdomMetadata> metadata;
    private transient @Nullable String saveMeta;

    protected KingdomsObject() {
        this.metadata = new NonNullMap<KingdomMetadataHandler, KingdomMetadata>();
    }

    protected KingdomsObject(@NonNull Map<KingdomMetadataHandler, KingdomMetadata> metadata) {
        this.setMetadata(metadata);
    }

    public static @NonNull String compressLocation(Location location) {
        if (location == null) {
            return "";
        }
        World world = location.getWorld();
        return (world == null ? "" : world.getName()) + location.getX() + location.getY() + location.getZ() + location.getYaw() + location.getPitch();
    }

    public static @NonNull String compressUUID(UUID id) {
        return id == null ? "" : Long.toString(id.getLeastSignificantBits()) + id.getMostSignificantBits();
    }

    public static @NonNull String compressBoolean(boolean bool) {
        return bool ? "1" : "";
    }

    public static @NonNull String compressString(String string) {
        return string == null ? "" : string.length() + string;
    }

    public static @NonNull String compressColor(Color color) {
        return color == null ? "" : Integer.toString(color.getRGB());
    }

    public static CharSequence compressInventory(Inventory inventory) {
        StringBuilder builder = new StringBuilder(inventory.getSize() * 100);
        builder.append(inventory.getSize());
        for (ItemStack item : inventory.getContents()) {
            if (item == null) continue;
            builder.append(item.getType()).append(item.getAmount());
            if (!item.hasItemMeta()) continue;
            builder.append(item.getItemMeta());
        }
        return builder;
    }

    public void setMetadata(Map<KingdomMetadataHandler, KingdomMetadata> metadata) {
        this.metadata = NonNullMap.of(Objects.requireNonNull(metadata, "Metadata cannot be null"));
    }

    public static <T> @NonNull String compressCollecton(Collection<T> collection, Function<T, Object> function) {
        return KingdomsObject.compressCollecton(collection, 0, function);
    }

    public static <T> @NonNull String compressCollecton(Collection<T> collection, int mod, Function<T, Object> function) {
        Objects.requireNonNull(collection, "Cannot compress null collection");
        Objects.requireNonNull(function, "Compress function cannot be null");
        int size = collection.size();
        if (size == 0) {
            return "";
        }
        if (mod == 0) {
            mod = size;
        }
        StringBuilder builder = new StringBuilder(size * mod);
        builder.append(collection.size());
        for (T element : collection) {
            Object result = function.apply(element);
            builder.append(result);
        }
        return builder.toString();
    }

    public static <K, V> @NonNull String compressMap(Map<K, V> map, int mod, Function<K, Object> keyCompressor, Function<V, Object> valueCompressor) {
        int size = map.size();
        if (size == 0) {
            return "";
        }
        if (mod == 0) {
            mod = size;
        }
        StringBuilder builder = new StringBuilder(size * mod);
        builder.append(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            builder.append(keyCompressor.apply(entry.getKey()));
            V val = entry.getValue();
            Object translated = valueCompressor.apply(val);
            builder.append(translated);
        }
        return builder.toString();
    }

    public final @NonNull String compressMetadata() {
        return KingdomsObject.compressMap(this.metadata, 0, s -> s, Object::hashCode);
    }

    public abstract @NonNull K getDataKey();

    public @Nullable String getSaveMeta() {
        return this.saveMeta;
    }

    public final void setSaveMeta() {
        this.saveMeta = this.getCompressedData();
    }

    public boolean shouldSave() {
        String compressedData = this.getCompressedData();
        if (!compressedData.equals(this.saveMeta)) {
            this.saveMeta = compressedData;
            return true;
        }
        return false;
    }

    public abstract @NonNull String getCompressedData();

    public @NonNull Map<KingdomMetadataHandler, KingdomMetadata> getMetadata() {
        return this.metadata;
    }
}

