/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.namespace;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.NamespaceContainer;
import org.kingdoms.utils.internal.nonnull.NonNullMap;

public abstract class NamespaceRegistry<V extends NamespaceContainer> {
    protected final Map<Namespace, V> registry = new NonNullMap<Namespace, V>();

    public void register(V value) {
        Namespace namespace = value.getNamespace();
        Objects.requireNonNull(namespace, "Cannot register object with null namespace");
        Objects.requireNonNull(value, "Cannot register null object");
        NamespaceContainer prev = (NamespaceContainer)this.registry.putIfAbsent(namespace, value);
        if (prev != null) {
            throw new IllegalArgumentException(namespace + " was already registered");
        }
    }

    public V getRegistered(Namespace namespace) {
        return (V)((NamespaceContainer)this.registry.get(namespace));
    }

    public boolean isRegisetered(Namespace namespace) {
        return this.registry.containsKey(namespace);
    }

    public Map<Namespace, V> getRegistry() {
        return Collections.unmodifiableMap(this.registry);
    }
}

