/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.flatfile.yaml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.nio.file.Path;
import org.kingdoms.constants.metadata.KingdomsObject;
import org.kingdoms.data.database.flatfile.FlatFileDatabase;
import org.kingdoms.data.database.flatfile.yaml.NamedYamlDataProvider;
import org.kingdoms.data.handlers.DataHandler;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.snakeyaml.api.Dump;
import org.kingdoms.libs.snakeyaml.api.DumpSettings;
import org.kingdoms.libs.snakeyaml.api.Load;
import org.kingdoms.libs.snakeyaml.api.LoadSettings;
import org.kingdoms.libs.snakeyaml.api.SimpleWriter;
import org.kingdoms.libs.snakeyaml.composer.Composer;
import org.kingdoms.libs.snakeyaml.nodes.MappingNode;
import org.kingdoms.utils.config.ConfigSection;

public final class YamlDatabase<K, T extends KingdomsObject<K>>
extends FlatFileDatabase<K, T> {
    private static final Dump DUMPER = new Dump(new DumpSettings());

    public YamlDatabase(@NotNull Path folder, @NotNull DataHandler<K, T> dataHandler) {
        super("yml", folder, dataHandler);
    }

    @Override
    @Nullable
    public T load(@NotNull K key, @NotNull BufferedReader reader) {
        String stringKey = this.getDataHandler().getIdHandler().toString(key);
        LoadSettings settings = new LoadSettings();
        settings.setLabel(stringKey);
        Load load2 = new Load(settings);
        Composer composer = load2.createComposer(reader);
        MappingNode root = composer.getRoot();
        load2.construct(root);
        NamedYamlDataProvider provider = new NamedYamlDataProvider(null, new ConfigSection(root));
        return (T)((KingdomsObject)this.getDataHandler().load(provider, key));
    }

    @Override
    public void save(@NotNull T data, @NotNull BufferedWriter writer) {
        MappingNode root = new MappingNode();
        NamedYamlDataProvider provider = new NamedYamlDataProvider(null, new ConfigSection(root));
        this.getDataHandler().save(provider, data);
        DUMPER.dumpNode(root, new SimpleWriter(writer));
    }
}

