/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.kingdoms.data.database.sql.DatabaseProperties;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.dependencies.Dependency;
import org.kingdoms.libs.hikari.HikariConfig;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.text.Regex;
import org.kingdoms.libs.kotlin.text.StringsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0086\u0001\u0018\u0000 '2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001'B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH&J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\bH&J \u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\bH&R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&\u00a8\u0006("}, d2={"Lorg/kingdoms/data/database/sql/DatabaseType;", "", "defaultPort", "", "dependencies", "", "Lorg/kingdoms/dependencies/Dependency;", "dataSourceClassName", "", "systemIdentifierEscapeChar", "", "(Ljava/lang/String;II[Lorg/kingdoms/dependencies/Dependency;Ljava/lang/String;C)V", "getDataSourceClassName", "()Ljava/lang/String;", "getDefaultPort", "()I", "getDependencies", "()[Lorg/kingdoms/dependencies/Dependency;", "[Lorg/kingdoms/dependencies/Dependency;", "getSystemIdentifierEscapeChar", "()C", "applyProperties", "", "hikariConfig", "Lorg/kingdoms/libs/hikari/HikariConfig;", "databaseProperties", "Lorg/kingdoms/data/database/sql/DatabaseProperties;", "processCommands", "line", "upsertStatement", "table", "parameters", "preparedValues", "SQLite", "H2", "MariaDB", "MySQL", "PostgreSQL", "MongoDB", "Companion", "core"})
public abstract class DatabaseType
extends Enum<DatabaseType> {
    @NotNull
    public static final Companion Companion;
    private final int defaultPort;
    @NotNull
    private final Dependency[] dependencies;
    @NotNull
    private final String dataSourceClassName;
    private final char systemIdentifierEscapeChar;
    @NotNull
    private static final Regex SQLITE_TEXT_AFFINITY;
    @NotNull
    private static final Regex SQLITE_BLOB_AFFINITY;
    public static final /* enum */ DatabaseType SQLite;
    public static final /* enum */ DatabaseType H2;
    public static final /* enum */ DatabaseType MariaDB;
    public static final /* enum */ DatabaseType MySQL;
    public static final /* enum */ DatabaseType PostgreSQL;
    public static final /* enum */ DatabaseType MongoDB;
    private static final /* synthetic */ DatabaseType[] $VALUES;

    private DatabaseType(int defaultPort, Dependency[] dependencies, String dataSourceClassName, char systemIdentifierEscapeChar) {
        this.defaultPort = defaultPort;
        this.dependencies = dependencies;
        this.dataSourceClassName = dataSourceClassName;
        this.systemIdentifierEscapeChar = systemIdentifierEscapeChar;
    }

    /* synthetic */ DatabaseType(String string, int n, int n2, Dependency[] dependencyArray, String string2, char c, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            c = (char)96;
        }
        this(n2, dependencyArray, string2, c);
    }

    public final int getDefaultPort() {
        return this.defaultPort;
    }

    @NotNull
    public final Dependency[] getDependencies() {
        return this.dependencies;
    }

    @NotNull
    public final String getDataSourceClassName() {
        return this.dataSourceClassName;
    }

    public final char getSystemIdentifierEscapeChar() {
        return this.systemIdentifierEscapeChar;
    }

    public abstract void applyProperties(@NotNull HikariConfig var1, @NotNull DatabaseProperties var2);

    @NotNull
    public abstract String processCommands(@NotNull String var1);

    @NotNull
    public abstract String upsertStatement(@NotNull String var1, @NotNull String var2, @NotNull String var3);

    public static DatabaseType[] values() {
        return (DatabaseType[])$VALUES.clone();
    }

    public static DatabaseType valueOf(String value) {
        return Enum.valueOf(DatabaseType.class, value);
    }

    public /* synthetic */ DatabaseType(String $enum$name, int $enum$ordinal, int defaultPort, Dependency[] dependencies, String dataSourceClassName, char systemIdentifierEscapeChar, DefaultConstructorMarker $constructor_marker) {
        this(defaultPort, dependencies, dataSourceClassName, systemIdentifierEscapeChar);
    }

    static {
        SQLite = new SQLite("SQLite", 0);
        H2 = new H2("H2", 1);
        MariaDB = new MariaDB("MariaDB", 2);
        MySQL = new MySQL("MySQL", 3);
        PostgreSQL = new PostgreSQL("PostgreSQL", 4);
        MongoDB = new MongoDB("MongoDB", 5);
        $VALUES = databaseTypeArray = new DatabaseType[]{DatabaseType.SQLite, DatabaseType.H2, DatabaseType.MariaDB, DatabaseType.MySQL, DatabaseType.PostgreSQL, DatabaseType.MongoDB};
        Companion = new Companion(null);
        Pattern pattern = Pattern.compile("(N)?(VAR)?CHAR\\(\\d+\\)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"(N)?(VAR)?CHAR\\\\(\\\\d+\\\\)\")");
        Pattern pattern2 = pattern;
        SQLITE_TEXT_AFFINITY = new Regex(pattern2);
        Pattern pattern3 = Pattern.compile("BINARY\\(\\d+\\)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern3, (String)"compile(\"BINARY\\\\(\\\\d+\\\\)\")");
        pattern2 = pattern3;
        SQLITE_BLOB_AFFINITY = new Regex(pattern2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/kingdoms/data/database/sql/DatabaseType$Companion;", "", "()V", "SQLITE_BLOB_AFFINITY", "Lorg/kingdoms/libs/kotlin/text/Regex;", "SQLITE_TEXT_AFFINITY", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J \u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/data/database/sql/DatabaseType$SQLite;", "Lorg/kingdoms/data/database/sql/DatabaseType;", "applyProperties", "", "hikariConfig", "Lorg/kingdoms/libs/hikari/HikariConfig;", "databaseProperties", "Lorg/kingdoms/data/database/sql/DatabaseProperties;", "processCommands", "", "line", "upsertStatement", "table", "parameters", "preparedValues", "core"})
    static final class SQLite
    extends DatabaseType {
        /*
         * WARNING - void declaration
         */
        SQLite() {
            void var1_1;
            Dependency[] dependencyArray = new Dependency[]{Dependency.SQLITE_DRIVER};
        }

        @Override
        public void applyProperties(@NotNull HikariConfig hikariConfig, @NotNull DatabaseProperties databaseProperties) {
            Intrinsics.checkNotNullParameter((Object)hikariConfig, (String)"hikariConfig");
            Intrinsics.checkNotNullParameter((Object)databaseProperties, (String)"databaseProperties");
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String upsertStatement(@NotNull String table, @NotNull String parameters, @NotNull String preparedValues) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)preparedValues, (String)"preparedValues");
            return "INSERT OR REPLACE INTO `" + table + "` (" + parameters + ") VALUES(" + preparedValues + ')';
        }

        @Override
        @NotNull
        public String processCommands(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            CharSequence charSequence = StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)line, (String)"LONG", (String)"INT", (boolean)false), (String)"UUID", (String)"BLOB", (boolean)false), (String)"FLOAT", (String)"REAL", (boolean)false), (String)"DOUBLE", (String)"REAL", (boolean)false), (String)"BIGINT", (String)"INT", (boolean)false), (String)"BOOL", (String)"INT", (boolean)false), (String)"JSON", (String)"TEXT", (boolean)false);
            Regex regex = SQLITE_BLOB_AFFINITY;
            String string = "BLOB";
            charSequence = regex.replace(charSequence, string);
            regex = SQLITE_TEXT_AFFINITY;
            string = "TEXT";
            return regex.replace(charSequence, string);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J \u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/data/database/sql/DatabaseType$H2;", "Lorg/kingdoms/data/database/sql/DatabaseType;", "applyProperties", "", "hikariConfig", "Lorg/kingdoms/libs/hikari/HikariConfig;", "databaseProperties", "Lorg/kingdoms/data/database/sql/DatabaseProperties;", "processCommands", "", "line", "upsertStatement", "table", "parameters", "preparedValues", "core"})
    static final class H2
    extends DatabaseType {
        /*
         * WARNING - void declaration
         */
        H2() {
            void var1_1;
            Dependency[] dependencyArray = new Dependency[]{Dependency.H2_DRIVER};
        }

        @Override
        public void applyProperties(@NotNull HikariConfig hikariConfig, @NotNull DatabaseProperties databaseProperties) {
            Intrinsics.checkNotNullParameter((Object)hikariConfig, (String)"hikariConfig");
            Intrinsics.checkNotNullParameter((Object)databaseProperties, (String)"databaseProperties");
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String upsertStatement(@NotNull String table, @NotNull String parameters, @NotNull String preparedValues) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)preparedValues, (String)"preparedValues");
            return "MERGE INTO `" + table + "` (" + parameters + ") VALUES(" + preparedValues + ')';
        }

        @Override
        @NotNull
        public String processCommands(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            return StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)line, (String)"LONG", (String)"BIGINT", (boolean)false), (String)"FLOAT", (String)"REAL", (boolean)false), (String)"DOUBLE", (String)"DOUBLE PRECISION", (boolean)false), (String)"NVARCHAR", (String)"VARCHAR", (boolean)false), (String)"STRICT", (String)"", (boolean)false);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J \u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/data/database/sql/DatabaseType$MariaDB;", "Lorg/kingdoms/data/database/sql/DatabaseType;", "applyProperties", "", "hikariConfig", "Lorg/kingdoms/libs/hikari/HikariConfig;", "databaseProperties", "Lorg/kingdoms/data/database/sql/DatabaseProperties;", "processCommands", "", "line", "upsertStatement", "table", "parameters", "preparedValues", "core"})
    static final class MariaDB
    extends DatabaseType {
        /*
         * WARNING - void declaration
         */
        MariaDB() {
            void var1_1;
            Dependency[] dependencyArray = new Dependency[]{Dependency.MARIADB_DRIVER};
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void applyProperties(@NotNull HikariConfig hikariConfig, @NotNull DatabaseProperties databaseProperties) {
            String string;
            DatabaseProperties databaseProperties2;
            Intrinsics.checkNotNullParameter((Object)hikariConfig, (String)"hikariConfig");
            Intrinsics.checkNotNullParameter((Object)databaseProperties, (String)"databaseProperties");
            DatabaseProperties $this$applyProperties_u24lambda_u2d1 = databaseProperties2 = databaseProperties;
            boolean bl = false;
            if ($this$applyProperties_u24lambda_u2d1.getOthers().isEmpty()) {
                void $this$mapTo$iv$iv;
                char c = '?';
                Map<String, Object> $this$map$iv = $this$applyProperties_u24lambda_u2d1.getOthers();
                boolean $i$f$map = false;
                Map<String, Object> map = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    void e;
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add((String)e.getKey() + '=' + e.getValue());
                }
                String string2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
                string = c + string2;
            } else {
                string = "";
            }
            String propertiesString = string;
            hikariConfig.addDataSourceProperty("url", (Object)("jdbc:mariadb://" + $this$applyProperties_u24lambda_u2d1.getAddress() + ':' + $this$applyProperties_u24lambda_u2d1.getPort() + '/' + $this$applyProperties_u24lambda_u2d1.getDatabaseName() + propertiesString));
            hikariConfig.addDataSourceProperty("user", (Object)$this$applyProperties_u24lambda_u2d1.getUser());
            hikariConfig.addDataSourceProperty("password", (Object)$this$applyProperties_u24lambda_u2d1.getPassword());
        }

        @Override
        @NotNull
        public String upsertStatement(@NotNull String table, @NotNull String parameters, @NotNull String preparedValues) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)preparedValues, (String)"preparedValues");
            return "REPLACE INTO " + table + " (" + parameters + ") VALUES(" + preparedValues + ')';
        }

        @Override
        @NotNull
        public String processCommands(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            return StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)line, (String)"UUID", (String)"BINARY(16)", (boolean)false), (String)"LONG", (String)"BIGINT", (boolean)false), (String)"STRICT", (String)"", (boolean)false);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J \u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/data/database/sql/DatabaseType$MySQL;", "Lorg/kingdoms/data/database/sql/DatabaseType;", "applyProperties", "", "hikariConfig", "Lorg/kingdoms/libs/hikari/HikariConfig;", "databaseProperties", "Lorg/kingdoms/data/database/sql/DatabaseProperties;", "processCommands", "", "line", "upsertStatement", "table", "parameters", "preparedValues", "core"})
    static final class MySQL
    extends DatabaseType {
        /*
         * WARNING - void declaration
         */
        MySQL() {
            void var1_1;
            Dependency[] dependencyArray = new Dependency[]{Dependency.MYSQL_DRIVER};
        }

        @Override
        public void applyProperties(@NotNull HikariConfig hikariConfig, @NotNull DatabaseProperties databaseProperties) {
            DatabaseProperties databaseProperties2;
            Intrinsics.checkNotNullParameter((Object)hikariConfig, (String)"hikariConfig");
            Intrinsics.checkNotNullParameter((Object)databaseProperties, (String)"databaseProperties");
            DatabaseProperties $this$applyProperties_u24lambda_u2d0 = databaseProperties2 = databaseProperties;
            boolean bl = false;
            $this$applyProperties_u24lambda_u2d0.add("cachePrepStmts", true);
            $this$applyProperties_u24lambda_u2d0.add("prepStmtCacheSize", 250);
            $this$applyProperties_u24lambda_u2d0.add("prepStmtCacheSqlLimit", 2048);
            $this$applyProperties_u24lambda_u2d0.add("useServerPrepStmts", true);
            $this$applyProperties_u24lambda_u2d0.add("useLocalSessionState", true);
            $this$applyProperties_u24lambda_u2d0.add("rewriteBatchedStatements", true);
            $this$applyProperties_u24lambda_u2d0.add("cacheResultSetMetadata", true);
            $this$applyProperties_u24lambda_u2d0.add("cacheServerConfiguration", true);
            $this$applyProperties_u24lambda_u2d0.add("elideSetAutoCommits", true);
            $this$applyProperties_u24lambda_u2d0.add("maintainTimeStats", false);
            String[] stringArray = new String[]{"useUnicode", "characterEncoding"};
            $this$applyProperties_u24lambda_u2d0.ignore(stringArray);
            databaseProperties.useStandardDataSourcePropertyAppendar(hikariConfig);
        }

        @Override
        @NotNull
        public String processCommands(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            return StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)line, (String)"UUID", (String)"BINARY(16)", (boolean)false), (String)"LONG", (String)"BIGINT", (boolean)false), (String)"STRICT", (String)"", (boolean)false);
        }

        @Override
        @NotNull
        public String upsertStatement(@NotNull String table, @NotNull String parameters, @NotNull String preparedValues) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)preparedValues, (String)"preparedValues");
            return "REPLACE INTO `" + table + "` (" + parameters + ") VALUES(" + preparedValues + ')';
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J \u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/data/database/sql/DatabaseType$PostgreSQL;", "Lorg/kingdoms/data/database/sql/DatabaseType;", "applyProperties", "", "hikariConfig", "Lorg/kingdoms/libs/hikari/HikariConfig;", "databaseProperties", "Lorg/kingdoms/data/database/sql/DatabaseProperties;", "processCommands", "", "line", "upsertStatement", "table", "parameters", "preparedValues", "core"})
    static final class PostgreSQL
    extends DatabaseType {
        /*
         * WARNING - void declaration
         */
        PostgreSQL() {
            void var1_1;
            Dependency[] dependencyArray = new Dependency[]{Dependency.POSTGRESQL_DRIVER};
        }

        @Override
        public void applyProperties(@NotNull HikariConfig hikariConfig, @NotNull DatabaseProperties databaseProperties) {
            Intrinsics.checkNotNullParameter((Object)hikariConfig, (String)"hikariConfig");
            Intrinsics.checkNotNullParameter((Object)databaseProperties, (String)"databaseProperties");
            String[] stringArray = new String[]{"verifyServerCertificate", "allowPublicKeyRetrieval", "useSSL", "useUnicode", "characterEncoding", "port"};
            databaseProperties.ignore(stringArray);
            databaseProperties.useStandardDataSourcePropertyAppendar(hikariConfig);
        }

        @Override
        @NotNull
        public String processCommands(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            return StringsKt.replace$default((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)StringsKt.replace((String)line, (String)"NVARCHAR", (String)"VARCHAR", (boolean)false), (String)"LONG", (String)"BIGINT", (boolean)false), (String)"DOUBLE", (String)"DOUBLE PRECISION", (boolean)false), (String)"STRICT", (String)"", (boolean)false), (char)'`', (char)'\"', (boolean)false, (int)4, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String upsertStatement(@NotNull String table, @NotNull String parameters, @NotNull String preparedValues) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)preparedValues, (String)"preparedValues");
            String columnNames = StringsKt.replace$default((String)parameters, (char)'`', (char)this.getSystemIdentifierEscapeChar(), (boolean)false, (int)4, null);
            Object object = new String[]{","};
            object = StringsKt.split$default((CharSequence)columnNames, (String[])object, (boolean)false, (int)0, (int)6, null);
            StringBuilder stringBuilder = new StringBuilder().append("INSERT INTO \"").append(table).append("\" (").append(columnNames).append(") VALUES(").append(preparedValues).append(") ON CONFLICT ON CONSTRAINT \"").append(table).append("_pkey\" DO UPDATE SET (").append(columnNames).append(") = (");
            boolean $i$f$map = false;
            void var7_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void x;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)x))).toString());
            }
            return stringBuilder.append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, (Function1)upsertStatement.2.INSTANCE, (int)30, null)).append(')').toString();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J \u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/data/database/sql/DatabaseType$MongoDB;", "Lorg/kingdoms/data/database/sql/DatabaseType;", "applyProperties", "", "hikariConfig", "Lorg/kingdoms/libs/hikari/HikariConfig;", "databaseProperties", "Lorg/kingdoms/data/database/sql/DatabaseProperties;", "processCommands", "", "line", "upsertStatement", "table", "parameters", "preparedValues", "core"})
    static final class MongoDB
    extends DatabaseType {
        /*
         * WARNING - void declaration
         */
        MongoDB() {
            void var1_1;
            Dependency[] dependencyArray = new Dependency[]{Dependency.SLF4J_SIMPLE, Dependency.MONGODB_DRIVER_SYNC, Dependency.MONGODB_DRIVER_BSON, Dependency.MONGODB_DRIVER_CORE};
        }

        @NotNull
        public Void applyProperties(@NotNull HikariConfig hikariConfig, @NotNull DatabaseProperties databaseProperties) {
            Intrinsics.checkNotNullParameter((Object)hikariConfig, (String)"hikariConfig");
            Intrinsics.checkNotNullParameter((Object)databaseProperties, (String)"databaseProperties");
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String processCommands(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String upsertStatement(@NotNull String table, @NotNull String parameters, @NotNull String preparedValues) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)preparedValues, (String)"preparedValues");
            throw new UnsupportedOperationException();
        }
    }
}

