/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.handlers;

import java.awt.Color;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.kingdoms.abstraction.ImmutableLocation;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.KingdomRelationshipRequest;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.player.RankMap;
import org.kingdoms.data.database.dataprovider.IdDataTypeHandler;
import org.kingdoms.data.database.dataprovider.SQLDataHandlerProperties;
import org.kingdoms.data.database.dataprovider.SectionCreatableDataSetter;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.data.database.dataprovider.StdIdDataType;
import org.kingdoms.data.handlers.DataHandler;
import org.kingdoms.data.handlers.DataHandlerGroup;
import org.kingdoms.data.handlers.DataHandlerMetadata;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.utils.internal.arrays.ArrayUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/data/handlers/DataHandlerNation;", "Lorg/kingdoms/data/handlers/DataHandler;", "Ljava/util/UUID;", "Lorg/kingdoms/constants/group/Nation;", "()V", "load", "json", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "id", "save", "", "provider", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "data", "core"})
public final class DataHandlerNation
extends DataHandler<UUID, Nation> {
    public DataHandlerNation() {
        IdDataTypeHandler idDataTypeHandler = StdIdDataType.UUID;
        Object[] objectArray = new Object[]{"color", "flag", "kingdoms", "capital", SQLDataHandlerProperties.Companion.ofLocation("home"), SQLDataHandlerProperties.Companion.ofSimpleLocation("nexus")};
        String[] stringArray = ArrayUtils.mergeObjects(objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"mergeObjects(\n          \u2026cation(\"nexus\")\n        )");
        super(idDataTypeHandler, new SQLDataHandlerProperties(stringArray));
    }

    @Override
    public void save(@NotNull SectionableDataSetter provider, @NotNull Nation data) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        provider.setUUID("capital", data.getCapitalId());
        SectionableDataSetter sectionableDataSetter = provider.get("kingdoms");
        Set<UUID> set = data.getMembers();
        Intrinsics.checkNotNullExpressionValue(set, (String)"data.members");
        sectionableDataSetter.setCollection((Collection)set, DataHandlerNation::save$lambda-0);
        DataHandlerGroup.save(provider, data);
    }

    @Override
    @NotNull
    public Nation load(@NotNull SectionableDataGetter json, @NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        UUID capital = json.get("capital").asUUID();
        HashSet kingdoms = json.get("kingdoms").asCollection((Collection)new HashSet(), DataHandlerNation::load$lambda-1);
        DataHandlerGroup.DataHolder $this$load_u24lambda_u2d2 = DataHandlerGroup.load(json);
        boolean bl = false;
        Map<UUID, KingdomRelationshipRequest> map = $this$load_u24lambda_u2d2.getRelationshipRequests();
        RankMap rankMap = $this$load_u24lambda_u2d2.getRanks();
        Map<UUID, KingdomRelation> map2 = $this$load_u24lambda_u2d2.getRelations();
        Set set = kingdoms;
        String string = $this$load_u24lambda_u2d2.getName();
        String string2 = $this$load_u24lambda_u2d2.getTax();
        SimpleLocation simpleLocation = $this$load_u24lambda_u2d2.getNexus();
        Location location = ImmutableLocation.Companion.of($this$load_u24lambda_u2d2.getHome());
        String string3 = $this$load_u24lambda_u2d2.getFlag();
        Color color = $this$load_u24lambda_u2d2.getColor();
        long l = $this$load_u24lambda_u2d2.getResourcePoints();
        double d = $this$load_u24lambda_u2d2.getBank();
        long l2 = $this$load_u24lambda_u2d2.getSince();
        boolean bl2 = $this$load_u24lambda_u2d2.getPermanent();
        boolean bl3 = $this$load_u24lambda_u2d2.getRequiresInvite();
        long l3 = $this$load_u24lambda_u2d2.getShieldTime();
        long l4 = $this$load_u24lambda_u2d2.getShieldSince();
        Map<KingdomRelation, Set<RelationAttribute>> map3 = $this$load_u24lambda_u2d2.getAttributes();
        Intrinsics.checkNotNull(map3);
        Nation nation = new Nation(id, map, rankMap, map2, set, capital, string, string2, simpleLocation, location, string3, color, l, d, l2, bl2, bl3, l3, l4, map3);
        DataHandlerMetadata.deserializeMetadata(json, nation);
        return nation;
    }

    private static final void save$lambda-0(SectionCreatableDataSetter elementProvider, UUID element) {
        Intrinsics.checkNotNullParameter((Object)elementProvider, (String)"elementProvider");
        elementProvider.setUUID(element);
    }

    private static final void load$lambda-1(HashSet set, SectionableDataGetter element) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        UUID uUID = element.asUUID();
        Intrinsics.checkNotNull((Object)uUID);
        set.add(uUID);
    }
}

