/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.managers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.data.DataManager;
import org.kingdoms.data.KingdomsDataCenter;
import org.kingdoms.data.StartupCache;
import org.kingdoms.data.handlers.DataHandlerKingdom;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.Validate;
import org.kingdoms.utils.internal.IndexedHashMap;
import org.kingdoms.utils.string.QuantumString;
import org.kingdoms.utils.time.TimeUtils;

public final class KingdomManager
extends DataManager<UUID, Kingdom> {
    private static final Map<QuantumString, UUID> NAMES = new HashMap<QuantumString, UUID>();
    private static final IndexedHashMap<UUID, Integer> TOP = new IndexedHashMap(new UUID[0]);

    public void updateTop() {
        Collection<Kingdom> kingdoms = this.getKingdoms();
        KLogger.info("Updating top kingdoms... " + kingdoms.size());
        UUID[] array = (UUID[])kingdoms.stream().sorted(Kingdom.getTopComparator().reversed()).map(Group::getId).toArray(UUID[]::new);
        TOP.set((UUID[])array, x -> x);
    }

    public KingdomManager(KingdomsDataCenter dataCenter) {
        super("kingdoms", dataCenter.constructDatabase(KingdomsConfig.DATABASE_TABLES_KINGDOMS.getString(), "kingdoms", new DataHandlerKingdom()));
        this.autoSave(Kingdoms.get());
        StartupCache.whenLoaded(_x -> {
            long updateInterval = TimeUtils.millisToTicks(KingdomsConfig.TOP_KINGDOMS_UPDATE_INTERVAL.getTimeMillis(TimeUnit.MINUTES));
            Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Kingdoms.get(), this::updateTop, 0L, updateInterval);
        });
    }

    public static Map<QuantumString, UUID> getNames() {
        return Collections.unmodifiableMap(NAMES);
    }

    public static QuantumString toQuantumName(String name) {
        return new QuantumString(name, !KingdomsConfig.KINGDOM_NAME_CASE_SENSITIVE.getBoolean());
    }

    public Collection<Kingdom> getKingdoms() {
        return this.peekAllData();
    }

    public int getTopPosition(Kingdom kingdom) {
        return TOP.get(kingdom.getId(), TOP.size()) + 1;
    }

    public Kingdom getKingdomAtPosition(int i) {
        Validate.isTrue(i > 0, "Kingdom top positions start at 1");
        UUID id = TOP.at(--i);
        if (id == null) {
            return null;
        }
        return Kingdom.getKingdom(id);
    }

    public Kingdom[] getTopKingdoms() {
        return (Kingdom[])Arrays.stream(TOP.asArray()).map(Kingdom::getKingdom).toArray(Kingdom[]::new);
    }

    public List<Kingdom> getTopKingdoms(int skip, int limit) {
        return this.getTopKingdoms(skip, limit, null);
    }

    public List<Kingdom> getTopKingdoms(int skip, int limit, Predicate<Kingdom> predicate) {
        return TOP.subList(skip, limit, id -> {
            Kingdom kingdom = Kingdom.getKingdom(id);
            if (kingdom == null) {
                return null;
            }
            return predicate == null || predicate.test(kingdom) ? kingdom : null;
        });
    }

    @Override
    public Kingdom getData(String name) {
        UUID id = NAMES.get(KingdomManager.toQuantumName(name));
        return id == null ? null : (Kingdom)this.getData(id);
    }

    @Override
    public void unload(@NonNull UUID key) {
        this.remove((Kingdom)this.cache.get(key));
        super.unload(key);
    }

    public void renameKingdom(Kingdom kingdom, String rename) {
        this.remove(kingdom);
        NAMES.put(KingdomManager.toQuantumName(rename), kingdom.getId());
    }

    public void remove(Kingdom kingdom) {
        NAMES.remove(KingdomManager.toQuantumName(kingdom.getName()));
    }

    @Override
    protected void onLoad(Kingdom value) {
        NAMES.put(KingdomManager.toQuantumName(value.getName()), value.getId());
    }
}

