/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.events.items;

import java.util.Objects;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.kingdoms.abstraction.KingdomItemOperator;
import org.kingdoms.abstraction.PlayerOperator;
import org.kingdoms.constants.land.abstraction.KingdomItem;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.KingdomsEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;

public abstract class KingdomItemEmbeddedEvent<I extends KingdomItem<?>>
extends KingdomsEvent
implements Cancellable,
PlayerOperator,
KingdomItemOperator {
    private final KingdomPlayer player;
    private final @NonNull I kingdomItem;
    private final Event event;
    private boolean cancelled;

    public KingdomItemEmbeddedEvent(Event event, KingdomPlayer player, I kingdomItem) {
        this.event = event;
        this.player = player;
        this.kingdomItem = (KingdomItem)Objects.requireNonNull(kingdomItem, "Kingdom item cannot be null");
    }

    @Override
    public KingdomPlayer getPlayer() {
        return this.player;
    }

    public @NonNull I getKingdomItem() {
        return this.kingdomItem;
    }

    public Event getBukkitEvent() {
        return this.event;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
        if (this.event instanceof Cancellable) {
            ((Cancellable)this.event).setCancelled(cancel);
        }
    }
}

