/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.events.lands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.bukkit.event.Cancellable;
import org.kingdoms.abstraction.KingdomOperator;
import org.kingdoms.abstraction.PlayerOperator;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.KingdomsEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;

public abstract class ClaimingEvent
extends KingdomsEvent
implements Cancellable,
KingdomOperator,
PlayerOperator {
    private final KingdomPlayer player;
    private @Nullable Set<SimpleChunkLocation> lands;
    private final List<Land> cachedLands;
    private final @NonNull Kingdom kingdom;
    private boolean cancelled;
    private final boolean claiming;

    public ClaimingEvent(@Nullable KingdomPlayer player, @NonNull Kingdom kingdom, @NonNull Set<SimpleChunkLocation> lands, boolean claiming) {
        this.kingdom = Objects.requireNonNull(kingdom);
        this.player = player;
        this.lands = Objects.requireNonNull(lands);
        this.claiming = claiming;
        this.cachedLands = new ArrayList<Land>(lands.size());
        this.cacheLands();
    }

    public @NonNull Set<SimpleChunkLocation> getLandLocations() {
        return Collections.unmodifiableSet(this.lands);
    }

    private void cacheLands() {
        this.cachedLands.clear();
        for (SimpleChunkLocation chunk : this.lands) {
            if (chunk == null) {
                throw new IllegalArgumentException("Land locations cannot contain a null land");
            }
            Land land = chunk.getLand();
            if (this.claiming) {
                if (land == null) continue;
                if (land.isClaimed()) {
                    throw new IllegalArgumentException("Land '" + chunk + "' is already claimed by another kingdom: " + land.getKingdomId());
                }
                this.cachedLands.add(land);
                continue;
            }
            if (land != null && land.isClaimed()) continue;
            throw new IllegalArgumentException("Land '" + chunk + "' isn't claimed by any kingdoms");
        }
    }

    public @NonNull Collection<Land> getLands() {
        return Collections.unmodifiableList(this.cachedLands);
    }

    public void setLands(@NonNull Set<SimpleChunkLocation> lands) {
        this.lands = Objects.requireNonNull(lands);
        this.cacheLands();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public @NonNull Kingdom getKingdom() {
        return this.kingdom;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    @org.kingdoms.libs.jetbrains.annotations.Nullable
    public KingdomPlayer getPlayer() {
        return this.player;
    }
}

