/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.events.lands;

import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.KingdomsEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;

public class LandChangeEvent
extends KingdomsEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final PlayerMoveEvent moveEvent;
    private final KingdomPlayer kingdomPlayer;
    private final SimpleChunkLocation fromChunk;
    private final SimpleChunkLocation toChunk;
    private final Land fromLand;
    private final Land toLand;
    private final PlayerTeleportEvent.TeleportCause cause;

    public LandChangeEvent(PlayerMoveEvent moveEvent, SimpleChunkLocation fromChunk, SimpleChunkLocation toChunk, PlayerTeleportEvent.TeleportCause cause) {
        this.moveEvent = moveEvent;
        this.kingdomPlayer = KingdomPlayer.getKingdomPlayer((OfflinePlayer)moveEvent.getPlayer());
        this.fromChunk = fromChunk;
        this.toChunk = toChunk;
        this.fromLand = fromChunk.getLand();
        this.toLand = toChunk.getLand();
        this.cause = cause;
    }

    public static @NonNull HandlerList getHandlerList() {
        return handlers;
    }

    public @NonNull HandlerList getHandlers() {
        return handlers;
    }

    public Land getFromLand() {
        return this.fromLand;
    }

    public Land getToLand() {
        return this.toLand;
    }

    public Player getPlayer() {
        return this.moveEvent.getPlayer();
    }

    public Location getFrom() {
        return this.moveEvent.getFrom();
    }

    public void setFrom(Location location) {
        this.moveEvent.setFrom(location);
    }

    public Location getTo() {
        return this.moveEvent.getTo();
    }

    public void setTo(Location location) {
        this.moveEvent.setTo(location);
    }

    public KingdomPlayer getKingdomPlayer() {
        return this.kingdomPlayer;
    }

    public boolean isCancelled() {
        return this.moveEvent.isCancelled();
    }

    public void setCancelled(boolean cancelled) {
        this.moveEvent.setCancelled(cancelled);
    }

    public SimpleChunkLocation getFromChunk() {
        return this.fromChunk;
    }

    public SimpleChunkLocation getToChunk() {
        return this.toChunk;
    }

    public PlayerTeleportEvent.TeleportCause getCause() {
        return this.cause;
    }
}

