/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.gui;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.OptionHandler;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.ranges.RangesKt;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.internal.Fn;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0012B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u000e\u001a\u0012\u0012\u000e\u0012\f0\rR\b\u0012\u0004\u0012\u00028\u00000\u00000\u000fJ0\u0010\u000e\u001a\u000e\u0018\u00010\rR\b\u0012\u0004\u0012\u00028\u00000\u0000\"\u0004\b\u0001\u0010\u00012\u0006\u0010\u0010\u001a\u00020\f2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\f\u0012\u000e\u0012\f0\rR\b\u0012\u0004\u0012\u00028\u00000\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/kingdoms/gui/GUIMultiPagination;", "T", "", "gui", "Lorg/kingdoms/gui/InteractiveGUI;", "page", "", "openPage", "Ljava/util/function/Consumer;", "(Lorg/kingdoms/gui/InteractiveGUI;ILjava/util/function/Consumer;)V", "mappedOptions", "", "", "Lorg/kingdoms/gui/GUIMultiPagination$MappedOption;", "paginate", "", "option", "collection", "MappedOption", "core"})
public final class GUIMultiPagination<T> {
    @NotNull
    private final InteractiveGUI gui;
    private final int page;
    @NotNull
    private final Consumer<Integer> openPage;
    @NotNull
    private final Map<String, MappedOption> mappedOptions;

    public GUIMultiPagination(@NotNull InteractiveGUI gui, int page, @NotNull Consumer<Integer> openPage) {
        Intrinsics.checkNotNullParameter((Object)gui, (String)"gui");
        Intrinsics.checkNotNullParameter(openPage, (String)"openPage");
        this.gui = gui;
        this.page = page;
        this.openPage = openPage;
        this.mappedOptions = new HashMap();
    }

    @NotNull
    public final Collection<MappedOption> paginate() {
        MappedOption option;
        int maxSlotCount = 0;
        int maxItems = 0;
        Iterator<Map.Entry<String, MappedOption>> iterator = this.mappedOptions.entrySet().iterator();
        while (iterator.hasNext()) {
            option = iterator.next().getValue();
            maxSlotCount = RangesKt.coerceAtLeast((int)maxSlotCount, (int)option.getOption().slotsCount());
            maxItems = RangesKt.coerceAtLeast((int)maxItems, (int)option.getCollection().size());
        }
        iterator = this.mappedOptions.entrySet().iterator();
        while (iterator.hasNext()) {
            option = iterator.next().getValue();
            int slots = option.getOption().slotsCount();
            option.setCollection(CollectionsKt.take((Iterable)CollectionsKt.drop((Iterable)option.getCollection(), (int)(this.page * slots)), (int)slots));
        }
        int maxPages = MathUtils.getPageNumbers(maxItems, maxSlotCount);
        this.gui.getSettings().raw("pages", maxPages);
        this.gui.getSettings().raw("page", this.page + 1);
        this.gui.option("previous-page").onNormalClicks(arg_0 -> GUIMultiPagination.paginate$lambda-0(this, arg_0)).done();
        this.gui.option("next-page").onNormalClicks(arg_0 -> GUIMultiPagination.paginate$lambda-1(this, maxPages, arg_0)).done();
        return this.mappedOptions.values();
    }

    @Nullable
    public final <T> MappedOption paginate(@NotNull String option, @Nullable Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        ReusableOptionHandler reusableOptionHandler = this.gui.getReusableOption(option);
        if (reusableOptionHandler == null) {
            return null;
        }
        ReusableOptionHandler holder = reusableOptionHandler;
        Collection<T> collection2 = collection;
        if (collection2 == null || collection2.isEmpty()) {
            return null;
        }
        Object t = Fn.cast(collection);
        Intrinsics.checkNotNullExpressionValue(t, (String)"cast(collection)");
        MappedOption mapped = new MappedOption(holder, (Collection)t);
        this.mappedOptions.put(option, mapped);
        return mapped;
    }

    private static final void paginate$lambda-0(GUIMultiPagination this$0, OptionHandler ctx) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (this$0.page == 0) {
            ctx.sendError(KingdomsLang.GUIS_PAGES_PREVIOUS_PAGE_NOT_AVAILABLE, new Object[0]);
            return;
        }
        this$0.openPage.accept(this$0.page - 1);
    }

    private static final void paginate$lambda-1(GUIMultiPagination this$0, int $maxPages, OptionHandler ctx) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (this$0.page + 1 >= $maxPages) {
            ctx.sendError(KingdomsLang.GUIS_PAGES_NEXT_PAGE_NOT_AVAILABLE, new Object[0]);
            return;
        }
        this$0.openPage.accept(this$0.page + 1);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\b\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/kingdoms/gui/GUIMultiPagination$MappedOption;", "", "option", "Lorg/kingdoms/gui/ReusableOptionHandler;", "collection", "", "(Lorg/kingdoms/gui/GUIMultiPagination;Lorg/kingdoms/gui/ReusableOptionHandler;Ljava/util/Collection;)V", "getCollection", "()Ljava/util/Collection;", "setCollection", "(Ljava/util/Collection;)V", "getOption", "()Lorg/kingdoms/gui/ReusableOptionHandler;", "core"})
    public final class MappedOption {
        @NotNull
        private final ReusableOptionHandler option;
        @NotNull
        private Collection<? extends T> collection;

        public MappedOption(@NotNull ReusableOptionHandler option, Collection<? extends T> collection) {
            Intrinsics.checkNotNullParameter((Object)option, (String)"option");
            Intrinsics.checkNotNullParameter(collection, (String)"collection");
            this.option = option;
            this.collection = collection;
        }

        @NotNull
        public final ReusableOptionHandler getOption() {
            return this.option;
        }

        @NotNull
        public final Collection<T> getCollection() {
            return this.collection;
        }

        public final void setCollection(@NotNull Collection<? extends T> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
            this.collection = collection;
        }
    }
}

