/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.gui;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.gui.GUIOption;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.InventoryInteractiveGUI;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.chat.ChatInputManager;
import org.kingdoms.utils.internal.integer.IntHashMap;
import org.kingdoms.utils.string.StringUtils;

public final class InteractiveGUIManager
implements Listener {
    protected static final IntHashMap<InteractiveGUI> GUIS = new IntHashMap();

    public static IntHashMap<InteractiveGUI> getGuis() {
        return GUIS;
    }

    private static boolean end(Player player) {
        InteractiveGUI gui = GUIS.remove(player.getEntityId());
        if (gui != null) {
            gui.handleClosing();
        }
        return true;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (!ChatInputManager.isConversing(player)) {
            return;
        }
        KingdomsLang.GUIS_COMMAND_DURING_INPUT.sendError((CommandSender)player, new Object[0]);
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onOtherGUIOpen(InventoryOpenEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (!ChatInputManager.isConversing(player)) {
            return;
        }
        KingdomsLang.GUIS_OPEN_INVENTORY_DURING_INPUT.sendError((CommandSender)player, new Object[0]);
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onKingdomsGUIOpen(InventoryOpenEvent event) {
        InteractiveGUI gui = GUIS.get(event.getPlayer().getEntityId());
        if (gui == null) {
            return;
        }
        gui.performOpenActions();
    }

    @EventHandler(ignoreCancelled=true)
    public void onDrag(InventoryDragEvent event) {
        ItemStack leftOver;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        InteractiveGUI interactiveGUI = GUIS.get(player.getEntityId());
        if (!(interactiveGUI instanceof InventoryInteractiveGUI)) {
            return;
        }
        InventoryInteractiveGUI gui = (InventoryInteractiveGUI)interactiveGUI;
        Map<Integer, ItemStack> interactable = gui.getInteractableMap(false);
        if (interactable.isEmpty()) {
            event.setCancelled(true);
            return;
        }
        int invSize = event.getInventory().getSize();
        boolean isAllOutside = true;
        boolean needsManualModification = false;
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            if (slot >= invSize && isAllOutside) continue;
            isAllOutside = false;
            if (interactable.containsKey(slot)) continue;
            needsManualModification = true;
            break;
        }
        if (isAllOutside) {
            return;
        }
        if (!needsManualModification) {
            Consumer<InventoryInteractEvent> handler = gui.getOnInteractableSlot();
            if (handler != null) {
                handler.accept((InventoryInteractEvent)event);
            }
            return;
        }
        event.setCancelled(true);
        if (event.getCursor() == null) {
            leftOver = event.getOldCursor();
            leftOver.setAmount(0);
        } else {
            leftOver = event.getCursor();
        }
        for (Map.Entry item : event.getNewItems().entrySet()) {
            if ((Integer)item.getKey() < invSize && interactable.containsKey(item.getKey())) {
                event.getInventory().setItem(((Integer)item.getKey()).intValue(), (ItemStack)item.getValue());
                continue;
            }
            if ((Integer)item.getKey() >= invSize) {
                int slot = (Integer)item.getKey() - invSize;
                slot = slot > 26 ? (slot -= 27) : (slot += 9);
                player.getInventory().setItem(slot, (ItemStack)item.getValue());
                continue;
            }
            leftOver.setAmount(leftOver.getAmount() + ((ItemStack)item.getValue()).getAmount());
        }
        Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> player.getOpenInventory().setCursor(leftOver), 1L);
        Consumer<InventoryInteractEvent> handler = gui.getOnInteractableSlot();
        if (handler != null) {
            handler.accept((InventoryInteractEvent)event);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onClick(InventoryClickEvent event) {
        Map<ClickType, Runnable> options;
        Runnable runnable;
        if (event.getAction() == InventoryAction.NOTHING) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Inventory inventory = event.getClickedInventory();
        if (inventory == null) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        InteractiveGUI interactiveGUI = GUIS.get(player.getEntityId());
        if (!(interactiveGUI instanceof InventoryInteractiveGUI)) {
            return;
        }
        InventoryInteractiveGUI gui = (InventoryInteractiveGUI)interactiveGUI;
        if (inventory.getType() == InventoryType.PLAYER) {
            if (event.getClick() == ClickType.DOUBLE_CLICK) {
                event.setCancelled(true);
                return;
            }
            if (event.getCurrentItem() != null && event.isShiftClick()) {
                Map<Integer, ItemStack> interactableSlots = gui.getInteractableMap(false);
                event.setCancelled(true);
                if (interactableSlots.isEmpty()) {
                    return;
                }
                List<ItemStack> left = XItemStack.addItems(player.getOpenInventory().getTopInventory(), false, interactableSlots::containsKey, event.getCurrentItem());
                if (left.isEmpty()) {
                    event.setCurrentItem(null);
                } else {
                    event.setCurrentItem(left.get(0));
                }
                Consumer<InventoryInteractEvent> handler = gui.getOnInteractableSlot();
                if (handler != null) {
                    handler.accept((InventoryInteractEvent)event);
                }
                player.updateInventory();
            }
            return;
        }
        GUIOption option = gui.getAction(event.getSlot());
        if (option == null) {
            if (gui.canInteract(event.getSlot())) {
                Consumer<InventoryInteractEvent> handler = gui.getOnInteractableSlot();
                if (handler != null) {
                    handler.accept((InventoryInteractEvent)event);
                }
                return;
            }
            event.setCancelled(true);
            return;
        }
        switch (option.getSettings().getInteractionType()) {
            case DISALLOW: {
                event.setCancelled(true);
                break;
            }
            case TAKE_ONLY: {
                if (event.getCursor() == null) break;
                event.setCancelled(true);
                break;
            }
        }
        if (option.getRunnables() != null && (runnable = (options = option.getRunnables()).get(event.getClick())) != null) {
            try {
                runnable.run();
            }
            catch (Exception ex) {
                MessageHandler.sendConsolePluginMessage("&cAn exception has occurred while handling GUI option &e" + option.getName() + " &cin GUI &e" + gui.getName() + " &cfor player &e" + player.getName() + " &7(&ev" + Kingdoms.get().getDescription().getVersion() + "&7) &8:");
                ex.printStackTrace();
            }
        }
        StringUtils.performCommands((OfflinePlayer)player, option.getSettings().getCommands());
        XSound.Record sound = option.getSettings().getSound();
        if (sound != null) {
            sound.forPlayer(player).play();
        }
        if (option.getSettings().getMessage() != null) {
            option.getSettings().getMessage().getSimpleProvider().send((CommandSender)player, new MessageBuilder().withContext(player));
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (ChatInputManager.isConversing(player)) {
            return;
        }
        InteractiveGUI gui = GUIS.get(player.getEntityId());
        if (gui == null) {
            return;
        }
        if (!gui.wasSwitched()) {
            GUIS.remove(player.getEntityId());
        }
        if (!gui.wasRefreshed()) {
            gui.handleClosing();
        }
        gui.onCloseEvent();
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        InteractiveGUIManager.end(event.getPlayer());
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        InteractiveGUIManager.end(event.getEntity());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onDamage(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (!KingdomsConfig.GUIS_CLOSE_ON_DAMAGE.getBoolean()) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (GUIS.containsKey(player.getEntityId())) {
            player.closeInventory();
        }
    }
}

