/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.gui;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.kingdoms.gui.GUIOption;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.xseries.SkullUtils;
import org.kingdoms.locale.ContextualMessenger;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.cache.EnumCache;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.enumeration.QuickEnumMap;

public class OptionHandler
implements ContextualMessenger {
    protected final String holder;
    protected final InteractiveGUI gui;
    protected Function<ItemStack, ItemStack> itemHandler;
    protected MessageBuilder settings;
    protected Consumer<String> conversation;
    protected Map<ClickType, Runnable> handlers = new QuickEnumMap((Enum[])EnumCache.CLICK_TYPES);
    protected GUIOption object;

    protected OptionHandler(InteractiveGUI gui, String holder) {
        this.gui = gui;
        this.holder = holder;
        this.settings = new MessageBuilder();
    }

    public OptionHandler editItem(Function<ItemStack, ItemStack> itemHandler) {
        this.itemHandler = itemHandler;
        return this;
    }

    public OptionHandler setEdits(Object ... edits) {
        this.settings.raws(edits);
        return this;
    }

    public String getName() {
        return this.holder;
    }

    public OptionHandler setConversation(BiConsumer<OptionHandler, String> conversation) {
        this.conversation = input -> {
            this.settings.raw("arg", input);
            conversation.accept(this, (String)input);
        };
        return this;
    }

    public OptionHandler setConversation(Consumer<String> conversation) {
        this.conversation = conversation;
        return this;
    }

    public OptionHandler setSettings(MessageBuilder settings) {
        this.settings = settings;
        return this;
    }

    public OptionHandler onNormalClicks(Runnable runnable) {
        Objects.requireNonNull(runnable);
        this.handlers.put(ClickType.LEFT, runnable);
        this.handlers.put(ClickType.RIGHT, runnable);
        return this;
    }

    public void startConversation() {
        if (this.object == null) {
            throw new IllegalStateException("Cannot start a conversation for an option that's not pushed to the GUI: " + this.holder + " in GUI " + this.gui.getName());
        }
        this.gui.startConversation(this.object, false);
    }

    public OptionHandler onNormalClicks(Consumer<OptionHandler> consumer) {
        Objects.requireNonNull(consumer);
        Runnable runnable = () -> consumer.accept(this);
        this.handlers.put(ClickType.LEFT, runnable);
        this.handlers.put(ClickType.RIGHT, runnable);
        return this;
    }

    public void pushHead(OfflinePlayer player) {
        this.pushHead(player, true);
    }

    public void pushHead(OfflinePlayer player, boolean changeCtx) {
        if (player != null) {
            if (changeCtx) {
                this.settings.withContext(player);
            }
            this.settings.parse("online", (player.isOnline() ? KingdomsLang.PLAYERS_ONLINE : KingdomsLang.PLAYERS_OFFLINE).parse(player, new Object[0]));
            this.itemHandler = item -> {
                ItemMeta meta = item.getItemMeta();
                if (meta instanceof SkullMeta) {
                    SkullUtils.applySkin(meta, player);
                    item.setItemMeta(meta);
                }
                return item;
            };
        }
        this.done();
    }

    public void endConversation() {
        this.gui.endConversation();
    }

    public OptionHandler on(ClickType type, Runnable runnable) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(runnable);
        this.handlers.put(type, runnable);
        return this;
    }

    public OptionHandler on(ClickType type, Consumer<OptionHandler> consumer) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(consumer);
        this.handlers.put(type, () -> consumer.accept(this));
        return this;
    }

    public GUIOption constructGUIOptionObject() {
        this.settings.inheritContext(this.gui.getSettings());
        this.settings.inheritPlaceholders(this.gui.getSettings());
        return this.gui.constructOption(this.holder, this.settings);
    }

    public ConfigSection getConfig() {
        GUIOption opt = this.constructGUIOptionObject();
        return opt == null ? null : opt.getSettings().getConfig();
    }

    public void done() {
        this.object = this.gui.push(this);
    }

    @Override
    @NotNull
    public MessageBuilder getSettings() {
        return this.settings;
    }

    @Override
    @NotNull
    public CommandSender getSender() {
        return this.gui.getOwner();
    }
}

