/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.libs.snakeyaml.events;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kingdoms.libs.snakeyaml.common.Anchor;
import org.kingdoms.libs.snakeyaml.common.CharConstants;
import org.kingdoms.libs.snakeyaml.common.ScalarStyle;
import org.kingdoms.libs.snakeyaml.events.Event;
import org.kingdoms.libs.snakeyaml.events.NodeEvent;
import org.kingdoms.libs.snakeyaml.exceptions.Mark;

public final class ScalarEvent
extends NodeEvent {
    private final ScalarStyle style;
    private final String value;

    public ScalarEvent(Optional<Anchor> anchor, String value, ScalarStyle style, Mark startMark, Mark endMark) {
        super(anchor, startMark, endMark);
        this.value = Objects.requireNonNull(value);
        this.style = Objects.requireNonNull(style);
    }

    public ScalarEvent(Optional<Anchor> anchor, String value, ScalarStyle style) {
        this(anchor, value, style, null, null);
    }

    public ScalarStyle getScalarStyle() {
        return this.style;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public Event.ID getEventId() {
        return Event.ID.Scalar;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ScalarEvent{");
        this.getAnchor().ifPresent(a -> builder.append(" &").append(a));
        builder.append(' ');
        builder.append(this.style.toString());
        builder.append(this.escapedValue());
        return builder.append('}').toString();
    }

    public String escapedValue() {
        return this.value.codePoints().filter(i -> i < 65535).mapToObj(ch -> CharConstants.escapeChar(String.valueOf(Character.toChars(ch)))).collect(Collectors.joining(""));
    }
}

