/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler.builders;

import java.util.function.Function;
import net.md_5.bungee.api.chat.TextComponent;
import org.kingdoms.locale.LanguageEntry;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.MessagePiece;
import org.kingdoms.locale.compiler.builders.MessageObjectBuilder;
import org.kingdoms.locale.messenger.DefinedMessenger;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.locale.provider.MessageProvider;
import org.kingdoms.utils.XComponentBuilder;

public class RawLanguageEntryObjectBuilder
implements MessageObjectBuilder {
    private final LanguageEntry messagePath;
    private final Function<String, String> processor;

    public RawLanguageEntryObjectBuilder(DefinedMessenger message, Function<String, String> processor) {
        this.messagePath = message.getLanguageEntry();
        this.processor = processor;
    }

    private String toPlain(MessageBuilder _s) {
        MessageProvider message = _s.getLanguage().getMessage(this.messagePath, false);
        if (message == null) {
            return null;
        }
        String plain = message.getMessage().buildPlain(_s);
        try {
            return this.processor.apply(plain);
        }
        catch (Throwable ex) {
            throw new RuntimeException("Error while running raw language entry processor for entry: " + message, ex);
        }
    }

    @Override
    public XComponentBuilder build(TextComponent first, MessageBuilder _s) {
        String plain = this.toPlain(_s);
        if (plain != null) {
            return new XComponentBuilder(plain);
        }
        return null;
    }

    @Override
    public String buildPlain(MessageBuilder _s) {
        return this.toPlain(_s);
    }

    @Override
    public MessageObject evaluatePlaceholdersOnly(MessageBuilder _s) {
        return new MessageObject(new MessagePiece[]{new MessagePiece.Plain(this.toPlain(_s))}, false, MessageCompilerSettings.all());
    }
}

