/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.messenger;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.admin.CommandAdminTrack;
import org.kingdoms.config.AdvancedMessage;
import org.kingdoms.config.Comment;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.Path;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.libs.snakeyaml.exceptions.Mark;
import org.kingdoms.libs.snakeyaml.nodes.Node;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.LanguageEntry;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.locale.provider.MessageProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.internal.arrays.ArrayUtils;
import org.kingdoms.utils.string.StringUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&J\b\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0007H&J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0016\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/locale/messenger/DefinedMessenger;", "Lorg/kingdoms/locale/messenger/Messenger;", "getAdvancedData", "Lorg/kingdoms/config/AdvancedMessage;", "getComment", "Lorg/kingdoms/config/Comment;", "getDefaultValue", "", "getLanguageEntry", "Lorg/kingdoms/locale/LanguageEntry;", "getProvider", "Lorg/kingdoms/locale/provider/MessageProvider;", "locale", "Lorg/kingdoms/locale/SupportedLanguage;", "name", "sendMessage", "", "receiver", "Lorg/bukkit/command/CommandSender;", "builder", "Lorg/kingdoms/locale/provider/MessageBuilder;", "Companion", "core"})
public interface DefinedMessenger
extends Messenger {
    @NotNull
    public static final Companion Companion = org.kingdoms.locale.messenger.DefinedMessenger$Companion.$$INSTANCE;

    @Override
    @NotNull
    default public MessageProvider getProvider(@NotNull SupportedLanguage locale) {
        Intrinsics.checkNotNullParameter((Object)((Object)locale), (String)"locale");
        MessageProvider messageProvider = locale.getMessage(this.getLanguageEntry(), true);
        Intrinsics.checkNotNullExpressionValue((Object)messageProvider, (String)"locale.getMessage(getLanguageEntry(), true)");
        return messageProvider;
    }

    @NotNull
    public LanguageEntry getLanguageEntry();

    @Nullable
    default public Comment getComment() {
        Comment comment;
        try {
            comment = this.getClass().getField(this.name()).getAnnotation(Comment.class);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return comment;
    }

    @Nullable
    default public AdvancedMessage getAdvancedData() {
        AdvancedMessage advancedMessage;
        try {
            advancedMessage = this.getClass().getField(this.name()).getAnnotation(AdvancedMessage.class);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return advancedMessage;
    }

    @NotNull
    public String name();

    @Nullable
    public String getDefaultValue();

    @Override
    default public void sendMessage(@NotNull CommandSender receiver, @NotNull MessageBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (KingdomsConfig.PREFIX.getBoolean()) {
            builder.usePrefix(true);
        }
        SupportedLanguage supportedLanguage = receiver instanceof Player ? KingdomPlayer.getKingdomPlayer((OfflinePlayer)receiver).getLanguage() : builder.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)supportedLanguage), (String)"if (receiver is Player)\n\u2026         builder.language");
        SupportedLanguage locale = supportedLanguage;
        builder.lang(locale);
        if (CommandAdminTrack.isTracking(receiver) && this != KingdomsLang.COMMAND_ADMIN_TRACK_TRACKED && this != KingdomsLang.COMMAND_ADMIN_TRACK_GUI) {
            String file = StringsKt.replace$default((String)((Object)Kingdoms.getFolder().relativize(locale.getMainLanguageFile())).toString(), (char)' ', (char)'*', (boolean)false, (int)4, null);
            Node node = locale.getAdapter().getConfig().findNode(this.getLanguageEntry().getPath());
            Object object = node;
            if (object == null || (object = ((Node)object).getStartMark()) == null || (object = Integer.valueOf(((Mark)object).getLine()).toString()) == null) {
                object = KingdomsLang.UNKNOWN;
            }
            Object line = object;
            KingdomsLang.COMMAND_ADMIN_TRACK_TRACKED.getProvider(locale).send(receiver, new MessageBuilder().parse("path", StringUtils.join(this.getLanguageEntry().getPath(), " {$sep}-> {$s}")).raw("file", file).raw("raw", LanguageManager.getRawMessage(this, locale)).parse("line", line));
        }
        this.getProvider(locale).send(receiver, builder);
    }

    @JvmStatic
    @Nullable
    public static Path getAnnotatedPath(@NotNull DefinedMessenger $this$getAnnotatedPath) {
        return Companion.getAnnotatedPath($this$getAnnotatedPath);
    }

    @JvmStatic
    @NotNull
    public static LanguageEntry getEntry(@Nullable String prefix, @NotNull DefinedMessenger lang, @NotNull int[] group) {
        return Companion.getEntry(prefix, lang, group);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\bH\u0007\u00a8\u0006\r"}, d2={"Lorg/kingdoms/locale/messenger/DefinedMessenger$Companion;", "", "()V", "getEntry", "Lorg/kingdoms/locale/LanguageEntry;", "prefix", "", "lang", "Lorg/kingdoms/locale/messenger/DefinedMessenger;", "group", "", "getAnnotatedPath", "Lorg/kingdoms/config/Path;", "core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final Path getAnnotatedPath(@NotNull DefinedMessenger $this$getAnnotatedPath) {
            Path path;
            Intrinsics.checkNotNullParameter((Object)$this$getAnnotatedPath, (String)"<this>");
            try {
                path = $this$getAnnotatedPath.getClass().getField($this$getAnnotatedPath.name()).getAnnotation(Path.class);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            return path;
        }

        @JvmStatic
        @NotNull
        public final LanguageEntry getEntry(@Nullable String prefix, @NotNull DefinedMessenger lang, @NotNull int[] group) {
            Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Path annotatedPath = this.getAnnotatedPath(lang);
            if (annotatedPath != null) {
                return new LanguageEntry(annotatedPath.value());
            }
            int[] finalGroup = group;
            boolean isCommand = StringsKt.startsWith$default((String)lang.name(), (String)"COMMAND_", (boolean)false, (int)2, null);
            if (isCommand && group.length == 0) {
                int[] nArray;
                int[] nArray2;
                if (StringsKt.startsWith$default((String)lang.name(), (String)"COMMAND_ADMIN_", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)lang.name(), (String)"COMMAND_NATION_", (boolean)false, (int)2, null)) {
                    nArray2 = new int[]{1, 2, 3};
                    nArray = nArray2;
                } else {
                    nArray2 = new int[]{1, 2};
                    nArray = nArray2;
                }
                finalGroup = nArray;
            }
            List<String> list2 = StringUtils.split(StringUtils.getGroupedOption(lang.name(), Arrays.copyOf(finalGroup, finalGroup.length)), '.', false);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"split(StringUtils.getGro\u2026*finalGroup), '.', false)");
            Collection $this$toTypedArray$iv = list2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            String[] grouped = stringArray;
            if (prefix != null && !isCommand) {
                String[] stringArray2 = new String[]{prefix};
                String[] stringArray3 = ArrayUtils.merge(stringArray2, grouped);
                Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"merge(arrayOf(prefix), grouped)");
                grouped = stringArray3;
            }
            return new LanguageEntry(grouped);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

