/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.messenger;

import java.util.Objects;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.locale.provider.MessageProvider;

public interface Messenger {
    default public String parse(@Nullable Player player, Object ... edits) {
        return this.parse(LanguageManager.localeOf(player), new MessageBuilder().raws(edits).withContext(player));
    }

    default public String parse(MessageBuilder settings) {
        return this.parse(settings.getLanguage(), settings);
    }

    default public String parse(@Nullable OfflinePlayer player, Object ... edits) {
        return this.parse(LanguageManager.localeOf(player), new MessageBuilder().raws(edits).withContext(player));
    }

    default public String parse(SupportedLanguage locale, @NonNull MessageBuilder builder) {
        MessageObject obj = this.getMessageObject(locale);
        return obj == null ? null : obj.buildPlain(builder);
    }

    default public String parse(CommandSender sender, Object ... edits) {
        if (!(sender instanceof OfflinePlayer)) {
            return this.parse(edits);
        }
        return this.parse((OfflinePlayer)sender, edits);
    }

    public MessageProvider getProvider(SupportedLanguage var1);

    default public MessageObject getMessageObject(SupportedLanguage locale) {
        MessageProvider provider = this.getProvider(locale);
        return provider == null ? null : provider.getMessage();
    }

    default public String parse(Object ... edits) {
        return this.parse((Player)null, edits);
    }

    default public void sendError(CommandSender sender, MessageBuilder settings) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            KingdomsConfig.errorSound(player);
        }
        this.sendMessage(sender, settings);
    }

    default public void sendError(CommandSender sender, Object ... edits) {
        this.sendError(sender, new MessageBuilder().raws(edits).withContext(sender));
    }

    default public void sendMessage(CommandSender receiver, Object ... edits) {
        this.sendMessage(receiver, new MessageBuilder().raws(edits).withContext(receiver));
    }

    default public void sendMessage(CommandSender receiver, MessageBuilder builder) {
        if (KingdomsConfig.PREFIX.getBoolean()) {
            builder.usePrefix(true);
        }
        SupportedLanguage locale = builder.getLanguage();
        if (receiver instanceof Player) {
            Player player = (Player)receiver;
            locale = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player).getLanguage();
            builder.lang(locale);
        }
        SupportedLanguage finalLocale = locale;
        MessageProvider provider = Objects.requireNonNull(this.getProvider(locale), () -> "Message for locale '" + (Object)((Object)finalLocale) + "' is null: " + this);
        provider.send(receiver, builder);
    }

    default public void sendMessage(CommandSender receiver) {
        this.sendMessage(receiver, new MessageBuilder().withContext(receiver));
    }
}

