/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.main;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.commands.KingdomsCommandHandler;
import org.kingdoms.commands.admin.CommandAdminResetConfigs;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.managers.ConfigManager;
import org.kingdoms.config.migration.ConfigMigrationHistory;
import org.kingdoms.constants.group.model.logs.AuditLogRegistry;
import org.kingdoms.constants.group.model.logs.StandardAuditLogRegistrar;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.RelationAttributeRegistry;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.group.upgradable.Powerup;
import org.kingdoms.constants.group.upgradable.champion.ChampionAbility;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.turrets.TurretRegistry;
import org.kingdoms.constants.metadata.KingdomMetadataRegistry;
import org.kingdoms.constants.player.KingdomPermissionRegistry;
import org.kingdoms.constants.player.KingdomsChatChannel;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.data.DataManager;
import org.kingdoms.data.KingdomsDataCenter;
import org.kingdoms.data.StartupCache;
import org.kingdoms.dependencies.Dependency;
import org.kingdoms.dependencies.DependencyManager;
import org.kingdoms.gui.GUIConfig;
import org.kingdoms.gui.InteractiveGUIManager;
import org.kingdoms.libs.xseries.ReflectionUtils;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.compiler.placeholders.StandardKingdomsPlaceholder;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.KingdomsBootstrapProvider;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.managers.ChairManager;
import org.kingdoms.managers.FlyManager;
import org.kingdoms.managers.GeneralizedEventWatcher;
import org.kingdoms.managers.JoinAndLeaveManager;
import org.kingdoms.managers.KingdomItemManager;
import org.kingdoms.managers.Masswar;
import org.kingdoms.managers.MetricsLoader;
import org.kingdoms.managers.PowerupManager;
import org.kingdoms.managers.PvPManager;
import org.kingdoms.managers.ReloadProtection;
import org.kingdoms.managers.abstraction.ProlongedTask;
import org.kingdoms.managers.backup.KingdomsBackup;
import org.kingdoms.managers.book.BookManager;
import org.kingdoms.managers.chat.ChatInputManager;
import org.kingdoms.managers.chat.KingdomChatChannelListener;
import org.kingdoms.managers.chunkrestoration.ChunkSnapshotManager;
import org.kingdoms.managers.entity.KingdomEntityManager;
import org.kingdoms.managers.entity.KingdomEntityRegistry;
import org.kingdoms.managers.invasions.InvasionManager;
import org.kingdoms.managers.inviterequests.JoinRequests;
import org.kingdoms.managers.land.ChunkManager;
import org.kingdoms.managers.land.KingdomItemGUIProtection;
import org.kingdoms.managers.land.LandChangeWatcher;
import org.kingdoms.managers.land.LandEffectsManager;
import org.kingdoms.managers.land.LandProtectionManager;
import org.kingdoms.managers.land.claiming.AutoClaimManager;
import org.kingdoms.managers.land.holograms.KingdomItemHologramManager;
import org.kingdoms.managers.land.protection.KingdomGuardManager;
import org.kingdoms.managers.land.protection.KingdomVaultManager;
import org.kingdoms.managers.land.protection.LandExplosionManager;
import org.kingdoms.managers.land.protection.LandPistonManager;
import org.kingdoms.managers.land.protection.MiscUpgradeManager;
import org.kingdoms.managers.logger.KingdomsLogger;
import org.kingdoms.managers.logger.LogManager;
import org.kingdoms.managers.mails.MailUserAgent;
import org.kingdoms.managers.protectionsign.ProtectionSignManager;
import org.kingdoms.managers.structures.FuelManager;
import org.kingdoms.managers.structures.RegulatorManager;
import org.kingdoms.managers.structures.SiegeManager;
import org.kingdoms.managers.teleportation.TpManager;
import org.kingdoms.managers.turrets.LandTurretCacheOptimizerWatcher;
import org.kingdoms.managers.turrets.ManualTurretHandler;
import org.kingdoms.managers.turrets.SoldierManager;
import org.kingdoms.managers.turrets.TurretFactory;
import org.kingdoms.scheduler.AsyncScheduledTasks;
import org.kingdoms.scheduler.BukkitSchedulerAdapter;
import org.kingdoms.scheduler.TaskScheduler;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.services.managers.SoftService;
import org.kingdoms.services.worldguard.ServiceWorldGuardSeven;
import org.kingdoms.utils.PaperUtils;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.config.adapters.YamlContainer;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.network.UpdateChecker;
import org.kingdoms.utils.nms.EntityFactory;
import org.kingdoms.utils.platform.CrossPlatformNotifier;
import org.kingdoms.utils.platform.JavaVersion;
import org.kingdoms.utils.platform.Platform;

public final class Kingdoms
extends JavaPlugin {
    static final CharSequence Hello = "Thank you for decompiling me, but there's nothing here :) You might find something useful in " + Masswar.class + " tho.";
    public static final String NBT = "Kingdoms";
    private static Kingdoms instance;
    private KingdomsDataCenter dataCenter;
    private boolean enabled = false;
    private boolean loaded = false;
    private boolean isDisabling;
    private DependencyManager dependencyManager;
    protected static TaskScheduler taskScheduler;
    private final KingdomsBootstrapProvider bootstrapProvider;
    private final JavaPlugin loader = this;
    private final ZonedDateTime compileTime;
    private final String compileCommitSHA;
    private long lastFullSave;
    private final KingdomPermissionRegistry permissionRegistery = new KingdomPermissionRegistry();
    private final RelationAttributeRegistry relationAttributeRegistry = new RelationAttributeRegistry();
    private final AuditLogRegistry auditLogRegistry = new AuditLogRegistry();
    private final KingdomMetadataRegistry metadataRegistry = new KingdomMetadataRegistry();

    public AuditLogRegistry getAuditLogRegistry() {
        return this.auditLogRegistry;
    }

    public KingdomPermissionRegistry getPermissionRegistery() {
        return this.permissionRegistery;
    }

    public RelationAttributeRegistry getRelationAttributeRegistry() {
        return this.relationAttributeRegistry;
    }

    public KingdomMetadataRegistry getMetadataRegistry() {
        return this.metadataRegistry;
    }

    public Kingdoms() {
        if (instance != null || this.enabled) {
            throw new IllegalStateException("Plugin loaded twice");
        }
        instance = this;
        if (!Platform.BUKKIT.isAvailable()) {
            throw new IllegalArgumentException("Your server doesn't seem to be running on a bukkit platform. Please contact the plugin developers.");
        }
        if (!ReflectionUtils.supports(9)) {
            throw new IllegalStateException("The plugin doesn't support 1.8 and below versions. Visit here for more info: https://github.com/CryptoMorin/KingdomsX/wiki/FAQ#support-for-18-and-lower-versions");
        }
        ReloadProtection.ensureLoadOnce();
        PaperUtils.init();
        ConfigSection pluginSettings = new ConfigSection(YamlContainer.getRootOf("plugin.yml", this.getResource("plugin.yml")));
        this.compileCommitSHA = Objects.requireNonNull(pluginSettings.getString("compile-master-sha"), () -> pluginSettings.getNode().toString());
        this.compileTime = DateTimeFormatter.ISO_INSTANT.withZone(ZoneOffset.UTC).parse((CharSequence)pluginSettings.getString("compile-time"), ZonedDateTime::from);
        this.bootstrapProvider = new KingdomsBootstrapProvider(this);
        taskScheduler = new BukkitSchedulerAdapter(this, this.bootstrapProvider);
    }

    public static boolean isLoaded() {
        return instance != null && Kingdoms.instance.loaded;
    }

    public static TaskScheduler taskScheduler() {
        return taskScheduler;
    }

    public static Kingdoms get() {
        return instance;
    }

    public JavaPlugin getLoader() {
        return this;
    }

    public boolean isDisabling() {
        return this.isDisabling;
    }

    private static void registerServices() {
        for (SoftService service : SoftService.values()) {
            if (!service.isAvailable()) continue;
            try {
                service.getService().enable();
            }
            catch (Throwable ex) {
                MessageHandler.sendConsolePluginMessage("&4Failed to register &e" + service.getName() + " &4services&8:");
                ex.printStackTrace();
            }
        }
        if (SoftService.VAULT.isAvailable()) {
            Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> {
                if (!ServiceVault.isAvailable(ServiceVault.Component.ECO)) {
                    KLogger.warn("Unable to start Vault economy services. Install an economy plugin before using Kingdoms economics.");
                }
                if (!ServiceVault.isAvailable(ServiceVault.Component.CHAT)) {
                    KLogger.warn("Unable to start Vault economy services. Install a prefix/suffix plugin (mostly managed by permission plugins).");
                }
                if (!ServiceVault.isAvailable(ServiceVault.Component.PERM)) {
                    KLogger.warn("Unable to start Vault economy services. Install a permission plugin before using Kingdoms permission checks.");
                }
            }, 0L);
        }
    }

    public void onLoad() {
        this.dependencyManager = new DependencyManager(this.bootstrapProvider);
        KLogger.info("Checking libraries...");
        if (JavaVersion.supports(11)) {
            Dependency.CAFFEINE.setVersion("3.1.5");
            Dependency.CAFFEINE.setChecksum("AsNP0rp4sZVu9uXemskVrum/pJhYmWb6hyVfuttlNJk=");
        }
        this.dependencyManager.loadDependencies(DependencyManager.REQUIRED_DEPENDENCIES);
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null && ReflectionUtils.supports(13)) {
            try {
                ServiceWorldGuardSeven.init();
            }
            catch (Throwable ex) {
                Kingdoms.get().getLogger().info("Successfully registered 'claimable' WorldGuard flag.");
                ex.printStackTrace();
            }
        }
        StandardKingdomPermission.init();
        StandardRelationAttribute.init();
        StandardAuditLogRegistrar.registerAll();
        this.loaded = true;
    }

    public String getCompileCommitSHA() {
        return this.compileCommitSHA;
    }

    public ZonedDateTime getCompileTime() {
        return this.compileTime;
    }

    public void onEnable() {
        if (!this.loaded) {
            this.getLogger().severe("-------------------------------------------------------------------");
            this.getLogger().severe("The plugin did not load correctly. Please check your startup logs.");
            this.getLogger().severe("-------------------------------------------------------------------");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        ReloadProtection.ensureLoadOnce();
        if (ConfigManager.getGlobals().getBoolean("reset-configs-on-next-start")) {
            KLogger.info("Detected config reset request...");
            CommandAdminResetConfigs.resetConfigs();
        }
        KingdomsConfig.init();
        ConfigManager manager = new ConfigManager(this);
        manager.createDataFolderIfMissing();
        ConfigManager.addAllConfigs();
        StandardKingdomsPlaceholder.init();
        LanguageManager.loadAll();
        if (KingdomsConfig.UPDATES_CONFIGS.getBoolean()) {
            ConfigMigrationHistory.applyMigrations();
            ConfigManager.updateConfigs();
        }
        StructureRegistry.init();
        TurretRegistry.init();
        KingdomsChatChannel.registerChannels();
        GUIConfig.init();
        if (KingdomsConfig.UPDATES_AUTOMATIC_CONFIG_RELOADS.getBoolean()) {
            manager.setupWatchService();
        }
        KingdomsPluginPermission.init();
        new KingdomsCommandHandler(this);
        Rank.init();
        Masswar.init(this);
        KingdomRelation.init();
        ChampionAbility.init();
        Powerup.init();
        SoftService.reportAvailability();
        JoinRequests.registerMetaHandlers();
        ProlongedTask.init();
        if (KingdomsConfig.Claims.RESTORATION_ENABLED.getManager().getBoolean()) {
            ChunkSnapshotManager.init();
        }
        this.dataCenter = new KingdomsDataCenter(this);
        if (KingdomsConfig.DATABASE_LOAD_ALL_DATA_ON_STARTUP.getBoolean()) {
            StartupCache.init(this);
        }
        if (KingdomsConfig.BACKUPS_ENABLED_ENABLED.getBoolean()) {
            new KingdomsBackup(this);
        }
        Kingdoms.registerServices();
        this.registerAllEvents();
        new UpdateChecker();
        MetricsLoader.init(this);
        manager.validateConfigs();
        Kingdoms.addLibsInfo(this.bootstrapProvider.getLibsFolder());
        CrossPlatformNotifier.warn();
        this.enabled = true;
    }

    public static Path getFolder() {
        return Kingdoms.get().loader.getDataFolder().toPath();
    }

    public static Path getPath(String path) {
        return Kingdoms.getFolder().resolve(path);
    }

    public void registerAllEvents() {
        GeneralizedEventWatcher.init();
        this.registerEvent(new LogManager());
        this.registerEvent(new ReloadProtection());
        this.registerEvent(new InteractiveGUIManager());
        this.registerEvent(new JoinAndLeaveManager());
        this.registerEvent(new AutoClaimManager());
        this.registerEvent(new PowerupManager());
        this.registerEvent(new KingdomItemManager());
        if (!PvPManager.isPvPType(PvPManager.PvPType.DISABLED)) {
            this.registerEvent(new PvPManager());
        }
        this.registerEvent(new InvasionManager());
        this.registerEvent(new KingdomEntityManager());
        this.registerEvent(new TpManager());
        this.registerEvent(new ChatInputManager());
        this.registerEvent(new KingdomGuardManager());
        this.registerEvent(new ChairManager());
        this.registerEvent(new BookManager());
        this.registerEvent(new JoinRequests());
        this.registerEvent(new RegulatorManager());
        this.registerEvent(new SiegeManager());
        this.registerEvent(new FuelManager());
        this.registerEvent(new MailUserAgent());
        this.registerEvent(new KingdomVaultManager());
        this.registerEvent(new ChunkManager());
        this.registerEvent(new KingdomItemHologramManager());
        this.registerEvent(new MiscUpgradeManager());
        this.registerEvent(new LandExplosionManager());
        this.registerEvent(new LandPistonManager());
        this.registerEvent(new LandChangeWatcher());
        this.registerEvent(new LandProtectionManager());
        this.registerEvent(new KingdomItemGUIProtection());
        this.registerEvent(new LandEffectsManager());
        if (XMaterial.supports(13)) {
            if (KingdomsConfig.Claims.BEACON_PROTECTED_EFFECTS.getManager().getBoolean()) {
                this.registerEvent(new LandEffectsManager.BeaconManager());
            }
            this.registerEvent(new InvasionManager.AdvancedInvasionManager());
        }
        new KingdomChatChannelListener(this);
        if (KingdomsConfig.KINGDOM_FLY_ENABLED.getBoolean()) {
            this.registerEvent(new FlyManager());
        }
        if (KingdomsConfig.ProtectionSigns.ENABLED.getManager().getBoolean()) {
            this.registerEvent(new ProtectionSignManager(this));
        }
        if (KingdomsConfig.Turrets.ENABLED.getManager().getBoolean()) {
            this.registerEvent(new TurretFactory());
            this.registerEvent(new ManualTurretHandler());
            this.registerEvent(new SoldierManager());
            this.registerEvent(new LandTurretCacheOptimizerWatcher());
        }
    }

    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    static void addLibsInfo(Path path) {
        try {
            Files.write(path.resolve("README.txt"), Arrays.asList("For all information regarding what these files are, visit:", "https://github.com/CryptoMorin/KingdomsX/wiki/Installation#libraries"), StandardCharsets.US_ASCII, new OpenOption[0]);
        }
        catch (IOException e) {
            KLogger.error("Failed to add info file to libs folder:");
            e.printStackTrace();
        }
    }

    private void registerEvent(Listener listener) {
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)this.loader);
    }

    public void saveAllData() {
        KLogger.debug((DebugNS)KingdomsDebug.SAVE_ALL, "Saving all data");
        this.lastFullSave = System.currentTimeMillis();
        Objects.requireNonNull(this.dataCenter, "Plugin data handler is null");
        for (DataManager<?, ?> dataManager : this.dataCenter.getAllDataManagers()) {
            this.getLogger().info("Saving " + dataManager.getDisplayName() + "...");
            dataManager.saveAll(true);
        }
    }

    public void signalFullSave() {
        Duration lastSave = Duration.ofMillis(this.lastFullSave);
        Duration shouldSaveAter = lastSave.plus(Duration.ofSeconds(30L));
        Duration current = Duration.ofMillis(System.currentTimeMillis());
        if (!current.minus(shouldSaveAter).isNegative()) {
            this.saveAllData();
        }
    }

    public void onDisable() {
        this.isDisabling = true;
        if (!this.loaded || !this.enabled) {
            this.getLogger().severe("Plugin did not load properly to disable normally. Force disabling...");
            return;
        }
        ConfigManager.onDisable();
        if (KingdomsConfig.Claims.RESTORATION_ENABLED.getManager().getBoolean()) {
            KLogger.info("Finalizing chunk snapshots...");
            ChunkSnapshotManager.finishTasks();
        }
        KLogger.info("Disabling thread workers...");
        taskScheduler.shutdownScheduler();
        taskScheduler.shutdownExecutor();
        for (Map.Entry<BukkitTask, Runnable> task : AsyncScheduledTasks.getTasks().entrySet()) {
            task.getValue().run();
            task.getKey().cancel();
        }
        KLogger.info("Closing the logger...");
        KingdomsLogger.getMain().close();
        this.getLogger().info("Unregistering plugin services...");
        for (SoftService service : SoftService.values()) {
            if (!service.isAvailable()) continue;
            try {
                service.getService().disable();
            }
            catch (Throwable ex) {
                MessageHandler.sendConsolePluginMessage("&4Failed to disable &e" + service.getName() + " &4services&8:");
                ex.printStackTrace();
            }
        }
        this.getLogger().info("Removing kingdom mobs...");
        KingdomEntityRegistry.removeAllKingdomMobs();
        this.getLogger().info("Removing temporary entities...");
        ChairManager.removeAll();
        EntityFactory.removeAllTemporaryEntities();
        this.getLogger().info("Removing temporary items...");
        BookManager.removeAll();
        if (LandExplosionManager.REGENERATE) {
            this.getLogger().info("Force regenerating all exploded stuff...");
            LandExplosionManager.forceOngoingRegenerations();
        }
        this.signalFullSave();
        this.getLogger().info("Done, goodbye cruel world!");
    }

    public KingdomsDataCenter getDataCenter() {
        return this.dataCenter;
    }
}

