/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers;

import com.google.common.base.Enums;
import com.google.common.base.Strings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.ConditionProcessor;
import org.kingdoms.utils.ConfigCommand;
import org.kingdoms.utils.compilers.ConditionalCompiler;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;

public final class GeneralizedEventWatcher
implements Listener {
    private static final Listener INSTANCE = new GeneralizedEventWatcher();

    private GeneralizedEventWatcher() {
    }

    public static void init() {
        YamlConfigAccessor events = KingdomsConfig.EVENTS.getManager().getSection().noDefault();
        for (Map.Entry<String, ConfigSection> eventEntry : events.getSection().getSections().entrySet()) {
            Class<?> eventClass;
            try {
                Class<?> clazz = Class.forName(eventEntry.getKey());
                if (!Event.class.isAssignableFrom(clazz)) {
                    KLogger.error("The specified class '" + eventEntry.getKey() + "' is not an event.");
                    continue;
                }
                eventClass = clazz;
            }
            catch (ClassNotFoundException e) {
                KLogger.error("Unknown event: " + eventEntry.getKey());
                continue;
            }
            ConfigSection section = eventEntry.getValue();
            String priorityName = section.getString("priority");
            boolean ignoreCancelled = !section.isSet("ignore-cancelled") || section.getBoolean("ignore-cancelled");
            EventPriority priority = Strings.isNullOrEmpty((String)priorityName) ? EventPriority.NORMAL : (EventPriority)Enums.getIfPresent(EventPriority.class, (String)priorityName.toUpperCase(Locale.ENGLISH)).or((Object)EventPriority.NORMAL);
            ArrayList<Method> nativePlayerMethods = new ArrayList<Method>();
            ArrayList kingdomPlayerMethods = new ArrayList();
            ArrayList kingdomMethods = new ArrayList();
            ArrayList nationMethods = new ArrayList();
            HashMap<String, Method> otherGetters = new HashMap<String, Method>();
            for (Method method : eventClass.getMethods()) {
                ArrayList<Method> addTo;
                if (method.getParameterCount() > 0 || Modifier.isStatic(method.getModifiers())) continue;
                Class<Object> returnType = method.getReturnType();
                if (returnType.isAssignableFrom(Player.class)) {
                    addTo = nativePlayerMethods;
                } else if (returnType.isAssignableFrom(OfflinePlayer.class) || returnType.isAssignableFrom(KingdomPlayer.class)) {
                    addTo = kingdomPlayerMethods;
                } else if (returnType.isAssignableFrom(Kingdom.class)) {
                    addTo = kingdomMethods;
                } else if (returnType.isAssignableFrom(Nation.class)) {
                    addTo = nationMethods;
                } else {
                    otherGetters.put(method.getName(), method);
                    continue;
                }
                String targetName = method.getName();
                if (targetName.toLowerCase().startsWith("get")) {
                    targetName = targetName.substring(3);
                }
                addTo.add(method);
            }
            ArrayList<Pair<ConditionalCompiler.LogicalOperand, List<ConfigCommand>>> commands = new ArrayList<Pair<ConditionalCompiler.LogicalOperand, List<ConfigCommand>>>();
            ConfigSection cmdSection = section.getSection("commands");
            if (cmdSection != null) {
                for (String condition : cmdSection.getKeys()) {
                    commands.add(Pair.of(ConditionalCompiler.compile(condition).evaluate(), ConfigCommand.parse(cmdSection.getStringList(condition))));
                }
            } else {
                commands.add(Pair.of(ConditionalCompiler.ConstantLogicalOperand.TRUE, ConfigCommand.parse(section.getStringList("commands"))));
            }
            KLogger.debug((DebugNS)KingdomsDebug.GENERALIZED$EVENT$WATCHER, () -> "Watching event '" + eventClass.getName() + "' with methods:\n    native: " + nativePlayerMethods + '\n' + "    Kingdom Player: " + kingdomPlayerMethods + '\n' + "    Kingdom: " + kingdomMethods + '\n' + "    Nation: " + nationMethods);
            SimpleEventExecutor executor = new SimpleEventExecutor(commands, nativePlayerMethods, kingdomPlayerMethods, kingdomMethods, nationMethods, otherGetters);
            Bukkit.getPluginManager().registerEvent(eventClass, INSTANCE, priority, (EventExecutor)executor, (Plugin)Kingdoms.get(), ignoreCancelled);
        }
    }

    private static final class SimpleEventExecutor
    implements EventExecutor {
        private final List<Pair<ConditionalCompiler.LogicalOperand, List<ConfigCommand>>> commands;
        private final Map<String, Method> otherGetters;
        private final Method main;
        private final Method relationalSecond;

        private SimpleEventExecutor(List<Pair<ConditionalCompiler.LogicalOperand, List<ConfigCommand>>> commands, List<Method> nativePlayerMethods, List<Method> kingdomPlayerMethods, List<Method> kingdomMethods, List<Method> nationMethods, Map<String, Method> otherGetters) {
            this.commands = commands;
            this.otherGetters = otherGetters;
            Method main = null;
            Method relationalSecond = null;
            ArrayList<Method> all = new ArrayList<Method>(5);
            all.addAll(nativePlayerMethods);
            all.addAll(kingdomPlayerMethods);
            all.addAll(kingdomMethods);
            all.addAll(nationMethods);
            for (Method meth : all) {
                if (main == null) {
                    main = meth;
                    continue;
                }
                relationalSecond = meth;
                break;
            }
            this.main = main;
            this.relationalSecond = relationalSecond;
        }

        public void execute(@NotNull Listener listener, @NotNull Event event) throws EventException {
            try {
                Object player;
                MessageBuilder settings = new MessageBuilder();
                settings.main = this.main == null ? null : this.main.invoke((Object)event, new Object[0]);
                Object object = settings.relationalSecond = this.relationalSecond == null ? null : this.relationalSecond.invoke((Object)event, new Object[0]);
                if (settings.main instanceof Player) {
                    player = (Player)settings.main;
                } else if (settings.main instanceof OfflinePlayer) {
                    player = ((OfflinePlayer)settings.main).getPlayer();
                    if (player == null) {
                        settings.withContext((OfflinePlayer)settings.main);
                    }
                } else {
                    player = settings.main instanceof KingdomPlayer ? ((KingdomPlayer)settings.main).getPlayer() : null;
                }
                if (player != null) {
                    settings.withContext((Player)player);
                }
                settings.addGroupedPlaceholder("fn", id -> {
                    try {
                        return Objects.requireNonNull(this.otherGetters.get(id), () -> "Unknown function '" + id + "' for event " + event.getEventName()).invoke((Object)event, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException("Error while executing method " + id + " for event " + event.getEventName(), e);
                    }
                });
                for (Pair<ConditionalCompiler.LogicalOperand, List<ConfigCommand>> command : this.commands) {
                    if (!ConditionProcessor.process(command.getKey(), settings)) continue;
                    ConfigCommand.execute(player, (Collection<ConfigCommand>)command.getValue(), settings, true);
                }
            }
            catch (Throwable ex) {
                throw new EventException(ex, "An error occurred while handled generalized event: " + event.getClass().getName());
            }
        }
    }
}

