/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.xseries.XEnchantment;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.utils.cache.LazySupplier;
import org.kingdoms.utils.compilers.ConditionalCompiler;
import org.kingdoms.utils.compilers.MathCompiler;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.nbt.NBTWrappers;
import org.kingdoms.utils.string.StringCheckerOptions;
import org.kingdoms.utils.string.StringUtils;

public class ItemMatcher {
    private final StringCheckerOptions name;
    private final StringCheckerOptions lore;
    private final StringCheckerOptions material;
    private final int customModelData;
    private final List<Pair<XEnchantment, ConditionalCompiler.LogicalOperand>> enchants;
    private final Pair<String[], StringCheckerOptions>[] NBT;
    private final ConfigSection section;

    public ItemMatcher(ConfigSection section) {
        ConfigSection nbt;
        Objects.requireNonNull(section, "Cannot parse item matcher of a null section");
        this.section = section.getSection(new String[0]);
        String mat = section.getString("material");
        this.material = mat != null ? new StringCheckerOptions(mat) : null;
        this.customModelData = section.getInt("custom-model-data");
        String name = section.getString("name");
        this.name = name != null ? new StringCheckerOptions(name) : null;
        String lore = section.getString("lore");
        this.lore = lore != null ? new StringCheckerOptions(lore) : null;
        ConfigSection enchantsSection = section.getSection("enchants");
        if (enchantsSection != null) {
            this.enchants = new ArrayList<Pair<XEnchantment, ConditionalCompiler.LogicalOperand>>();
            for (String key : enchantsSection.getKeys()) {
                String conditionStr = enchantsSection.getString(key);
                int asLvl = enchantsSection.getInt(key);
                XEnchantment enchant = XEnchantment.matchXEnchantment(key).orElseThrow(() -> new IllegalArgumentException("Unknown enchantment: " + key));
                ConditionalCompiler.LogicalOperand condition = conditionStr.equals("*") ? ConditionalCompiler.ConstantLogicalOperand.TRUE : (asLvl == 0 && !conditionStr.equals("0") ? ConditionalCompiler.compile(conditionStr).evaluate() : new ConditionalCompiler.BiLogicalOperator(new ConditionalCompiler.LogicalVariableOperand("lvl"), ConditionalCompiler.LogicalOperator.EQUALS, new ConditionalCompiler.ArithmeticOperand(new MathCompiler.ConstantExpr(asLvl, MathCompiler.ConstantExprType.NUMBER))));
                this.enchants.add(Pair.of(enchant, condition));
            }
        } else {
            this.enchants = null;
        }
        if ((nbt = section.getSection("nbt")) != null) {
            Set<String> keys = nbt.getKeys();
            this.NBT = new Pair[keys.size()];
            int i = 0;
            for (String key : keys) {
                String[] splits = StringUtils.splitArray(key, '.');
                StringCheckerOptions checker = new StringCheckerOptions(nbt.getString(key));
                this.NBT[i++] = Pair.of(splits, checker);
            }
        } else {
            this.NBT = new Pair[0];
        }
    }

    public ConfigSection getSection() {
        return this.section;
    }

    public boolean matchesMaterial(ItemStack item) {
        return this.material == null || this.material.check(XMaterial.matchXMaterial(item).name());
    }

    public boolean matches(ItemStack item) {
        return this.matches(item, null);
    }

    public boolean matches(ItemStack item, LazySupplier<NBTWrappers.NBTTagCompound> nbt) {
        return this.matches(item, item.getItemMeta(), nbt);
    }

    public boolean matches(ItemStack item, ItemMeta meta, LazySupplier<NBTWrappers.NBTTagCompound> nbt) {
        if (!this.matchesMaterial(item)) {
            return false;
        }
        if (!this.matchesCustomModel(meta)) {
            return false;
        }
        if (!this.matchesEnchants(meta == null ? null : meta.getEnchants())) {
            return false;
        }
        if (!this.matchesName(meta) || !this.matchesLore(meta)) {
            return false;
        }
        return nbt == null || !this.needsNBT() || this.matchesNBT(nbt.get());
    }

    public boolean matchesEnchants(Map<Enchantment, Integer> enchants) {
        if (this.enchants == null) {
            return true;
        }
        if (this.enchants.isEmpty()) {
            return true;
        }
        if (enchants == null || enchants.isEmpty()) {
            return false;
        }
        for (Pair<XEnchantment, ConditionalCompiler.LogicalOperand> enchant : this.enchants) {
            Integer lvl = enchants.get(enchant.getKey().getEnchant());
            if (lvl == null) {
                return false;
            }
            ConditionalCompiler.LogicalOperand requiredLvl = enchant.getValue();
            boolean passed = (Boolean)requiredLvl.eval(x -> x.equals("lvl") ? lvl : null);
            if (passed) continue;
            return false;
        }
        return true;
    }

    public boolean needsNBT() {
        return this.NBT != null;
    }

    public boolean matchesName(ItemMeta meta) {
        if (this.name == null) {
            return true;
        }
        if (meta == null || !meta.hasDisplayName()) {
            return false;
        }
        return this.name.check(meta.getDisplayName());
    }

    public boolean matchesLore(ItemMeta meta) {
        if (this.lore == null) {
            return true;
        }
        if (meta == null || !meta.hasLore()) {
            return false;
        }
        for (String line : meta.getLore()) {
            if (!this.lore.check(line)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesCustomModel(ItemMeta meta) {
        if (!XMaterial.supports(14)) {
            return true;
        }
        if (this.customModelData == 0) {
            return true;
        }
        if (meta == null) {
            return false;
        }
        return meta.hasCustomModelData() && meta.getCustomModelData() == this.customModelData;
    }

    public boolean matchesNBT(NBTWrappers.NBTTagCompound nbt) {
        for (Pair<String[], StringCheckerOptions> tag : this.NBT) {
            NBTWrappers.NBTTagCompound last = null;
            int times = 0;
            for (String name : tag.getKey()) {
                ++times;
                NBTWrappers.NBTBase<?> current = (last == null ? nbt : last).get(name);
                if (current == null) {
                    return false;
                }
                if (current instanceof NBTWrappers.NBTTagCompound) {
                    last = (NBTWrappers.NBTTagCompound)current;
                    continue;
                }
                if (times == tag.getKey().length) {
                    Object value = current.getValue();
                    if (value == null) {
                        return false;
                    }
                    if (tag.getValue().check(value.toString())) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }
}

