/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.backup;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.data.KingdomsDataCenter;
import org.kingdoms.data.database.sql.DatabaseProperties;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.database.sql.SQLConnectionProvider;
import org.kingdoms.gui.GUIConfig;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.backup.BackupManager;
import org.kingdoms.utils.cache.CacheHandler;

public final class KingdomsBackup
extends BackupManager {
    private static final String NATIONS = KingdomsConfig.DATABASE_TABLES_NATIONS.getString();
    private static final String KINGDOMS = KingdomsConfig.DATABASE_TABLES_KINGDOMS.getString();
    private static final String LANDS = KingdomsConfig.DATABASE_TABLES_LANDS.getString();
    private static final String PLAYERS = KingdomsConfig.DATABASE_TABLES_PLAYERS.getString();
    private static final String MAILS = KingdomsConfig.DATABASE_TABLES_MAILS.getString();
    private static final String TURRETS = "Turrets";
    private static final String STRUCTURES = "Structures";
    private static final long INTERVAL_MILLIS = KingdomsConfig.BACKUPS_INTERVAL.getTimeMillis(TimeUnit.HOURS);

    public KingdomsBackup(Kingdoms plugin) {
        super(Kingdoms.getPath(KingdomsConfig.BACKUPS_FOLDER.getString()), Kingdoms.getFolder(), Kingdoms.taskScheduler().async());
        useMultiBackups = KingdomsConfig.BACKUPS_IGNORE_TODAYS_BACKUP.getBoolean();
        this.autoBackup();
    }

    public void autoBackup() {
        CacheHandler.newScheduler().scheduleAtFixedRate(this::takeBackup, 0L, INTERVAL_MILLIS, TimeUnit.MILLISECONDS);
    }

    @Override
    public void takeBackup() {
        MessageHandler.sendConsolePluginMessage("&2Taking a backup...");
        if (!useMultiBackups && this.hasBackupToday()) {
            MessageHandler.sendConsolePluginMessage("&2You already have a backup for today!");
            return;
        }
        this.deleteOldBackups(KingdomsConfig.BACKUPS_DELETE_BACKUPS_OLDER_THAN.getInt(), TimeUnit.DAYS);
        this.zipFiles().thenAccept(result -> MessageHandler.sendConsolePluginMessage("&2Backed up &6" + result + " &2files."));
    }

    private static void dumpRemoteDatabase(DatabaseType databaseType, DatabaseProperties databaseProperties, Path path) {
        String[] executeCmd;
        if (databaseType == DatabaseType.MySQL || databaseType == DatabaseType.MariaDB) {
            String tableNames = Stream.of("kingdoms", "nations", "players", "lands", "mails", "versions").map(x -> SQLConnectionProvider.TABLE_PREFIX + '_' + x).collect(Collectors.joining(" "));
            executeCmd = new String[]{"mysqldump", "--create-options", "--extended-insert", "--host=" + databaseProperties.address, "--port=" + databaseProperties.getPort(), "--user=" + databaseProperties.user, "--password=" + databaseProperties.password, "--databases", databaseProperties.databaseName, "--tables", tableNames, "-r", path.toAbsolutePath().toString()};
        } else if (databaseType == DatabaseType.PostgreSQL) {
            executeCmd = new String[]{"pg_dumpall", "--dbname=\"postgresql://" + databaseProperties.user + ':' + databaseProperties.password + '@' + databaseProperties.address.replace("localhost", "127.0.0.1") + ':' + databaseProperties.getPort() + '/' + databaseProperties.databaseName + '\"', "--table=" + SQLConnectionProvider.TABLE_PREFIX + '*', "--file=" + path.toAbsolutePath().toString()};
        } else if (databaseType == DatabaseType.MongoDB) {
            String collectionNames = Stream.of("kingdoms", "nations", "players", "lands", "mails", "versions").map(x -> SQLConnectionProvider.TABLE_PREFIX + '_' + x).collect(Collectors.joining(", "));
            executeCmd = new String[]{"mongodump", "--db", "minecraft", "--collection", collectionNames, "--host", databaseProperties.address, "--port", String.valueOf(databaseProperties.getPort()), "--username", databaseProperties.user, "--authenticationDatabase", "admin", "--password", databaseProperties.password, "--out", path.toAbsolutePath().toString()};
        } else {
            throw new IllegalArgumentException("Backups not supported for SQL: " + (Object)((Object)databaseType));
        }
        try {
            KLogger.info("Generating database dump for " + (Object)((Object)databaseType) + "...");
            Process runtimeProcess = Runtime.getRuntime().exec(executeCmd);
            int processComplete = runtimeProcess.waitFor();
            KLogger.info("Database dump for " + (Object)((Object)databaseType) + " returned " + processComplete);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isWhitelistedDirectory(@NonNull Path file) {
        String name = file.getFileName().toString();
        if (KingdomsConfig.BACKUPS_ENABLED_DATA.getBoolean() && (file.startsWith(KingdomsDataCenter.DATA_FOLDER) || name.equals(NATIONS) || name.equals(KINGDOMS) || name.equals(LANDS) || name.equals(MAILS) || name.equals(PLAYERS))) {
            return true;
        }
        if (KingdomsConfig.BACKUPS_ENABLED_CONFIGS.getBoolean()) {
            return name.equals(TURRETS) || name.equals(STRUCTURES) || file.startsWith(GUIConfig.getFolder()) || file.equals(LanguageManager.LANG_FOLDER);
        }
        return false;
    }

    @Override
    public boolean isWhitelistedFile(@NonNull Path file) {
        String name = file.getFileName().toString();
        return name.endsWith(".json") || KingdomsConfig.BACKUPS_ENABLED_CONFIGS.getBoolean() && name.endsWith(".yml");
    }

    @Override
    public Collection<Path> addToZip() {
        DatabaseType databaseType = Kingdoms.get().getDataCenter().getDatabaseType();
        if (databaseType != null) {
            Path path = Kingdoms.getPath("db.dump.temp.sql");
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            KingdomsBackup.dumpRemoteDatabase(databaseType, DatabaseProperties.defaults(databaseType), path);
            return Collections.singletonList(path);
        }
        return null;
    }
}

